/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.model.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum CognitiveLevel {
    COGNITIVELY_INTACT("Cognitively Intact"),
    MILDLY_IMPAIRED("Mildly Impaired"),
    MODERATELY_IMPAIRED("Moderately Impaired"),
    SEVERELY_IMPAIRED("Severely Impaired");

    private static final Map<String, CognitiveLevel> CACHE;
    private final String description;

    private CognitiveLevel(String description) {
        this.description = description;
    }

    public static Optional<CognitiveLevel> of(String key) {
        return Optional.ofNullable(CACHE.get(key));
    }

    public String getDescription() {
        return this.description;
    }

    static {
        CACHE = new HashMap<String, CognitiveLevel>();
        for (CognitiveLevel level : CognitiveLevel.values()) {
            CACHE.put(level.getDescription(), level);
        }
    }
}

