/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.util;

import gov.cms.grouper.snf.SnfContext;
import gov.cms.grouper.snf.SnfTables;
import gov.cms.grouper.snf.model.Assessment;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.model.table.BasicRow;
import gov.cms.grouper.snf.model.table.PerformanceRecodeRow;
import gov.cms.grouper.snf.r2.logic.nursing.RaiSets;
import gov.cms.grouper.snf.util.Lazy;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ClaimInfo {
    private final int dataVersion;
    private final Map<String, Assessment> byItem;
    private final boolean hasIpa;
    private final Supplier<Integer> functionScoreCache;

    public ClaimInfo(int dataVersion, boolean hasIpa, Map<String, Assessment> assessmentMap) {
        this.dataVersion = dataVersion;
        this.hasIpa = hasIpa;
        this.byItem = assessmentMap;
        this.functionScoreCache = new Lazy<Integer>(() -> {
            Set<Rai300> bedMobility = this.hasIpa() ? RaiSets.BED_MOBILITY_IPA.getSet() : RaiSets.BED_MOBILITY_NON_IPA.getSet();
            Set<Rai300> transfer = this.hasIpa() ? RaiSets.TRANSFER_IPA.getSet() : RaiSets.TRANSFER_NON_IPA.getSet();
            Set<Rai300> eatToilet = this.hasIpa() ? RaiSets.EATING_AND_TOILET_IPA.getSet() : RaiSets.EATING_AND_TOILET_NON_IPA.getSet();
            return this.calculateFunctionScore((claim, raiString) -> claim.performanceRecode(() -> claim.getAssessmentValue(Rai300.valueOf(raiString))), bedMobility, transfer, Collections.emptySet(), eatToilet);
        });
    }

    public static ClaimInfo of(int version, boolean ipa, List<Assessment> assessments) {
        Map<String, Assessment> assessmentMap = assessments.stream().collect(Collectors.toMap(Assessment::getItem, assessment -> assessment));
        return new ClaimInfo(version, ipa, assessmentMap);
    }

    public static ClaimInfo of(int version, boolean ipa, Map<String, Assessment> assessmentMap) {
        return new ClaimInfo(version, ipa, assessmentMap);
    }

    public static List<String> getString(Collection<Rai300> items, String logKey) {
        return SnfContext.trace(logKey, items.stream().map(Enum::name).collect(Collectors.toList()));
    }

    public boolean hasIpa() {
        return this.hasIpa;
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public int getAssessmentValue(Rai300 field) {
        Assessment foundAssessment = this.byItem.get(field.name());
        return foundAssessment == null ? Integer.MIN_VALUE : foundAssessment.getValueInt();
    }

    public Assessment getAssessment(Rai300 field) {
        return this.byItem.get(field.name());
    }

    public void logPresentAssessments(Collection<Rai300> rai300s, String messageKey) {
        SnfContext.trace(messageKey + " assessments present", rai300s.stream().map(Enum::name).filter(name -> this.byItem.containsKey(name) && this.byItem.get(name).isCheck()).collect(Collectors.toList()));
    }

    public boolean isAnyAssessmentValuesPresent(Collection<Rai300> rai300s, String messageKey) {
        if (messageKey != null && !messageKey.isEmpty()) {
            this.logPresentAssessments(rai300s, messageKey);
        }
        return rai300s.stream().map(Enum::name).anyMatch(name -> this.byItem.containsKey(name) && this.byItem.get(name).isCheck());
    }

    public boolean isAnyAssessmentValuesGreaterThanN(Collection<Rai300> rai300s, int n) {
        return rai300s.stream().map(Enum::name).anyMatch(name -> this.byItem.containsKey(name) && this.byItem.get(name).getValueInt() > n);
    }

    public boolean isCheckedAndNotNull(Rai300 rai300) {
        return this.isAnyAssessmentValuesPresent(Collections.singletonList(rai300), "");
    }

    public int countAssessmentPresent(Collection<Rai300> rai300s) {
        int result = (int)rai300s.stream().map(Enum::name).filter(name -> {
            boolean rs = this.byItem.get(name) != null && this.byItem.get(name).isCheck();
            return rs;
        }).count();
        return result;
    }

    public static Set<String> getNtaCategories(Collection<SnfDiagnosisCode> codes) {
        return codes.stream().map(SnfDiagnosisCode::getNtaCategory).collect(Collectors.toSet());
    }

    public boolean hasAssessmentOf(Rai300 field, Predicate<Assessment> condition) {
        Assessment ast = this.byItem.get(field.name());
        return ast != null && condition.test(ast);
    }

    public static boolean isClassifiedBehavioralSymptomsCognitivePerformance(Supplier<Integer> b0700Supplier, Supplier<Integer> c0700Supplier, Supplier<Integer> c1000Supplier, Supplier<Boolean> isComaAndNoActivities) {
        int c1000;
        int c0700;
        int b0700 = b0700Supplier.get();
        return ClaimInfo.meetsCombinedCriteria(b0700, c0700 = c0700Supplier.get().intValue(), c1000 = c1000Supplier.get().intValue()) || c1000 == 3 || isComaAndNoActivities.get() != false;
    }

    private static boolean meetsCombinedCriteria(int b0700, int c0700, int c1000) {
        int count = 0;
        if (b0700 > 0) {
            ++count;
        }
        if (c0700 == 1) {
            ++count;
        }
        if (c1000 > 0) {
            ++count;
        }
        return count >= 2 && (b0700 >= 2 || c1000 >= 2);
    }

    public int performanceRecode(Supplier<Integer> score) {
        PerformanceRecodeRow row = SnfTables.get(SnfTables.performanceRecodeTable, score.get(), BasicRow::isVersion, this.dataVersion);
        if (row != null) {
            return row.getFunctionScore();
        }
        return 0;
    }

    public int getFunctionScore() {
        return this.functionScoreCache.get();
    }

    protected int calculateFunctionScore(BiFunction<ClaimInfo, String, Integer> functionalAssessments, Collection<Rai300> bedMobilityList, Collection<Rai300> transferList, Collection<Rai300> walkingList, Collection<Rai300> generalItemList) {
        Predicate<Rai300> predicate = rai -> this.getAssessment((Rai300)((Object)rai)) != null && this.getAssessment((Rai300)((Object)rai)).getValueInt() != Integer.MIN_VALUE;
        List<Rai300> bedMobility = bedMobilityList.stream().filter(predicate).collect(Collectors.toList());
        List<Rai300> transfer = transferList.stream().filter(predicate).collect(Collectors.toList());
        List<Rai300> walking = walkingList.stream().filter(predicate).collect(Collectors.toList());
        List<Rai300> generalItem = generalItemList.stream().filter(predicate).collect(Collectors.toList());
        return this.calculateFunctionScoreString(functionalAssessments, ClaimInfo.getString(bedMobility, "BED"), ClaimInfo.getString(transfer, "TRANSFER"), ClaimInfo.getString(walking, "WALKING"), ClaimInfo.getString(generalItem, "GENERAL"));
    }

    public int calculateFunctionScoreString(BiFunction<ClaimInfo, String, Integer> functionalAssessments, Collection<String> bedMobilityList, Collection<String> transferList, Collection<String> walkingList, Collection<String> generalItemList) {
        int scale = 3;
        BigDecimal avgBedMobility = SnfContext.trace("Bed average score", this.sumAssessments(bedMobilityList, functionalAssessments, "Bed Mobility").divide(new BigDecimal(2), 3, RoundingMode.HALF_UP));
        BigDecimal avgTransfer = SnfContext.trace("Transfer average score", this.sumAssessments(transferList, functionalAssessments, "Transfer").divide(new BigDecimal(3), 3, RoundingMode.HALF_UP));
        BigDecimal avgWalking = SnfContext.trace("Walking average score", this.sumAssessments(walkingList, functionalAssessments, "Walking").divide(new BigDecimal(2), 3, RoundingMode.HALF_UP));
        BigDecimal generalItemSum = SnfContext.trace("General score", this.sumAssessments(generalItemList, functionalAssessments, "General"));
        BigDecimal result = generalItemSum.add(avgBedMobility).add(avgTransfer).add(avgWalking);
        result = result.setScale(0, RoundingMode.HALF_UP);
        return SnfContext.trace("Calculated function score", result.intValue());
    }

    private BigDecimal sumAssessments(Collection<String> generalItemList, BiFunction<ClaimInfo, String, Integer> functionalAssessments, String category) {
        List applicableAssessments = generalItemList.stream().map(item -> {
            int itemScore = (Integer)functionalAssessments.apply(this, (String)item);
            return item + ": " + itemScore;
        }).collect(Collectors.toList());
        return SnfContext.trace(category + " assessments " + applicableAssessments + " score", generalItemList.stream().map(item -> (Integer)functionalAssessments.apply(this, (String)item)).map(BigDecimal::valueOf).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    public boolean isComaAndNoActivities() {
        if (this.getAssessmentValue(Rai300.B0100) != 1) {
            return false;
        }
        EnumSet<Rai300> activitySet = EnumSet.noneOf(Rai300.class);
        activitySet.addAll(this.hasIpa() ? RaiSets.BED_MOBILITY_IPA.getSet() : RaiSets.BED_MOBILITY_NON_IPA.getSet());
        activitySet.addAll(this.hasIpa() ? RaiSets.TRANSFER_IPA.getSet() : RaiSets.TRANSFER_NON_IPA.getSet());
        activitySet.addAll(this.hasIpa() ? RaiSets.EATING_AND_TOILET_IPA.getSet() : RaiSets.EATING_AND_TOILET_NON_IPA.getSet());
        List<Integer> activitiesCheck = Arrays.asList(1, 9, 88);
        boolean isDependentOrNoActivityOccurred = activitySet.stream().allMatch(item -> {
            int value = this.getAssessmentValue((Rai300)((Object)item));
            return activitiesCheck.contains(value);
        });
        return SnfContext.trace(isDependentOrNoActivityOccurred);
    }

    public Set<String> getAssessmentNames(Predicate<Assessment> checkedAssessment) {
        return this.byItem.values().stream().filter(checkedAssessment == null ? ast -> true : checkedAssessment).map(Assessment::getName).collect(Collectors.toSet());
    }

    public Set<Assessment> getAssessments() {
        return new HashSet<Assessment>(this.byItem.values());
    }
}

