/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.snf.app;

import gov.cms.grouper.snf.app.Pdpm;
import gov.cms.grouper.snf.model.SnfDiagnosisCode;
import gov.cms.grouper.snf.model.enums.Rai300;
import gov.cms.grouper.snf.transfer.SnfClaim;
import gov.cms.grouper.snf.util.ClaimInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PdpmTest {
    public static final Logger logger = LoggerFactory.getLogger(PdpmTest.class);
    private static long begin = System.currentTimeMillis();
    private static long end = System.currentTimeMillis();
    private static int totalNumberOfRecords;
    private static int errorCount;
    private static int numOfCorrect;
    private static int mismatchHippsCount;

    public static void main(String[] args) throws Throwable {
        File[] files;
        boolean dryRun = "true".equals(System.getProperty("dryRun"));
        String outputPath = "test_results/";
        String inputPath = "test_data";
        Boolean isRegression = false;
        logger.info("Start");
        if (args.length > 0) {
            isRegression = Boolean.valueOf(args[0]);
            logger.info("isRegression: {}", (Object)isRegression);
        }
        if (args.length > 1) {
            inputPath = args[1];
            logger.info("inputPath: {}", (Object)inputPath);
        }
        Path inputDir = Paths.get(inputPath, new String[0]);
        Path outputDir = Paths.get(outputPath, new String[0]);
        if (!dryRun) {
            outputDir.toFile().mkdirs();
        }
        for (File file : files = inputDir.toFile().listFiles(pathname -> !pathname.isDirectory() && (pathname.getName().endsWith(".txt") || pathname.getName().endsWith(".xml")))) {
            System.out.println("**** Processing File: " + file.getName());
            PdpmTest.beginPerformanceTime();
            Supplier<Writer> ws = PdpmTest.getWriter(dryRun, inputDir, file, outputDir);
            Function<Writer, Consumer<SnfClaim>> getProcessing = PdpmTest.qaProcessing(dryRun, isRegression);
            Consumer<Writer> exec = PdpmTest.getExec(file, getProcessing);
            PdpmTest.doMain(file, ws, exec);
            PdpmTest.endPerformanceTime();
            System.out.println("***********************************");
        }
    }

    protected static void doMain(File inputFile, Supplier<Writer> ws, Consumer<Writer> exec) {
        try (Writer writer = ws.get();){
            exec.accept(writer);
        }
        catch (Throwable ex) {
            System.out.println("ERROR WHILE PROCESSING: " + inputFile.getAbsolutePath());
            throw new RuntimeException(ex);
        }
    }

    protected static Supplier<Writer> getWriter(boolean dryRun, Path inputDir, File inputFile, Path resultDir) {
        Supplier<Writer> ws = () -> new Writer(){

            @Override
            public void write(String str) {
            }

            @Override
            public void close() {
            }

            @Override
            public void write(char[] cbuf, int off, int len) {
            }

            @Override
            public void flush() {
            }
        };
        if (!dryRun) {
            String inputRelDir = inputFile.getParentFile().getAbsolutePath().replace(inputDir.toFile().getAbsolutePath(), "");
            String resultFilePath = resultDir.toFile().getAbsolutePath() + inputRelDir;
            File resultFileDir = new File(resultFilePath);
            resultFileDir.mkdirs();
            File resultFile = new File(resultFileDir.getAbsolutePath() + "/" + inputFile.getName());
            ws = () -> {
                try {
                    return new BufferedWriter(new FileWriter(resultFile));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return ws;
    }

    protected static void beginPerformanceTime() {
        begin = System.currentTimeMillis();
        numOfCorrect = 0;
        mismatchHippsCount = 0;
        totalNumberOfRecords = 0;
        errorCount = 0;
        end = System.currentTimeMillis();
    }

    protected static void endPerformanceTime() {
        end = System.currentTimeMillis();
        PdpmTest.performanceTime(begin, end, totalNumberOfRecords, errorCount, mismatchHippsCount, numOfCorrect);
    }

    protected static void formatFixedLengthValue(StringBuilder sb, Rai300 field, boolean rightJustified, String value) {
        String justification = rightJustified ? "" : "-";
        sb.replace(field.getIndex() - 1, field.getIndex() + field.getLength() - 1, String.format("%1$" + justification + field.getLength() + "s", value));
    }

    private static void performanceTime(long begin, long end, int totalNumberOfRecords, int errorCount, Integer misMatchHippsCount, Integer numberOfCorrect) {
        long processTime;
        long min = (processTime = end - begin) / 60000L;
        long sec = processTime % ((min == 0L ? 1L : min) * 1000L * 60L) / 1000L;
        long totalSec = processTime / 1000L;
        if (numberOfCorrect != null) {
            double percentage = (double)numberOfCorrect.intValue() * 100.0 / (double)totalNumberOfRecords;
            System.out.println("\t\tRecords Processed: " + totalNumberOfRecords);
            int errors = errorCount + misMatchHippsCount;
            if (errors != 0) {
                double errorPercent = 100.0 - percentage;
                System.out.println("\t\terrors: " + errors + " (" + errorPercent + "%)");
            }
        } else {
            System.out.println("\t\tRecords Processed: " + totalNumberOfRecords);
            System.out.println("\t\terrors: " + errorCount);
        }
        String intervalFmt = "\t\ttotal process time with %d records = %d min and %d sec (%d Seconds)";
        System.out.println(String.format(intervalFmt, totalNumberOfRecords, min, sec, totalSec));
        long recordPerSecond = totalNumberOfRecords;
        if (totalSec > 0L) {
            recordPerSecond = (long)totalNumberOfRecords / totalSec;
        }
        System.out.println(String.format("\t\trecords per second = %d", recordPerSecond));
    }

    protected static Consumer<Writer> getExec(File inputFile, Function<Writer, Consumer<SnfClaim>> getProcessing) {
        Consumer<Writer> exec = writer -> {
            Consumer processing = (Consumer)getProcessing.apply((Writer)writer);
            Pdpm pdpm = new Pdpm();
            pdpm.ignoreExceptionOnTryExec = true;
            pdpm.exec(inputFile.toPath(), processing);
        };
        return exec;
    }

    protected static Function<Writer, Consumer<SnfClaim>> qaProcessing(boolean dryRun, Boolean isRegression) {
        Function<Writer, Consumer<SnfClaim>> r = writer -> claim -> {
            ++totalNumberOfRecords;
            String expectedHipps = PdpmTest.getOriginalRecordHippsCode(claim);
            String actualHipps = claim.getHippsCode();
            String errorReason = String.join((CharSequence)",", claim.getErrors());
            String hipps = claim.getHippsCode();
            String productVersion = claim.getRecalculated_z0100b();
            if (claim.hasError()) {
                ++errorCount;
            } else if (!expectedHipps.equals(actualHipps)) {
                ++mismatchHippsCount;
                errorReason = "Z0100A & Recalculated_Z0100A mismatched.";
            } else {
                ++numOfCorrect;
            }
            StringBuilder sb = new StringBuilder();
            if (claim.isFixedStringOrigin()) {
                sb = new StringBuilder(claim.getOriginalRecord());
                PdpmTest.formatFixedLengthValue(sb, Rai300.ERROR_REASON, false, errorReason);
                PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100A, false, hipps);
                if (!isRegression.booleanValue()) {
                    PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100B, false, productVersion);
                }
                sb.append(System.lineSeparator());
            } else if (claim.isXmlOrigin()) {
                sb.append(claim.getOutputXmlString(hipps, productVersion, errorReason));
            }
            if (!dryRun) {
                try {
                    writer.write(sb.toString());
                }
                catch (Throwable th) {
                    throw new RuntimeException(th);
                }
            }
        };
        return r;
    }

    private static String getOriginalRecordHippsCode(SnfClaim claim) {
        if (claim.isFixedStringOrigin()) {
            int start = Rai300.Z0100A.getIndex() - 1;
            int end = start + Rai300.Z0100A.getLength() - 1;
            return claim.getOriginalRecord().substring(start, end).trim();
        }
        if (claim.isXmlOrigin()) {
            Document document = claim.getRawData();
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("ASSESSMENT");
            Node node = nodeList.item(0);
            Element element = (Element)node;
            Node xmlNode = element.getElementsByTagName("Z0100A").item(0);
            return xmlNode.getTextContent().trim();
        }
        return null;
    }

    @Test
    public void readAllLinesToClaimsTest() {
        Pdpm pdpm = new Pdpm();
        String line = "MDS       NC 1.17      3.00      PIA765045          521230861CMS                           help@qtso.com                                     jRAVEN                                            1.1.9               ^                   ^         765045      ^              10101  0103FPDPMf150   ^GrprNRSEf150      ^  9990211505GR1PR1NR50 ^              1193205010000010^              4^           ^         ^                      ^                      0100000201910011012019100601^       201910060^       ^       0010000112121222120^^^^^^^^     111101111111111111108 ^^^^^^^^^^^^^^^^^^^^^  0010000^^^^^^00^^31111212232332221110^^^^^^^^^^^^^^^^^^^^^11110000000000000000000000000000010000010---0000011000000000000001000000000000000100000010000010000000000^       ^       ^       ^       ^       ^       ^       ^       ^       ^       00010^^^^ ^^^^^^^^100000000011110^^^00010671272       00000001000100^^^        ^^^^^^^^^^                    0000000100000000010^^        0000000001010001000000 0010120191001^1^200 -   -   52019100120191005200 -   -   52019100120191005200 -   -   5201910012019100515  115  115  17700006000- - 00000000109^^1  ^2049920191001- - - 0-1-0-0-1-1-101-0-1010100-100-10100-0-0-20191006201910061^^           ^                 ^^       ^        ^ ^    ^       ^       ^       ^ ^^^^^^^^           ^                 ^       KIAA1  1.0003                      RAA       1.0448    RAA       1.0448    20191006^           1^^^01100 1 000001234567^^^ 32 12-   -   -   520191001011000401^ 0501^ 0401^ 0603^ 0605^ 0505^ 0506^ 0502^   0603^ 0605^ 1^0404^ 1^0505^ 1^^0112019100512019100511111132181000000605^ 0302^ 0709^ 88- ^ 0605^ 0106^ 0403^ 0403^ 0403^ 0403^ 88- ^ 0403^ 13        111^0^1^ ^ ^ ^ ^ ^ ^ ^ ^ ^ ^ A20.7^^^111111111111111111111111111111^   ^   ^   ^   ^  ^   ^   ^   ^   ^  ^   ^   ^   ^   ^  ^    ^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              KIAA1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  %";
        SnfClaim claim = SnfClaim.mapMdsToClaim((String)line);
        Assertions.assertEquals((Object)"A20.7^^^", (Object)claim.getPrimaryDiagnosis().getValue());
        Assertions.assertEquals((int)1, (Integer)claim.getPps());
        Assertions.assertEquals((int)1, (Integer)claim.getObra());
        ClaimInfo claimUtil = new ClaimInfo(100, false, claim.getAssessmentMap());
        Assertions.assertEquals((int)7, (int)claimUtil.getAssessmentValue(Rai300.O0500A));
    }

    @Test
    public void execFixedLengthMdsLineTest() {
        String line = "MDS       NC 1.17      3.00      PIA765045          521230861CMS                           help@qtso.com                                     jRAVEN                                            1.1.9               ^                   ^         765045      ^              10199  0993CATchgJAN01 ^LNCJ2100_001      ^  9990181011CD0CC6jj01 ^              11940    0000011SIGN           3^           ^         ^                      ^                      000000120201227101^       ^ ^       202101010^       ^       0010000113321222150^^^^^^^^     19^9^9^9^9^9^9^9^1399 000000000011111111115  0010000^^^^^^00^^31111212232332221110^^^^^^^^^^^^^^^^^^^^^00000000000000000000000000000000011100000---0000011000000000000000100001000000000000000000000010000000000U07.1^^^S32.10XDE11.8^^^Z79.4^^^W19.XXXDI85.01^^S32.502DG47.00^^S32.059DK75.81^^00010^^^^ ^^^^^^^^100000000011110^^^00001681650       0000000100010----        --^-------                    000000011100000000---        0000000000000000000000 0111120201231^1^200 -   -   52020122920201231200 -   -   52020122920201231200 -   -   5202012292020123115  -15  115  10000000000- - 00000000109^^1  ^2049920201231- - - 0-1-0-0-1-0-00100-0010100-100-01100-0-0-20210106202101071^^           ^                 ^^       ^        ^ ^    ^       ^       ^       ^ ^^^^^^^^           ^                 ^       KACD   1.0009                      RAA       1.0448    RAA       1.0448    20210106^           ^^^^00000 0 011001234567^^^ ^^ ^^-   -   -   5202012270110005^ ^ 05^ ^ 01^ ^ 02^ ^ 03^ ^ 02^ ^ 04^ ^ 04^ ^   ^ ^ ^ ^ ^ ^ 1^04^ ^ 1^05^ ^ 1^^01120210104120210104111111^^^^^^^^^^06^ ^ 03^ ^ 07^ ^ 88^ ^ 06^ ^ 01^ ^ 88^ ^ ^ ^ ^ 04^ ^ 04^ ^ 88^ ^ 04^ ^ 13        ^^^^0 ^                      J12.82^^111111111111111000000000000001^   ^   ^   ^   ^  ^   ^   ^   ^   ^  ^   ^   ^   ^   ^  ^    ^1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             KACD   1.0009                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          %";
        Pdpm pdpm = new Pdpm();
        SnfClaim claim = SnfClaim.mapMdsToClaim((String)line);
        SnfClaim finishedClaimFromClaim = pdpm.exec(claim);
        SnfClaim finishedClaimFromString = pdpm.exec(line);
        Assert.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(finishedClaimFromClaim), (Object)finishedClaimFromClaim.getHippsCode());
        Assert.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(finishedClaimFromString), (Object)finishedClaimFromString.getHippsCode());
    }

    @Test
    public void execXmlStringTest() throws ParserConfigurationException, IOException, SAXException {
        String xmlClaim = "<?xml version=\"1.0\" standalone=\"yes\"?>\n<ASSESSMENT>\n    <ASMT_SYS_CD>MDS</ASMT_SYS_CD>\n    <ITM_SBST_CD>NC</ITM_SBST_CD>\n    <ITM_SET_VRSN_CD>1.00</ITM_SET_VRSN_CD>\n    <SPEC_VRSN_CD>1.00</SPEC_VRSN_CD>\n    <PRODN_TEST_CD>P</PRODN_TEST_CD>\n    <STATE_CD>IA</STATE_CD>\n    <FAC_ID>1231_B</FAC_ID>\n    <SFTWR_VNDR_ID>12321345</SFTWR_VNDR_ID >\n    <SFTWR_VNDR_NAME>SOME VENDOR</SFTWR_VNDR_NAME >\n    <SFTWR_VNDR_EMAIL_ADR>SUPPORT@VENDOR.COM</SFTWR_VNDR_EMAIL_ADR>\n    <SFTWR_PROD_NAME>MDS ENTRY SYSTEM</SFTWR_PROD_NAME>\n    <SFTWR_PROD_VRSN_CD>V2.44</SFTWR_PROD_VRSN_CD>\n    <FAC_DOC_ID>A1334001</FAC_DOC_ID>\n    <A0100A>1234567890</A0100A>\n    <A0100B>123456</A0100B>\n    <A0100C>M33298483</A0100C>\n\n    <A0800>1</A0800>\n    <A0900>19350621</A0900>\n    <A2300>20240318</A2300>\n    <A0310B>8</A0310B>\n\n    <C0800 LOINC_ITEM=\"99999-9\">1</C0800>\n    <C0900A LOINC_ITEM=\"99999-9\" LOINC_RESP=\"99999-9\">0</C0900A>\n    <C0900B LOINC_ITEM=\"99999-9\" LOINC_RESP=\"99999-9\">1</C0900B>\n    <C0900C LOINC_ITEM=\"99999-9\" LOINC_RESP=\"99999-9\">1</C0900C>\n    <C0900D LOINC_ITEM=\"99999-9\" LOINC_RESP=\"99999-9\">1</C0900D>\n    <C0900Z LOINC_ITEM=\"99999-9\" LOINC_RESP=\"99999-9\">0</C0900Z>\n    <C1000 LOINC_RESP=\"99999-9\">-</C1000>\n\n    <E0300>0</E0300>\n    <E0500A>^</E0500A>\n    <E0500B>^</E0500B>\n    <E0500C>^</E0500C>\n    <E0600A>^</E0600A>\n    <E0600B>^</E0600B>\n    <E0600C>^</E0600C>\n    <E0800>3</E0800>\n    <E0900>2</E0900>\n\n    <Z0500B>20101001</Z0500B>\n    <Z0100A>IAUF0</Z0100A>\n    <I0020B>U07.1^^^</I0020B>\n</ASSESSMENT>";
        Pdpm pdpm = new Pdpm();
        SnfClaim claim = SnfClaim.mapXmlStringToClaim((String)xmlClaim);
        SnfClaim finishedClaimFromClaim = pdpm.exec(claim);
        SnfClaim finishedClaimFromString = pdpm.xmlStringExec(xmlClaim);
        Assert.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(finishedClaimFromClaim), (Object)claim.getHippsCode());
        Assert.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(finishedClaimFromString), (Object)claim.getHippsCode());
    }

    @Test
    public void execU071Test() throws URISyntaxException {
        Path path = Paths.get(ClassLoader.getSystemResource("U071 test.txt").toURI());
        Pdpm pdpm = new Pdpm();
        Consumer<SnfClaim> test = claim -> Assert.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        pdpm.exec(path, test);
    }

    @Test
    public void execNTATest() throws URISyntaxException {
        Path path = Paths.get(ClassLoader.getSystemResource("NTA test.txt").toURI());
        Pdpm pdpm = new Pdpm();
        Consumer<SnfClaim> test = claim -> Assertions.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        pdpm.exec(path, test);
    }

    @Test
    public void execNurseTest() throws URISyntaxException {
        Path path = Paths.get(ClassLoader.getSystemResource("Nurse test.txt").toURI());
        Pdpm pdpm = new Pdpm();
        Consumer<SnfClaim> test = claim -> Assertions.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        pdpm.exec(path, test);
    }

    @Test
    public void execPTOTTest() throws URISyntaxException {
        Path path = Paths.get(ClassLoader.getSystemResource("PTOT test.txt").toURI());
        Pdpm pdpm = new Pdpm();
        Consumer<SnfClaim> test = claim -> Assertions.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        pdpm.exec(path, test);
    }

    @Test
    public void execSLPTest() throws URISyntaxException {
        Path path = Paths.get(ClassLoader.getSystemResource("SLP test.txt").toURI());
        Pdpm pdpm = new Pdpm();
        Consumer<SnfClaim> test = claim -> Assertions.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        pdpm.exec(path, test);
        pdpm.exec(path, null);
    }

    @Test
    public void execXmlTest() throws URISyntaxException {
        Path path = Paths.get(ClassLoader.getSystemResource("XmlClaim.xml").toURI());
        Pdpm pdpm = new Pdpm();
        Consumer<SnfClaim> test = claim -> Assertions.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        pdpm.exec(path, test);
        pdpm.exec(path, null);
    }

    @Test
    public void getClaimFixedStringTest() throws URISyntaxException {
        Path path = Paths.get(ClassLoader.getSystemResource("Nurse test.txt").toURI());
        Pdpm pdpm = new Pdpm();
        AtomicReference first = new AtomicReference();
        Consumer<SnfClaim> test = claim -> {
            if (first.get() == null) {
                first.set(claim);
            }
            Assertions.assertEquals((Object)PdpmTest.getOriginalRecordHippsCode(claim), (Object)claim.getHippsCode());
        };
        pdpm.exec(path, test);
        String hipps = "AFAA1  ";
        SnfClaim claim2 = (SnfClaim)first.get();
        claim2.setHippsCode(hipps);
        StringBuilder sb = new StringBuilder(claim2.getOriginalRecord());
        PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100A, false, claim2.getHippsCode());
        PdpmTest.formatFixedLengthValue(sb, Rai300.RECALCULATED_Z0100B, false, claim2.getRecalculated_z0100b());
        Assertions.assertEquals((Object)sb.toString(), (Object)claim2.mapClaimToMds());
    }

    @Test
    @Order(value=0)
    public void testMain() throws URISyntaxException {
        System.setProperty("dryRun", "true");
        Path dir = Paths.get(ClassLoader.getSystemResource("mainTest").toURI());
        dir.toFile().list();
        String testFileDir = dir.toString();
        Assertions.assertDoesNotThrow(() -> {
            String[] args = new String[]{"-1", testFileDir};
            PdpmTest.main(args);
            args = new String[]{"100", testFileDir};
            PdpmTest.main(args);
        });
        Assertions.assertDoesNotThrow(() -> {
            String[] args = new String[]{"-1", testFileDir};
            PdpmTest.main(args);
        });
    }

    @Test
    public void testPdxWithReturnToProvider() {
        Pdpm pdpm = new Pdpm();
        SnfClaim claim = new SnfClaim();
        claim.setAssessmentReferenceDate(LocalDate.of(2023, 10, 1));
        claim.setPrimaryDiagnosis(new SnfDiagnosisCode("B900"));
        claim.setObra(Integer.valueOf(2));
        SnfClaim processedClaim = pdpm.exec(claim);
        Assertions.assertEquals((Object)"IAUF", (Object)processedClaim.getHippsCode());
    }
}

