package gov.cms.grouper.snf.model.enums;

/**
 * The listing of Nursing CMGs. Note that the ordinal of the CMGs will determine the HIPPS by
 * looking up the ASCII number
 */
public enum NursingCmg {
  /** Extensive Services: Tracheostomy & Ventilator */
  ES3("A"),
  /** Extensive Services: Tracheostomy or Ventilator*/
  ES2("B"),
  /** Extensive Services: Infection Isolation */
  ES1("C"),
  /** Clinical Conditions: Serious medical conditions e.g. comatose, septicemia, respiratory therapy */
  HDE2("D"),
  /** Clinical Conditions: Serious medical conditions e.g. comatose, septicemia, respiratory therapy */
  HDE1("E"),
  /** Clinical Conditions: Serious medical conditions e.g. comatose, septicemia, respiratory therapy */
  HBC2("F"),
  /** Clinical Conditions: Serious medical conditions e.g. comatose, septicemia, respiratory therapy */
  HBC1("G"),
  /** Clinical Conditions: Serious medical conditions e.g. radiation therapy or dialysis */
  LDE2("H"),
  /** Clinical Conditions: Serious medical conditions e.g. radiation therapy or dialysis */
  LDE1("I"),
  /** Clinical Conditions: Serious medical conditions e.g. radiation therapy or dialysis */
  LBC2("J"),
  /** Clinical Conditions: Serious medical conditions e.g. radiation therapy or dialysis */
  LBC1("K"),
  /** Clinical Conditions: Conditions requiring complex medical care e.g. pneumonia, surgical wounds, burns */
  CDE2("L"),
  /** Clinical Conditions: Conditions requiring complex medical care e.g. pneumonia, surgical wounds, burns */
  CDE1("M"),
  /** Clinical Conditions: Conditions requiring complex medical care e.g. pneumonia, surgical wounds, burns */
  CBC2("N"),
  /** Clinical Conditions: Conditions requiring complex medical care e.g. pneumonia, surgical wounds, burns */
  CA2("O"),
  /** Clinical Conditions: Conditions requiring complex medical care e.g. pneumonia, surgical wounds, burns */
  CBC1("P"),
  /** Clinical Conditions: Conditions requiring complex medical care e.g. pneumonia, surgical wounds, burns */
  CA1("Q"),
  /** Clinical Conditions: Behavioral or cognitive symptoms */
  BAB2("R"),
  /** Clinical Conditions: Behavioral or cognitive symptoms */
  BAB1("S"),
  /** Clinical Conditions: Assistance with daily living and general supervision */
  PDE2("T"),
  /** Clinical Conditions: Assistance with daily living and general supervision */
  PDE1("U"),
  /** Clinical Conditions: Assistance with daily living and general supervision */
  PBC2("V"),
  /** Clinical Conditions: Assistance with daily living and general supervision */
  PA2("W"),
  /** Clinical Conditions: Assistance with daily living and general supervision */
  PBC1("X"),
  /** Clinical Conditions: Assistance with daily living and general supervision */
  PA1("Y");

  private final String hipps;

  NursingCmg(String hipps) {
    this.hipps = hipps;
  }

  public String getHipps() {
    return hipps;
  }

  @Override
  public String toString() {
    return name() + " > " + hipps;
  }
}
