/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.snf.SnfPricerConfiguration;
import gov.cms.fiss.pricers.snf.core.SnfPricerDispatch;
import gov.cms.fiss.pricers.snf.resources.SnfClaimPricingResource;
import gov.cms.fiss.pricers.snf.resources.SnfExtractionUtil;
import io.dropwizard.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SnfPricerApplication
extends OpenApiPricerApplication<SnfPricerConfiguration> {
    public static void main(String[] args) throws Exception {
        new SnfPricerApplication().run(args);
    }

    @Override
    protected void configureApplication(SnfPricerConfiguration configuration, Environment environment) {
        SnfClaimPricingResource v2Resource = new SnfClaimPricingResource(new SnfPricerDispatch(configuration));
        environment.jersey().register(v2Resource);
        environment.jersey().register(new CbsaWageIndexResource(configuration, SnfExtractionUtil.CBSA_EXTRACTOR));
    }

    @Override
    protected List<OpenApiCustomizer> getContractCustomizers() {
        ArrayList<OpenApiCustomizer> customizers = new ArrayList<OpenApiCustomizer>(super.getContractCustomizers());
        customizers.add((configuration, environment, oas) -> oas.info(new Info().title("SNF Pricer").version("v1")));
        return customizers;
    }

    @Override
    protected Map<Integer, String> getCalculationVersions() {
        return Map.of(2020, "2020.6", 2021, "2021.1", 2022, "2022.1", 2023, "2023.0", 2024, "2024.1");
    }

    @Override
    public String getName() {
        return "snf-pricer";
    }

    @Override
    protected List<Package> getResourcePackages() {
        return Collections.singletonList(SnfClaimPricingResource.class.getPackage());
    }
}

