/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core;

import gov.cms.fiss.pricers.common.api.InternalPricerException;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.application.PricerDispatch;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.snf.SnfPricerConfiguration;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimData;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.core.Snf2020RulePricer;
import gov.cms.fiss.pricers.snf.core.Snf2021RulePricer;
import gov.cms.fiss.pricers.snf.core.Snf2022RulePricer;
import gov.cms.fiss.pricers.snf.core.Snf2023RulePricer;
import gov.cms.fiss.pricers.snf.core.Snf2024RulePricer;
import gov.cms.fiss.pricers.snf.core.tables.DataTables;
import java.time.LocalDate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnfPricerDispatch
extends PricerDispatch<SnfClaimPricingRequest, SnfClaimPricingResponse, SnfPricerConfiguration> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SnfPricerDispatch.class);

    public SnfPricerDispatch(SnfPricerConfiguration pricerConfiguration) {
        super(pricerConfiguration, o -> o.getReturnCodeData().getCode());
    }

    @Override
    protected void initializeReferences(SnfPricerConfiguration pricerConfiguration) {
        DataTables.loadDataTables(pricerConfiguration);
        for (int supportedYear : pricerConfiguration.getSupportedYears()) {
            switch (supportedYear) {
                case 2020: {
                    this.yearReference.register(supportedYear, Snf2020RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2021: {
                    this.yearReference.register(supportedYear, Snf2021RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2022: {
                    this.yearReference.register(supportedYear, Snf2022RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2023: {
                    this.yearReference.register(supportedYear, Snf2023RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
                case 2024: {
                    this.yearReference.register(supportedYear, Snf2024RulePricer.class, DataTables.forYear(supportedYear));
                    break;
                }
            }
        }
    }

    @Override
    protected ClaimProcessor<SnfClaimPricingRequest, SnfClaimPricingResponse> getProcessor(SnfClaimPricingRequest input) throws YearNotImplementedException, InternalPricerException {
        return this.yearReference.fromFiscalYear(this.getAdjustedThroughDate(((SnfClaimData)input.getClaimData()).getServiceFromDate(), ((SnfClaimData)input.getClaimData()).getServiceThroughDate()), "serviceThroughDate");
    }

    @Override
    protected boolean isErrorOutput(SnfClaimPricingResponse output) {
        return Integer.parseInt(output.getReturnCodeData().getCode()) >= 20;
    }

    private LocalDate getAdjustedThroughDate(LocalDate fromDate, LocalDate throughDate) {
        if (throughDate.isEqual(LocalDateUtils.fiscalYearStart(throughDate)) && fromDate.isBefore(throughDate)) {
            return throughDate.minusDays(1L);
        }
        return throughDate;
    }
}

