/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.core.ReturnCode;
import gov.cms.fiss.pricers.snf.core.SnfPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class ApplySupplementalWageIndex
implements CalculationRule<SnfClaimPricingRequest, SnfClaimPricingResponse, SnfPricerContext> {
    @Override
    public boolean shouldExecute(SnfPricerContext context) {
        return !context.hasSpecialWageIndexAdjustment() && StringUtils.equals("1", context.getProviderData().getSupplementalWageIndexIndicator());
    }

    @Override
    public void calculate(SnfPricerContext context) {
        BigDecimal supplementalWageIndex = context.getProviderData().getSupplementalWageIndex();
        if (BigDecimalUtils.isZero(supplementalWageIndex)) {
            context.applyReturnCodeAndTerminate(ReturnCode.INVALID_CBSA_OR_WAGE_INDEX_30);
            return;
        }
        if (BigDecimalUtils.isLessThan(context.getWageIndex().subtract(supplementalWageIndex).divide(supplementalWageIndex, RoundingMode.DOWN), context.getWageIndexDecreaseCap())) {
            BigDecimal wageIndexPercentAdjustment = BigDecimal.ONE.add(context.getWageIndexDecreaseCap());
            context.setWageIndex(supplementalWageIndex.multiply(wageIndexPercentAdjustment).setScale(4, RoundingMode.HALF_UP));
        }
    }
}

