/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.rules.rate_selection;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.core.ReturnCode;
import gov.cms.fiss.pricers.snf.core.SnfPricerContext;
import gov.cms.fiss.pricers.snf.core.tables.PhysicalAndOccupationalTherapyRateEntry;

public class SelectPhysicalAndOccupationalTherapyRates
implements CalculationRule<SnfClaimPricingRequest, SnfClaimPricingResponse, SnfPricerContext> {
    @Override
    public void calculate(SnfPricerContext context) {
        String group = Character.toString(context.getHippsCode().charAt(0));
        PhysicalAndOccupationalTherapyRateEntry entry = context.getDataTables().getPhysicalAndOccupationalTherapyRate(context.hasRuralCbsa(), group);
        if (entry == null) {
            context.applyReturnCodeAndTerminate(ReturnCode.INVALID_RATE_COMPONENT_20);
            return;
        }
        if (context.hasQualityAdjustment()) {
            context.setPhysicalTherapyRate(entry.getQualityAdjustedPhysicalTherapyRate());
            context.setOccupationalTherapyRate(entry.getQualityAdjustedOccupationalTherapyRate());
        } else {
            context.setPhysicalTherapyRate(entry.getPhysicalTherapyRate());
            context.setOccupationalTherapyRate(entry.getOccupationalTherapyRate());
        }
    }
}

