/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.contract;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public final class AnnotationExtractor {
    public static <T> List<T> getAnnotation(Class<T> cls, Annotation ... annotations) {
        ArrayList matchedAnnotations = new ArrayList();
        if (annotations == null || annotations.length == 0) {
            return matchedAnnotations;
        }
        return AnnotationExtractor.matchAnnotation(cls, annotations);
    }

    private static <T> List<T> matchAnnotation(Class<T> annotationClass, Annotation ... annotations) {
        ArrayList<Annotation> matchedAnnotations = new ArrayList<Annotation>();
        if (annotations == null || annotations.length == 0) {
            return matchedAnnotations;
        }
        for (Annotation annotation : annotations) {
            Annotation[] metaAnnotations;
            if (annotationClass.isAssignableFrom(annotation.getClass())) {
                matchedAnnotations.add(annotation);
                continue;
            }
            for (Annotation metaAnnotation : metaAnnotations = AnnotationExtractor.extractMetaAnnotations(annotation)) {
                if (!annotationClass.isAssignableFrom(metaAnnotation.getClass())) continue;
                matchedAnnotations.add(metaAnnotation);
            }
        }
        return matchedAnnotations;
    }

    public static Annotation[] extractMetaAnnotations(Annotation sourceAnnotation) {
        return AnnotationExtractor.extractMetaAnnotations(sourceAnnotation, new ArrayList<Class<? extends Annotation>>());
    }

    public static Annotation[] extractMetaAnnotations(Annotation sourceAnnotation, List<Class<? extends Annotation>> excludedAnnotations) {
        if (sourceAnnotation == null) {
            return new Annotation[0];
        }
        Annotation[] metaAnnotations = sourceAnnotation.annotationType().getAnnotations();
        if (metaAnnotations.length == 0) {
            return metaAnnotations;
        }
        ArrayList<Annotation> extractedAnnotations = new ArrayList<Annotation>();
        for (Annotation metaAnnotation : metaAnnotations) {
            if (excludedAnnotations.contains(metaAnnotation.annotationType()) || metaAnnotation.annotationType().getPackageName().equals("java.lang.annotation")) continue;
            extractedAnnotations.add(metaAnnotation);
            extractedAnnotations.addAll(Arrays.asList(AnnotationExtractor.extractMetaAnnotations(metaAnnotation, excludedAnnotations)));
        }
        return extractedAnnotations.toArray(new Annotation[0]);
    }

    @Generated
    private AnnotationExtractor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

