/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.resources;

import com.codahale.metrics.health.HealthCheck;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

@Schema(description="Individual health metric.", deprecated=true)
public class HealthCheckResult {
    private Map<String, String> details;
    private String error;
    private boolean healthy;
    private String message;
    private String timestamp;

    public static HealthCheckResult fromResult(HealthCheck.Result healthResult) {
        return new HealthCheckResult(Optional.ofNullable(healthResult.getDetails()).orElseGet(HashMap::new).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> v.getValue().toString())), Optional.ofNullable(healthResult.getError()).map(Object::getClass).map(Class::getName).orElse(null), healthResult.isHealthy(), Optional.ofNullable(healthResult.getMessage()).orElse(null), healthResult.getTimestamp());
    }

    @Generated
    public HealthCheckResult(Map<String, String> details, String error, boolean healthy, String message, String timestamp) {
        this.details = details;
        this.error = error;
        this.healthy = healthy;
        this.message = message;
        this.timestamp = timestamp;
    }

    @Generated
    public Map<String, String> getDetails() {
        return this.details;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public boolean isHealthy() {
        return this.healthy;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    @Generated
    public void setError(String error) {
        this.error = error;
    }

    @Generated
    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HealthCheckResult)) {
            return false;
        }
        HealthCheckResult other = (HealthCheckResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHealthy() != other.isHealthy()) {
            return false;
        }
        Map<String, String> this$details = this.getDetails();
        Map<String, String> other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HealthCheckResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHealthy() ? 79 : 97);
        Map<String, String> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HealthCheckResult(details=" + this.getDetails() + ", error=" + this.getError() + ", healthy=" + this.isHealthy() + ", message=" + this.getMessage() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @Generated
    public HealthCheckResult() {
    }
}

