/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.snf.api.validation.ValidSignedDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import lombok.Generated;

@Schema(description="The SNF prospective payment data.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="SNF-INPUT-DATA", value="<structure>")})})
public class SnfPaymentData
extends PaymentData {
    @NotNull
    @Pattern(regexp="^[YN0]$", message="must be one of 'Y', 'N', or '0'")
    @Schema(description="The flag indicating if an AIDS adjustment is applicable.", example="Y", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="AIDS-ADD-ON-IND", value="PIC X")})})
    private @NotNull @Pattern(regexp="^[YN0]$", message="must be one of 'Y', 'N', or '0'") String aidsAddOnIndicator = "0";
    @NotNull
    @Pattern(regexp="^[YN0]$", message="must be one of 'Y', 'N', or '0'")
    @Schema(description="The flag indicating if a quality reporting program (QRP) adjustment is applicable.", example="Y", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="QRP-IND", value="PIC X")})})
    private @NotNull @Pattern(regexp="^[YN0]$", message="must be one of 'Y', 'N', or '0'") String qualityReportingProgramIndicator = "0";
    @NotNull
    @Pattern(regexp="^[RU]$", message="must be one of 'R' or 'U'")
    @Schema(description="The flag indicating if core-based statistical area (CBSA) is rural or urban.", example="U", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="REGION-IND", value="PIC X")})})
    private @NotNull @Pattern(regexp="^[RU]$", message="must be one of 'R' or 'U'") String regionIndicator;
    @BigDecimalScale
    @NotNull
    @Schema(description="The value-based purchasing payment difference.", example="324.23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="VBP-PAY-DIFF", value="PIC S9(06)V9(02)")})})
    @ValidSignedDecimalOutputWithTwoFractionDigits
    private BigDecimal valueBasedPurchasingPaymentDifference;

    @Generated
    public String getAidsAddOnIndicator() {
        return this.aidsAddOnIndicator;
    }

    @Generated
    public String getQualityReportingProgramIndicator() {
        return this.qualityReportingProgramIndicator;
    }

    @Generated
    public String getRegionIndicator() {
        return this.regionIndicator;
    }

    @Generated
    public BigDecimal getValueBasedPurchasingPaymentDifference() {
        return this.valueBasedPurchasingPaymentDifference;
    }

    @Generated
    public void setAidsAddOnIndicator(String aidsAddOnIndicator) {
        this.aidsAddOnIndicator = aidsAddOnIndicator;
    }

    @Generated
    public void setQualityReportingProgramIndicator(String qualityReportingProgramIndicator) {
        this.qualityReportingProgramIndicator = qualityReportingProgramIndicator;
    }

    @Generated
    public void setRegionIndicator(String regionIndicator) {
        this.regionIndicator = regionIndicator;
    }

    @Generated
    public void setValueBasedPurchasingPaymentDifference(BigDecimal valueBasedPurchasingPaymentDifference) {
        this.valueBasedPurchasingPaymentDifference = valueBasedPurchasingPaymentDifference;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnfPaymentData)) {
            return false;
        }
        SnfPaymentData other = (SnfPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$aidsAddOnIndicator = this.getAidsAddOnIndicator();
        String other$aidsAddOnIndicator = other.getAidsAddOnIndicator();
        if (this$aidsAddOnIndicator == null ? other$aidsAddOnIndicator != null : !this$aidsAddOnIndicator.equals(other$aidsAddOnIndicator)) {
            return false;
        }
        String this$qualityReportingProgramIndicator = this.getQualityReportingProgramIndicator();
        String other$qualityReportingProgramIndicator = other.getQualityReportingProgramIndicator();
        if (this$qualityReportingProgramIndicator == null ? other$qualityReportingProgramIndicator != null : !this$qualityReportingProgramIndicator.equals(other$qualityReportingProgramIndicator)) {
            return false;
        }
        String this$regionIndicator = this.getRegionIndicator();
        String other$regionIndicator = other.getRegionIndicator();
        if (this$regionIndicator == null ? other$regionIndicator != null : !this$regionIndicator.equals(other$regionIndicator)) {
            return false;
        }
        BigDecimal this$valueBasedPurchasingPaymentDifference = this.getValueBasedPurchasingPaymentDifference();
        BigDecimal other$valueBasedPurchasingPaymentDifference = other.getValueBasedPurchasingPaymentDifference();
        return !(this$valueBasedPurchasingPaymentDifference == null ? other$valueBasedPurchasingPaymentDifference != null : !((Object)this$valueBasedPurchasingPaymentDifference).equals(other$valueBasedPurchasingPaymentDifference));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnfPaymentData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $aidsAddOnIndicator = this.getAidsAddOnIndicator();
        result = result * 59 + ($aidsAddOnIndicator == null ? 43 : $aidsAddOnIndicator.hashCode());
        String $qualityReportingProgramIndicator = this.getQualityReportingProgramIndicator();
        result = result * 59 + ($qualityReportingProgramIndicator == null ? 43 : $qualityReportingProgramIndicator.hashCode());
        String $regionIndicator = this.getRegionIndicator();
        result = result * 59 + ($regionIndicator == null ? 43 : $regionIndicator.hashCode());
        BigDecimal $valueBasedPurchasingPaymentDifference = this.getValueBasedPurchasingPaymentDifference();
        result = result * 59 + ($valueBasedPurchasingPaymentDifference == null ? 43 : ((Object)$valueBasedPurchasingPaymentDifference).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SnfPaymentData(aidsAddOnIndicator=" + this.getAidsAddOnIndicator() + ", qualityReportingProgramIndicator=" + this.getQualityReportingProgramIndicator() + ", regionIndicator=" + this.getRegionIndicator() + ", valueBasedPurchasingPaymentDifference=" + this.getValueBasedPurchasingPaymentDifference() + ")";
    }

    @Generated
    public SnfPaymentData() {
    }
}

