/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum ReturnCode {
    PDPM_GROUP_RATE_RETURNED_0(0, "PDPM GROUP RATE RETURNED", "PDPM group rate returned"),
    INVALID_RATE_COMPONENT_20(20, "INVALID RATE COMPONENT", "Invalid rate component"),
    INVALID_CBSA_OR_WAGE_INDEX_30(30, "INVALID CBSA OR WAGE INDEX", "Invalid CBSA or wage index"),
    INVALID_THROUGH_DATE_40(40, "INVALID THROUGH DATE", "Invalid through date"),
    INVALID_FEDERAL_BLEND_AND_YEAR_50(50, "INVALID FEDERAL BLEND AND YEAR", "Invalid federal blend year"),
    INVALID_FEDERAL_BLEND_60(60, "INVALID FEDERAL BLEND", "Invalid federal blend"),
    FEDERAL_BLEND_IS_0_AND_THRU_DATE_BEFORE_2000_61(61, "FEDERAL BLEND IS ZERO AND THROUGH DATE BEFORE 2000", "Federal blend is zero and through date 2000 "),
    VBP_MULTIPLIER_IS_ZERO_70(70, "VBP MULTIPLIER IS ZERO", "VBP multiplier is zero"),
    PDPM_UNITS_IS_ZERO_80(80, "PDPM UNITS IS ZERO", "PDPM units is zero"),
    SERVICE_UNITS_IS_ZERO_80(80, "SERVICE UNITS IS ZERO", "Service units is zero"),
    INVALID_HIPPS_CODE_90(90, "INVALID HIPPS CODE", "Invalid HIPPS code");

    private final int code;
    private final String desc;
    private final String exp;

    private ReturnCode(int code, String desc, String exp) {
        this.code = code;
        this.desc = desc;
        this.exp = exp;
    }

    public static ReturnCode fromCode(int code) {
        Optional<ReturnCode> matchedCode = Arrays.stream(ReturnCode.values()).filter(rc -> rc.getCode() == code).findFirst();
        return matchedCode.orElse(null);
    }

    public ReturnCodeData toReturnCodeData() {
        ReturnCodeData returnCodeData = new ReturnCodeData();
        String paddedCode = StringUtils.leftPad(String.valueOf(this.code), 2, "0");
        returnCodeData.setCode(paddedCode);
        returnCodeData.setDescription(this.desc);
        returnCodeData.setExplanation(this.exp);
        return returnCodeData;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public String getExp() {
        return this.exp;
    }
}

