/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.core.SnfPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ApplyValueBasedPurchasingMultiplier
implements CalculationRule<SnfClaimPricingRequest, SnfClaimPricingResponse, SnfPricerContext> {
    @Override
    public void calculate(SnfPricerContext context) {
        BigDecimal multiplier = context.getProviderData().getVbpAdjustment();
        context.setPaymentRate(multiplier.multiply(context.getTotalCalculatedPaymentRate()).setScale(2, RoundingMode.HALF_UP));
        context.setPaymentDifference(context.getPaymentRate().subtract(context.getTotalCalculatedPaymentRate()));
    }
}

