/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.rules.rate_selection;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.core.ReturnCode;
import gov.cms.fiss.pricers.snf.core.SnfPricerContext;
import gov.cms.fiss.pricers.snf.core.tables.NursingRateEntry;

public class SelectNursingRate
implements CalculationRule<SnfClaimPricingRequest, SnfClaimPricingResponse, SnfPricerContext> {
    @Override
    public void calculate(SnfPricerContext context) {
        String group = Character.toString(context.getHippsCode().charAt(2));
        NursingRateEntry entry = context.getDataTables().getNursingRate(context.hasRuralCbsa(), group);
        if (entry == null) {
            context.applyReturnCodeAndTerminate(ReturnCode.INVALID_RATE_COMPONENT_20);
            return;
        }
        if (context.hasQualityAdjustment()) {
            if (context.hasAidsAdjustment()) {
                context.setNursingRate(entry.getAidsAndQualityAdjustedRate());
            } else {
                context.setNursingRate(entry.getQualityAdjustedRate());
            }
        } else if (context.hasAidsAdjustment()) {
            context.setNursingRate(entry.getAidsAdjustedRate());
        } else {
            context.setNursingRate(entry.getRate());
        }
    }
}

