/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.snf.SnfPricerConfiguration;
import gov.cms.fiss.pricers.snf.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.snf.core.tables.CbsaWageIndexLookupGenerator;
import gov.cms.fiss.pricers.snf.core.tables.NonTherapyAncillaryRateEntry;
import gov.cms.fiss.pricers.snf.core.tables.NonTherapyAncillaryRateLookupGenerator;
import gov.cms.fiss.pricers.snf.core.tables.NursingRateEntry;
import gov.cms.fiss.pricers.snf.core.tables.NursingRateLookupGenerator;
import gov.cms.fiss.pricers.snf.core.tables.PhysicalAndOccupationalTherapyRateEntry;
import gov.cms.fiss.pricers.snf.core.tables.PhysicalAndOccupationalTherapyRateLookupGenerator;
import gov.cms.fiss.pricers.snf.core.tables.SpeechLanguagePathologyRateEntry;
import gov.cms.fiss.pricers.snf.core.tables.SpeechLanguagePathologyRateLookupGenerator;
import gov.cms.fiss.pricers.snf.core.tables.VariablePerDiemEntry;
import gov.cms.fiss.pricers.snf.core.tables.VariablePerDiemLookupGenerator;
import java.time.LocalDate;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class DataTables {
    private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<Integer, DataTables>();
    private static final String REGION_RURAL = "RURAL";
    private static final String REGION_URBAN = "URBAN";
    private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
    private final Map<Integer, VariablePerDiemEntry> variablePerDiemMap;
    private final Map<String, Map<String, SpeechLanguagePathologyRateEntry>> slpRateMap;
    private final Map<String, Map<String, NonTherapyAncillaryRateEntry>> ntaRateMap;
    private final Map<String, Map<String, NursingRateEntry>> nursingRateMap;
    private final Map<String, Map<String, PhysicalAndOccupationalTherapyRateEntry>> ptOtRateMap;

    public DataTables(Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<Integer, VariablePerDiemEntry> variablePerDiemMap, Map<String, Map<String, SpeechLanguagePathologyRateEntry>> slpRateMap, Map<String, Map<String, NonTherapyAncillaryRateEntry>> ntaRateMap, Map<String, Map<String, NursingRateEntry>> nursingRateMap, Map<String, Map<String, PhysicalAndOccupationalTherapyRateEntry>> ptOtRateMap) {
        this.cbsaTable = cbsaTable;
        this.variablePerDiemMap = variablePerDiemMap;
        this.slpRateMap = slpRateMap;
        this.ntaRateMap = ntaRateMap;
        this.nursingRateMap = nursingRateMap;
        this.ptOtRateMap = ptOtRateMap;
    }

    public static DataTables forYear(int pricerYear) {
        return YEAR_LOOKUP.get(pricerYear);
    }

    public static void loadDataTables(SnfPricerConfiguration pricerConfiguration) {
        CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
        CbsaWageIndexLookupGenerator cbsaWageIndexLookupGenerator = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
        Map<Integer, VariablePerDiemEntry> variablePerDiemLookupMap = new VariablePerDiemLookupGenerator(csvIngestionConfiguration).generate();
        SpeechLanguagePathologyRateLookupGenerator speechLanguagePathologyRateLookupGenerator = new SpeechLanguagePathologyRateLookupGenerator(csvIngestionConfiguration);
        NonTherapyAncillaryRateLookupGenerator nonTherapyAncillaryRateLookupGenerator = new NonTherapyAncillaryRateLookupGenerator(csvIngestionConfiguration);
        NursingRateLookupGenerator nursingRateLookupGenerator = new NursingRateLookupGenerator(csvIngestionConfiguration);
        PhysicalAndOccupationalTherapyRateLookupGenerator physicalAndOccupationalTherapyRateLookupGenerator = new PhysicalAndOccupationalTherapyRateLookupGenerator(csvIngestionConfiguration);
        for (int pricerYear : pricerConfiguration.getSupportedYears()) {
            YEAR_LOOKUP.put(pricerYear, new DataTables(cbsaWageIndexLookupGenerator.generate(pricerYear), variablePerDiemLookupMap, speechLanguagePathologyRateLookupGenerator.generate(pricerYear), nonTherapyAncillaryRateLookupGenerator.generate(pricerYear), nursingRateLookupGenerator.generate(pricerYear), physicalAndOccupationalTherapyRateLookupGenerator.generate(pricerYear)));
        }
    }

    public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa, LocalDate throughDate) {
        NavigableMap<LocalDate, CbsaWageIndexEntry> wageIndices = this.cbsaTable.get(cbsa);
        if (wageIndices == null) {
            return null;
        }
        Map.Entry<LocalDate, CbsaWageIndexEntry> entry = wageIndices.floorEntry(throughDate);
        if (entry == null) {
            return null;
        }
        return entry.getValue().copyBuilder().build();
    }

    public VariablePerDiemEntry getVariablePerDiemAdjustmentFactors(int day) {
        VariablePerDiemEntry entry = this.variablePerDiemMap.get(day);
        return null == entry ? null : entry.copyBuilder().build();
    }

    public SpeechLanguagePathologyRateEntry getSpeechLanguagePathologyRate(boolean isRural, String group) {
        SpeechLanguagePathologyRateEntry entry = this.slpRateMap.get(this.getRegionKey(isRural)).get(group);
        return null == entry ? null : entry.copyBuilder().build();
    }

    public NonTherapyAncillaryRateEntry getNonTherapyAncillaryRate(boolean isRural, String group) {
        NonTherapyAncillaryRateEntry entry = this.ntaRateMap.get(this.getRegionKey(isRural)).get(group);
        return null == entry ? null : entry.copyBuilder().build();
    }

    public NursingRateEntry getNursingRate(boolean isRural, String group) {
        NursingRateEntry entry = this.nursingRateMap.get(this.getRegionKey(isRural)).get(group);
        return null == entry ? null : entry.copyBuilder().build();
    }

    public PhysicalAndOccupationalTherapyRateEntry getPhysicalAndOccupationalTherapyRate(boolean isRural, String group) {
        PhysicalAndOccupationalTherapyRateEntry entry = this.ptOtRateMap.get(this.getRegionKey(isRural)).get(group);
        return null == entry ? null : entry.copyBuilder().build();
    }

    private String getRegionKey(boolean isRural) {
        return isRural ? REGION_RURAL : REGION_URBAN;
    }

    @Generated
    public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
        return this.cbsaTable;
    }
}

