/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.tables;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import javax.annotation.concurrent.Immutable;
import lombok.Generated;

@JsonDeserialize(builder=NonTherapyAncillaryRateEntryBuilder.class)
@JsonPropertyOrder(value={"region", "group", "rate", "qualityAdjustedRate"})
@Immutable
public class NonTherapyAncillaryRateEntry {
    @Pattern(regexp="RURAL|URBAN", message="must be either RURAL or URBAN")
    private final @Pattern(regexp="RURAL|URBAN", message="must be either RURAL or URBAN") String region;
    @Pattern(regexp="[A-F]", message="must be single letter A-F")
    private final @Pattern(regexp="[A-F]", message="must be single letter A-F") String group;
    @Digits(integer=4, fraction=2)
    @DecimalMin(value="0.0")
    @DecimalMax(value="9999.99")
    private final @Digits(integer=4, fraction=2) @DecimalMin(value="0.0") @DecimalMax(value="9999.99") BigDecimal rate;
    @Digits(integer=4, fraction=2)
    @DecimalMin(value="0.0")
    @DecimalMax(value="9999.99")
    private final @Digits(integer=4, fraction=2) @DecimalMin(value="0.0") @DecimalMax(value="9999.99") BigDecimal qualityAdjustedRate;

    public NonTherapyAncillaryRateEntryBuilder copyBuilder() {
        return NonTherapyAncillaryRateEntry.builder().region(this.getRegion()).group(this.getGroup()).rate(this.getRate()).qualityAdjustedRate(this.getQualityAdjustedRate());
    }

    @Generated
    NonTherapyAncillaryRateEntry(String region, String group, BigDecimal rate, BigDecimal qualityAdjustedRate) {
        this.region = region;
        this.group = group;
        this.rate = rate;
        this.qualityAdjustedRate = qualityAdjustedRate;
    }

    @Generated
    public static NonTherapyAncillaryRateEntryBuilder builder() {
        return new NonTherapyAncillaryRateEntryBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NonTherapyAncillaryRateEntry)) {
            return false;
        }
        NonTherapyAncillaryRateEntry other = (NonTherapyAncillaryRateEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        BigDecimal this$rate = this.getRate();
        BigDecimal other$rate = other.getRate();
        if (this$rate == null ? other$rate != null : !((Object)this$rate).equals(other$rate)) {
            return false;
        }
        BigDecimal this$qualityAdjustedRate = this.getQualityAdjustedRate();
        BigDecimal other$qualityAdjustedRate = other.getQualityAdjustedRate();
        return !(this$qualityAdjustedRate == null ? other$qualityAdjustedRate != null : !((Object)this$qualityAdjustedRate).equals(other$qualityAdjustedRate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NonTherapyAncillaryRateEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        BigDecimal $rate = this.getRate();
        result = result * 59 + ($rate == null ? 43 : ((Object)$rate).hashCode());
        BigDecimal $qualityAdjustedRate = this.getQualityAdjustedRate();
        result = result * 59 + ($qualityAdjustedRate == null ? 43 : ((Object)$qualityAdjustedRate).hashCode());
        return result;
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public BigDecimal getRate() {
        return this.rate;
    }

    @Generated
    public BigDecimal getQualityAdjustedRate() {
        return this.qualityAdjustedRate;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class NonTherapyAncillaryRateEntryBuilder {
        @Generated
        private String region;
        @Generated
        private String group;
        @Generated
        private BigDecimal rate;
        @Generated
        private BigDecimal qualityAdjustedRate;

        @Generated
        NonTherapyAncillaryRateEntryBuilder() {
        }

        @Generated
        public NonTherapyAncillaryRateEntryBuilder region(String region) {
            this.region = region;
            return this;
        }

        @Generated
        public NonTherapyAncillaryRateEntryBuilder group(String group) {
            this.group = group;
            return this;
        }

        @Generated
        public NonTherapyAncillaryRateEntryBuilder rate(BigDecimal rate) {
            this.rate = rate;
            return this;
        }

        @Generated
        public NonTherapyAncillaryRateEntryBuilder qualityAdjustedRate(BigDecimal qualityAdjustedRate) {
            this.qualityAdjustedRate = qualityAdjustedRate;
            return this;
        }

        @Generated
        public NonTherapyAncillaryRateEntry build() {
            return new NonTherapyAncillaryRateEntry(this.region, this.group, this.rate, this.qualityAdjustedRate);
        }

        @Generated
        public String toString() {
            return "NonTherapyAncillaryRateEntry.NonTherapyAncillaryRateEntryBuilder(region=" + this.region + ", group=" + this.group + ", rate=" + this.rate + ", qualityAdjustedRate=" + this.qualityAdjustedRate + ")";
        }
    }

    @Generated
    public static final class Fields {
        public static final String REGION = "region";
        public static final String GROUP = "group";
        public static final String RATE = "rate";
        public static final String QUALITY_ADJUSTED_RATE = "qualityAdjustedRate";
    }
}

