/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.snf.core.tables.PhysicalAndOccupationalTherapyRateEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class PhysicalAndOccupationalTherapyRateLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/ptot-rates-%s.csv";
    private final CsvContentReader<PhysicalAndOccupationalTherapyRateEntry> contentProvider = new CsvContentReader<PhysicalAndOccupationalTherapyRateEntry>(PhysicalAndOccupationalTherapyRateEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public PhysicalAndOccupationalTherapyRateLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, Map<String, PhysicalAndOccupationalTherapyRateEntry>> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, Map<String, PhysicalAndOccupationalTherapyRateEntry>> generate(String csvFile) {
        List<PhysicalAndOccupationalTherapyRateEntry> content = this.contentProvider.read(csvFile);
        BinaryOperator comparator = BinaryOperator.maxBy((a, b) -> 0);
        Collector<PhysicalAndOccupationalTherapyRateEntry, ?, Map> collector = Collectors.toMap(PhysicalAndOccupationalTherapyRateEntry::getGroup, Function.identity(), comparator, HashMap::new);
        return LookupGenerator.generateCrossReferenceToMap(PhysicalAndOccupationalTherapyRateEntry::getRegion, content, HashMap::new, collector);
    }
}

