/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.snf.core.tables.VariablePerDiemEntry;
import java.util.List;
import java.util.Map;

public class VariablePerDiemLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/vpd-adj-factors.csv";
    private final CsvContentReader<VariablePerDiemEntry> contentProvider = new CsvContentReader<VariablePerDiemEntry>(VariablePerDiemEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public VariablePerDiemLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<Integer, VariablePerDiemEntry> generate() {
        return this.generate(CSV_FILE_PATTERN);
    }

    public Map<Integer, VariablePerDiemEntry> generate(String csvFile) {
        List<VariablePerDiemEntry> content = this.contentProvider.read(csvFile);
        return LookupGenerator.generateMap(VariablePerDiemEntry::getDay, content);
    }
}

