// Generated by delombok at Thu Nov 13 21:14:46 UTC 2025
package gov.cms.fiss.pricers.snf.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimData;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.api.v2.SnfPaymentData;
import gov.cms.fiss.pricers.snf.core.tables.DataTables;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/**
 * Container for storing state information, constants, annually updated constants and helper
 * methods.
 */
public abstract class SnfPricerContext extends CalculationContext<SnfClaimPricingRequest, SnfClaimPricingResponse> {
  //
  // Constants
  //
  /**
   * Corresponds to {@code DEFAULT-HIPPS-CODE PIC XXXXX} from the COBOL source.
   */
  public static final String DEFAULT_HIPPS_CODE = "ZZZZZ";
  /**
   * Corresponds to {@code REPLACEMENT-HIPPS-CODE PIC XXXXX} from the COBOL source.
   */
  public static final String REPLACEMENT_HIPPS_CODE = "PAYF1";
  //
  // Passed in variables
  //
  @JsonIgnore
  private final DataTables dataTables;
  //
  // Calculation (hold) variables
  //
  /**
   * Corresponds to {@code AREA-WAGE-INDEX PIC 9(01)V9(04)} from the COBOL source.
   */
  private BigDecimal wageIndex;
  /**
   * Corresponds to {@code WK-HIPPS-CODE PIC XXXXX} from the COBOL source.
   */
  private String hippsCode;
  /**
   * Corresponds to {@code CURRENT-DAYS PIC 9(3)} from the COBOL source.
   */
  private int currentDays;
  /**
   * Corresponds to {@code TOTAL-DAYS PIC 9(3)} from the COBOL source.
   */
  private int totalDays;
  /**
   * Corresponds to {@code HIPPS-PT-RATE-COMP PIC 999V99} from the COBOL source.
   */
  private BigDecimal physicalTherapyRate;
  /**
   * Corresponds to {@code HIPPS-OT-RATE-COMP PIC 999V99} from the COBOL source.
   */
  private BigDecimal occupationalTherapyRate;
  /**
   * Corresponds to {@code HIPPS-SLP-RATE-COMP PIC 999V99} from the COBOL source.
   */
  private BigDecimal speechLanguagePathologyRate;
  /**
   * Corresponds to {@code HIPPS-NURSE-RATE-COMP PIC 999V99} from the COBOL source.
   */
  private BigDecimal nursingRate;
  /**
   * Corresponds to {@code HIPPS-NTA-RATE-COMP PIC 999V99} from the COBOL source.
   */
  private BigDecimal nonTherapyAncillaryRate;
  /**
   * Corresponds to {@code HIPPS-NCM-RATE-COMP PIC 999V99} from the COBOL source.
   */
  private BigDecimal nonCaseMixRate;
  /**
   * Corresponds to {@code TOTAL-CALC-PAYMENT-RATE PIC 9(06)V99} from the COBOL source.
   */
  private BigDecimal totalCalculatedPaymentRate;
  /**
   * Corresponds to {@code WS-PT-OT-UTIL PIC 999V99} from the COBOL source.
   */
  private BigDecimal physicalAndOccupationalTherapyUtilization;
  /**
   * Corresponds to {@code WS-NTA-UTIL PIC 999V99} from the COBOL source.
   */
  private BigDecimal nonTherapyAncillaryUtilization;
  /**
   * Corresponds to {@code SNF-PAYMENT-RATE PIC 9(06)V9(02)} from the COBOL source.
   */
  private BigDecimal paymentRate;
  /**
   * Corresponds to {@code VBP-PAY-DIFF PIC S9(06)V9(02)} from the COBOL source.
   */
  private BigDecimal paymentDifference;

  protected SnfPricerContext(SnfClaimPricingRequest request, SnfClaimPricingResponse response, DataTables dataTables) {
    super(request, response);
    this.dataTables = dataTables;
    // Initialize response
    final SnfPaymentData paymentData = new SnfPaymentData();
    response.setPaymentData(paymentData);
    response.setCalculationVersion(getCalculationVersion());
    response.setReturnCodeData(ReturnCode.PDPM_GROUP_RATE_RETURNED_0.toReturnCodeData());
    paymentData.setTotalPayment(BigDecimal.ZERO);
    paymentData.setValueBasedPurchasingPaymentDifference(BigDecimal.ZERO);
    paymentData.setFinalWageIndex(BigDecimal.ZERO);
    // Other response indicators are set elsewhere to replicate COBOL pricing logic
    paymentData.setRegionIndicator(hasRuralCbsa() ? "R" : "U");
  }

  //
  // Helper methods
  //
  /**
   * Returns the provider data for this claim.
   */
  @JsonIgnore
  public InpatientProviderData getProviderData() {
    return getInput().getProviderData();
  }

  /**
   * Returns the payment data for this claim.
   */
  @JsonIgnore
  public SnfPaymentData getPaymentData() {
    return getOutput().getPaymentData();
  }

  /**
   * Returns the claim data for this claim.
   */
  @JsonIgnore
  public SnfClaimData getClaimData() {
    return getInput().getClaimData();
  }

  /**
   * Update claim return code and stop subsequent rules from processing.
   *
   * @param returnCode return code to be applied to the claim
   */
  public void applyReturnCodeAndTerminate(ReturnCode returnCode) {
    getOutput().setReturnCodeData(returnCode.toReturnCodeData());
    setCalculationCompleted();
  }

  /**
   * Corresponds to {@code REGION-IND PIC X} from the COBOL source.
   *
   * @return {@code true} if CBSA is 2 digits
   */
  public boolean hasRuralCbsa() {
    final String cbsaActualGeographicLocation = getProviderData().getCbsaActualGeographicLocation();
    return StringUtils.isNotBlank(cbsaActualGeographicLocation) && cbsaActualGeographicLocation.matches("\\d{2}");
  }

  /**
   * Corresponds to {@code AIDS-ADD-ON-IND PIC X} and converted from {@code 450-SET-INDICATORS} in
   * the COBOL code.
   *
   * @return {@code true} with the presence of an AIDS diagnosis
   */
  public boolean hasAidsAdjustment() {
    // SET AIDS ADD-ON IND IF INDICATED BY PRIN DX CODE -OR- OTHER DX CODES
    final List<String> diagnosisCodes = getClaimData().getDiagnosisCodes();
    return diagnosisCodes != null && diagnosisCodes.contains("B20");
  }

  /**
   * Corresponds to {@code QRP-IND PIC X} and converted from {@code 450-SET-INDICATORS} in the COBOL
   * code.
   *
   * @return {@code true} if the Federal PPS blend indicator is {@code 1}
   */
  public boolean hasQualityAdjustment() {
    // SNF-FED-BLEND =1 SET QRP IND TO Y
    return StringUtils.equals("1", getProviderData().getFederalPpsBlend());
  }

  /**
   * Determines if the special wage index should be applied.
   *
   * @return {@code true} if the special wage index should be used for pricing
   */
  public boolean hasSpecialWageIndexAdjustment() {
    return StringUtils.containsAny(getProviderData().getSpecialPaymentIndicator(), "Y", "1") && BigDecimalUtils.isGreaterThanZero(getProviderData().getSpecialWageIndex());
  }

  //
  // Getters for annual constants that may change each year
  //
  /**
   * Corresponds to {@code CAL-VERSION PIC X(09)} from the COBOL source.
   *
   * @return the version of pricer
   */
  public abstract String getCalculationVersion();

  /**
   * Corresponds to {@code WS-WI-PCT-DECREASE-FY2021 PIC S9(01)V9(02)} from the COBOL source;
   * corresponding value {@code WS-WI-PCT-ADJ-FY2021} will be calculated.
   *
   * @return the max percentage that the wage index can be decreased
   */
  public abstract BigDecimal getWageIndexDecreaseCap();

  /**
   * Corresponds to {@code URBAN-NCM-COMP-2020 PIC 999V99} from the COBOL source.
   *
   * @return the urban non-mix case rate component
   */
  public abstract BigDecimal getUrbanNonCaseMixRate();

  /**
   * Corresponds to {@code URBAN-QRP-NCM-COMP-2020 PIC 999V99} from the COBOL source.
   *
   * @return the urban QRP non-mix case rate component
   */
  public abstract BigDecimal getUrbanQualityAdjustedNonCaseMixRate();

  /**
   * Corresponds to {@code RURAL-NCM-COMP-2020 PIC 999V99} from the COBOL source.
   *
   * @return the rural non-mix case rate component
   */
  public abstract BigDecimal getRuralNonCaseMixRate();

  /**
   * Corresponds to {@code RURAL-QRP-NCM-COMP-2020 PIC 999V99} from the COBOL source.
   *
   * @return the rural QRP non-mix case rate component
   */
  public abstract BigDecimal getRuralQualityAdjustedNonCaseMixRate();

  /**
   * Corresponds to {@code PERCENT-2020-LABOR} from the COBOL source.
   *
   * @return the labor rate
   */
  public abstract BigDecimal getLaborRate();

  /**
   * Corresponds to {@code PERCENT-2020-NLABOR} from the COBOL source.
   *
   * @return the non-labor rate
   */
  public abstract BigDecimal getNonLaborRate();

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DataTables getDataTables() {
    return this.dataTables;
  }

  /**
   * Corresponds to {@code AREA-WAGE-INDEX PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWageIndex() {
    return this.wageIndex;
  }

  /**
   * Corresponds to {@code AREA-WAGE-INDEX PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWageIndex(final BigDecimal wageIndex) {
    this.wageIndex = wageIndex;
  }

  /**
   * Corresponds to {@code WK-HIPPS-CODE PIC XXXXX} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHippsCode() {
    return this.hippsCode;
  }

  /**
   * Corresponds to {@code WK-HIPPS-CODE PIC XXXXX} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHippsCode(final String hippsCode) {
    this.hippsCode = hippsCode;
  }

  /**
   * Corresponds to {@code CURRENT-DAYS PIC 9(3)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getCurrentDays() {
    return this.currentDays;
  }

  /**
   * Corresponds to {@code CURRENT-DAYS PIC 9(3)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCurrentDays(final int currentDays) {
    this.currentDays = currentDays;
  }

  /**
   * Corresponds to {@code TOTAL-DAYS PIC 9(3)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getTotalDays() {
    return this.totalDays;
  }

  /**
   * Corresponds to {@code TOTAL-DAYS PIC 9(3)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalDays(final int totalDays) {
    this.totalDays = totalDays;
  }

  /**
   * Corresponds to {@code HIPPS-PT-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPhysicalTherapyRate() {
    return this.physicalTherapyRate;
  }

  /**
   * Corresponds to {@code HIPPS-PT-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPhysicalTherapyRate(final BigDecimal physicalTherapyRate) {
    this.physicalTherapyRate = physicalTherapyRate;
  }

  /**
   * Corresponds to {@code HIPPS-OT-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOccupationalTherapyRate() {
    return this.occupationalTherapyRate;
  }

  /**
   * Corresponds to {@code HIPPS-OT-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOccupationalTherapyRate(final BigDecimal occupationalTherapyRate) {
    this.occupationalTherapyRate = occupationalTherapyRate;
  }

  /**
   * Corresponds to {@code HIPPS-SLP-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getSpeechLanguagePathologyRate() {
    return this.speechLanguagePathologyRate;
  }

  /**
   * Corresponds to {@code HIPPS-SLP-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSpeechLanguagePathologyRate(final BigDecimal speechLanguagePathologyRate) {
    this.speechLanguagePathologyRate = speechLanguagePathologyRate;
  }

  /**
   * Corresponds to {@code HIPPS-NURSE-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNursingRate() {
    return this.nursingRate;
  }

  /**
   * Corresponds to {@code HIPPS-NURSE-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNursingRate(final BigDecimal nursingRate) {
    this.nursingRate = nursingRate;
  }

  /**
   * Corresponds to {@code HIPPS-NTA-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNonTherapyAncillaryRate() {
    return this.nonTherapyAncillaryRate;
  }

  /**
   * Corresponds to {@code HIPPS-NTA-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNonTherapyAncillaryRate(final BigDecimal nonTherapyAncillaryRate) {
    this.nonTherapyAncillaryRate = nonTherapyAncillaryRate;
  }

  /**
   * Corresponds to {@code HIPPS-NCM-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNonCaseMixRate() {
    return this.nonCaseMixRate;
  }

  /**
   * Corresponds to {@code HIPPS-NCM-RATE-COMP PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNonCaseMixRate(final BigDecimal nonCaseMixRate) {
    this.nonCaseMixRate = nonCaseMixRate;
  }

  /**
   * Corresponds to {@code TOTAL-CALC-PAYMENT-RATE PIC 9(06)V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalCalculatedPaymentRate() {
    return this.totalCalculatedPaymentRate;
  }

  /**
   * Corresponds to {@code TOTAL-CALC-PAYMENT-RATE PIC 9(06)V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalCalculatedPaymentRate(final BigDecimal totalCalculatedPaymentRate) {
    this.totalCalculatedPaymentRate = totalCalculatedPaymentRate;
  }

  /**
   * Corresponds to {@code WS-PT-OT-UTIL PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPhysicalAndOccupationalTherapyUtilization() {
    return this.physicalAndOccupationalTherapyUtilization;
  }

  /**
   * Corresponds to {@code WS-PT-OT-UTIL PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPhysicalAndOccupationalTherapyUtilization(final BigDecimal physicalAndOccupationalTherapyUtilization) {
    this.physicalAndOccupationalTherapyUtilization = physicalAndOccupationalTherapyUtilization;
  }

  /**
   * Corresponds to {@code WS-NTA-UTIL PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNonTherapyAncillaryUtilization() {
    return this.nonTherapyAncillaryUtilization;
  }

  /**
   * Corresponds to {@code WS-NTA-UTIL PIC 999V99} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNonTherapyAncillaryUtilization(final BigDecimal nonTherapyAncillaryUtilization) {
    this.nonTherapyAncillaryUtilization = nonTherapyAncillaryUtilization;
  }

  /**
   * Corresponds to {@code SNF-PAYMENT-RATE PIC 9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPaymentRate() {
    return this.paymentRate;
  }

  /**
   * Corresponds to {@code SNF-PAYMENT-RATE PIC 9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentRate(final BigDecimal paymentRate) {
    this.paymentRate = paymentRate;
  }

  /**
   * Corresponds to {@code VBP-PAY-DIFF PIC S9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPaymentDifference() {
    return this.paymentDifference;
  }

  /**
   * Corresponds to {@code VBP-PAY-DIFF PIC S9(06)V9(02)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentDifference(final BigDecimal paymentDifference) {
    this.paymentDifference = paymentDifference;
  }
}
