// Generated by delombok at Thu Nov 13 21:14:24 UTC 2025
package gov.cms.fiss.pricers.snf.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.List;

@Schema(description = "The billing information associated with the claim.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "SNF-INPUT-DATA", value = "<structure>")})})
public class SnfClaimData extends ClaimData {
  @ArraySchema(arraySchema = @Schema(description = "The diagnosis codes associated with this claim.", example = "[\"B10\",\"A509\"]", maxLength = 7, extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "SNF-DIAGNOSIS-CODES", value = "PIC X(175)")})}))
  @Size(max = 25, min = 1)
  private List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> diagnosisCodes;
  @NotNull
  @Pattern(regexp = "[A-Z\\d]{5}", message = "must be five alphanumeric characters")
  @Schema(description = "The Health Insurance Prospective Payment System Code (HIPPS) code.", example = "BARD0", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "SNF-HIPPS-CODE", value = "PIC X(05)")})})
  private String hippsCode;
  @Max(999)
  @Min(0)
  @NotNull
  @Schema(description = "The number of prior SNF days from claims history.", example = "15", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PDPM-DATA", value = "SNF-PDPM-PRIOR-DAYS PIC 999")})})
  private Integer pdpmPriorDays;
  @NotNull
  @Schema(description = "The start date of service.", example = "2020-05-13", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "SNF-FROM-DATE", value = "PIC X(08)")})})
  @StrictLocalDate
  private LocalDate serviceFromDate;
  @NotNull
  @Schema(description = "The end date of service.", example = "2020-05-25", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "SNF-THRU-DATE", value = "PIC X(08)")})})
  @StrictLocalDate
  private LocalDate serviceThroughDate;
  @Max(99)
  @Min(0)
  @NotNull
  @Schema(description = "The number of service units reported.", example = "23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PDPM-DATA", value = "SNF-PDPM-UNITS PIC 99")})})
  private Integer serviceUnits;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> getDiagnosisCodes() {
    return this.diagnosisCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHippsCode() {
    return this.hippsCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getPdpmPriorDays() {
    return this.pdpmPriorDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getServiceFromDate() {
    return this.serviceFromDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getServiceThroughDate() {
    return this.serviceThroughDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getServiceUnits() {
    return this.serviceUnits;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDiagnosisCodes(final List<@Pattern(regexp = "[A-Z\\d]{2,7}", message = "must be two to seven alphanumeric characters") String> diagnosisCodes) {
    this.diagnosisCodes = diagnosisCodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHippsCode(final String hippsCode) {
    this.hippsCode = hippsCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPdpmPriorDays(final Integer pdpmPriorDays) {
    this.pdpmPriorDays = pdpmPriorDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceFromDate(final LocalDate serviceFromDate) {
    this.serviceFromDate = serviceFromDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceThroughDate(final LocalDate serviceThroughDate) {
    this.serviceThroughDate = serviceThroughDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceUnits(final Integer serviceUnits) {
    this.serviceUnits = serviceUnits;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof SnfClaimData)) return false;
    final SnfClaimData other = (SnfClaimData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$pdpmPriorDays = this.getPdpmPriorDays();
    final java.lang.Object other$pdpmPriorDays = other.getPdpmPriorDays();
    if (this$pdpmPriorDays == null ? other$pdpmPriorDays != null : !this$pdpmPriorDays.equals(other$pdpmPriorDays)) return false;
    final java.lang.Object this$serviceUnits = this.getServiceUnits();
    final java.lang.Object other$serviceUnits = other.getServiceUnits();
    if (this$serviceUnits == null ? other$serviceUnits != null : !this$serviceUnits.equals(other$serviceUnits)) return false;
    final java.lang.Object this$diagnosisCodes = this.getDiagnosisCodes();
    final java.lang.Object other$diagnosisCodes = other.getDiagnosisCodes();
    if (this$diagnosisCodes == null ? other$diagnosisCodes != null : !this$diagnosisCodes.equals(other$diagnosisCodes)) return false;
    final java.lang.Object this$hippsCode = this.getHippsCode();
    final java.lang.Object other$hippsCode = other.getHippsCode();
    if (this$hippsCode == null ? other$hippsCode != null : !this$hippsCode.equals(other$hippsCode)) return false;
    final java.lang.Object this$serviceFromDate = this.getServiceFromDate();
    final java.lang.Object other$serviceFromDate = other.getServiceFromDate();
    if (this$serviceFromDate == null ? other$serviceFromDate != null : !this$serviceFromDate.equals(other$serviceFromDate)) return false;
    final java.lang.Object this$serviceThroughDate = this.getServiceThroughDate();
    final java.lang.Object other$serviceThroughDate = other.getServiceThroughDate();
    if (this$serviceThroughDate == null ? other$serviceThroughDate != null : !this$serviceThroughDate.equals(other$serviceThroughDate)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof SnfClaimData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $pdpmPriorDays = this.getPdpmPriorDays();
    result = result * PRIME + ($pdpmPriorDays == null ? 43 : $pdpmPriorDays.hashCode());
    final java.lang.Object $serviceUnits = this.getServiceUnits();
    result = result * PRIME + ($serviceUnits == null ? 43 : $serviceUnits.hashCode());
    final java.lang.Object $diagnosisCodes = this.getDiagnosisCodes();
    result = result * PRIME + ($diagnosisCodes == null ? 43 : $diagnosisCodes.hashCode());
    final java.lang.Object $hippsCode = this.getHippsCode();
    result = result * PRIME + ($hippsCode == null ? 43 : $hippsCode.hashCode());
    final java.lang.Object $serviceFromDate = this.getServiceFromDate();
    result = result * PRIME + ($serviceFromDate == null ? 43 : $serviceFromDate.hashCode());
    final java.lang.Object $serviceThroughDate = this.getServiceThroughDate();
    result = result * PRIME + ($serviceThroughDate == null ? 43 : $serviceThroughDate.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "SnfClaimData(diagnosisCodes=" + this.getDiagnosisCodes() + ", hippsCode=" + this.getHippsCode() + ", pdpmPriorDays=" + this.getPdpmPriorDays() + ", serviceFromDate=" + this.getServiceFromDate() + ", serviceThroughDate=" + this.getServiceThroughDate() + ", serviceUnits=" + this.getServiceUnits() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SnfClaimData() {
  }
}
