/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;

public final class CsvCharacterEscapes
extends CharacterEscapes {
    private static final long serialVersionUID = 1L;
    private static final CsvCharacterEscapes sNoEscapesInstance = new CsvCharacterEscapes(new int[0]);
    private static final CsvCharacterEscapes sQuoteEscapesInstance;
    private static final CsvCharacterEscapes sControlEscapesInstance;
    private static final CsvCharacterEscapes sControlQuoteEscapesInstance;
    private static final CsvCharacterEscapes[] sEscapes;
    private final int[] escapes;

    private CsvCharacterEscapes(int[] escapes) {
        this.escapes = escapes;
    }

    public static CsvCharacterEscapes noEscapesInstance() {
        return sNoEscapesInstance;
    }

    public static CsvCharacterEscapes quoteEscapesInstance() {
        return sQuoteEscapesInstance;
    }

    public static CsvCharacterEscapes controlEscapesInstance() {
        return sControlEscapesInstance;
    }

    public static CsvCharacterEscapes controlQuoteEscapesInstance() {
        return sControlQuoteEscapesInstance;
    }

    public static CsvCharacterEscapes fromCsvFeatures(int csvFeatures) {
        int idx = 0;
        idx |= CsvGenerator.Feature.ESCAPE_QUOTE_CHAR_WITH_ESCAPE_CHAR.enabledIn(csvFeatures) ? 1 : 0;
        return sEscapes[idx |= CsvGenerator.Feature.ESCAPE_CONTROL_CHARS_WITH_ESCAPE_CHAR.enabledIn(csvFeatures) ? 2 : 0];
    }

    @Override
    public SerializableString getEscapeSequence(int ch) {
        return null;
    }

    @Override
    public int[] getEscapeCodesForAscii() {
        return this.escapes;
    }

    static {
        sControlQuoteEscapesInstance = new CsvCharacterEscapes(CharacterEscapes.standardAsciiEscapesForJSON());
        int[] quoteEscapes = new int[35];
        quoteEscapes[34] = 34;
        sQuoteEscapesInstance = new CsvCharacterEscapes(quoteEscapes);
        int[] controlEscapes = CharacterEscapes.standardAsciiEscapesForJSON();
        controlEscapes[34] = 0;
        sControlEscapesInstance = new CsvCharacterEscapes(controlEscapes);
        sEscapes = new CsvCharacterEscapes[4];
        CsvCharacterEscapes.sEscapes[0] = sNoEscapesInstance;
        CsvCharacterEscapes.sEscapes[1] = sQuoteEscapesInstance;
        CsvCharacterEscapes.sEscapes[2] = sControlEscapesInstance;
        CsvCharacterEscapes.sEscapes[3] = sControlQuoteEscapesInstance;
    }
}

