/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.api.validation.ValidInputCbsa;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

@Schema(description="The per-CBSA wage index data.")
public class CbsaWageIndexData {
    @Schema(description="The core-based statistical area (CBSA) code.", example="47472", required=true)
    @ValidInputCbsa
    private String cbsa;
    @Schema(description="The effective date for the wage indexes.", example="2020-10-20", required=true)
    @StrictLocalDate
    private LocalDate effectiveDate;
    @Schema(description="The geographic wage index.", example="1.2354", required=true)
    @BigDecimalScale(scale=4)
    @DecimalMax(value="99.9999")
    @DecimalMin(value="0")
    @Digits(integer=2, fraction=4)
    private @DecimalMax(value="99.9999") @DecimalMin(value="0") @Digits(integer=2, fraction=4) BigDecimal geographicWageIndex;
    @Schema(description="The imputed floor wage index.", example="1.2354")
    @BigDecimalScale(scale=4)
    @DecimalMax(value="99.9999")
    @DecimalMin(value="0")
    @Digits(integer=2, fraction=4)
    private @DecimalMax(value="99.9999") @DecimalMin(value="0") @Digits(integer=2, fraction=4) BigDecimal imputedFloorWageIndex;
    @Schema(description="A descriptive name for the statistical area.", example="HAWAII")
    private String name;
    @Schema(description="The reclassified wage index.", example="1.2354", required=true)
    @BigDecimalScale(scale=4)
    @DecimalMax(value="99.9999")
    @DecimalMin(value="0")
    @Digits(integer=2, fraction=4)
    private @DecimalMax(value="99.9999") @DecimalMin(value="0") @Digits(integer=2, fraction=4) BigDecimal reclassifiedWageIndex;
    @Schema(description="The rural-floor wage index.", example="1.2354")
    @BigDecimalScale(scale=4)
    @DecimalMax(value="99.9999")
    @DecimalMin(value="0")
    @Digits(integer=2, fraction=4)
    private @DecimalMax(value="99.9999") @DecimalMin(value="0") @Digits(integer=2, fraction=4) BigDecimal ruralFloorWageIndex;
    @Pattern(regexp="[LRO]")
    @Schema(description="The size classification of the CBSA.", example="L")
    private @Pattern(regexp="[LRO]") String size;

    @Generated
    public String getCbsa() {
        return this.cbsa;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public BigDecimal getGeographicWageIndex() {
        return this.geographicWageIndex;
    }

    @Generated
    public BigDecimal getImputedFloorWageIndex() {
        return this.imputedFloorWageIndex;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public BigDecimal getReclassifiedWageIndex() {
        return this.reclassifiedWageIndex;
    }

    @Generated
    public BigDecimal getRuralFloorWageIndex() {
        return this.ruralFloorWageIndex;
    }

    @Generated
    public String getSize() {
        return this.size;
    }

    @Generated
    public void setCbsa(String cbsa) {
        this.cbsa = cbsa;
    }

    @Generated
    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Generated
    public void setGeographicWageIndex(BigDecimal geographicWageIndex) {
        this.geographicWageIndex = geographicWageIndex;
    }

    @Generated
    public void setImputedFloorWageIndex(BigDecimal imputedFloorWageIndex) {
        this.imputedFloorWageIndex = imputedFloorWageIndex;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setReclassifiedWageIndex(BigDecimal reclassifiedWageIndex) {
        this.reclassifiedWageIndex = reclassifiedWageIndex;
    }

    @Generated
    public void setRuralFloorWageIndex(BigDecimal ruralFloorWageIndex) {
        this.ruralFloorWageIndex = ruralFloorWageIndex;
    }

    @Generated
    public void setSize(String size) {
        this.size = size;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CbsaWageIndexData)) {
            return false;
        }
        CbsaWageIndexData other = (CbsaWageIndexData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cbsa = this.getCbsa();
        String other$cbsa = other.getCbsa();
        if (this$cbsa == null ? other$cbsa != null : !this$cbsa.equals(other$cbsa)) {
            return false;
        }
        LocalDate this$effectiveDate = this.getEffectiveDate();
        LocalDate other$effectiveDate = other.getEffectiveDate();
        if (this$effectiveDate == null ? other$effectiveDate != null : !((Object)this$effectiveDate).equals(other$effectiveDate)) {
            return false;
        }
        BigDecimal this$geographicWageIndex = this.getGeographicWageIndex();
        BigDecimal other$geographicWageIndex = other.getGeographicWageIndex();
        if (this$geographicWageIndex == null ? other$geographicWageIndex != null : !((Object)this$geographicWageIndex).equals(other$geographicWageIndex)) {
            return false;
        }
        BigDecimal this$imputedFloorWageIndex = this.getImputedFloorWageIndex();
        BigDecimal other$imputedFloorWageIndex = other.getImputedFloorWageIndex();
        if (this$imputedFloorWageIndex == null ? other$imputedFloorWageIndex != null : !((Object)this$imputedFloorWageIndex).equals(other$imputedFloorWageIndex)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        BigDecimal this$reclassifiedWageIndex = this.getReclassifiedWageIndex();
        BigDecimal other$reclassifiedWageIndex = other.getReclassifiedWageIndex();
        if (this$reclassifiedWageIndex == null ? other$reclassifiedWageIndex != null : !((Object)this$reclassifiedWageIndex).equals(other$reclassifiedWageIndex)) {
            return false;
        }
        BigDecimal this$ruralFloorWageIndex = this.getRuralFloorWageIndex();
        BigDecimal other$ruralFloorWageIndex = other.getRuralFloorWageIndex();
        if (this$ruralFloorWageIndex == null ? other$ruralFloorWageIndex != null : !((Object)this$ruralFloorWageIndex).equals(other$ruralFloorWageIndex)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        return !(this$size == null ? other$size != null : !this$size.equals(other$size));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CbsaWageIndexData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cbsa = this.getCbsa();
        result = result * 59 + ($cbsa == null ? 43 : $cbsa.hashCode());
        LocalDate $effectiveDate = this.getEffectiveDate();
        result = result * 59 + ($effectiveDate == null ? 43 : ((Object)$effectiveDate).hashCode());
        BigDecimal $geographicWageIndex = this.getGeographicWageIndex();
        result = result * 59 + ($geographicWageIndex == null ? 43 : ((Object)$geographicWageIndex).hashCode());
        BigDecimal $imputedFloorWageIndex = this.getImputedFloorWageIndex();
        result = result * 59 + ($imputedFloorWageIndex == null ? 43 : ((Object)$imputedFloorWageIndex).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        BigDecimal $reclassifiedWageIndex = this.getReclassifiedWageIndex();
        result = result * 59 + ($reclassifiedWageIndex == null ? 43 : ((Object)$reclassifiedWageIndex).hashCode());
        BigDecimal $ruralFloorWageIndex = this.getRuralFloorWageIndex();
        result = result * 59 + ($ruralFloorWageIndex == null ? 43 : ((Object)$ruralFloorWageIndex).hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CbsaWageIndexData(cbsa=" + this.getCbsa() + ", effectiveDate=" + this.getEffectiveDate() + ", geographicWageIndex=" + this.getGeographicWageIndex() + ", imputedFloorWageIndex=" + this.getImputedFloorWageIndex() + ", name=" + this.getName() + ", reclassifiedWageIndex=" + this.getReclassifiedWageIndex() + ", ruralFloorWageIndex=" + this.getRuralFloorWageIndex() + ", size=" + this.getSize() + ")";
    }

    @Generated
    public CbsaWageIndexData() {
    }

    @Generated
    public static final class Fields {
        public static final String CBSA = "cbsa";
        public static final String EFFECTIVE_DATE = "effectiveDate";
        public static final String GEOGRAPHIC_WAGE_INDEX = "geographicWageIndex";
        public static final String IMPUTED_FLOOR_WAGE_INDEX = "imputedFloorWageIndex";
        public static final String NAME = "name";
        public static final String RECLASSIFIED_WAGE_INDEX = "reclassifiedWageIndex";
        public static final String RURAL_FLOOR_WAGE_INDEX = "ruralFloorWageIndex";
        public static final String SIZE = "size";
    }
}

