/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.resources;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.api.serialization.BasicIsoDateModule;
import gov.cms.fiss.pricers.common.application.OpenApiApplicationConfiguration;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import io.dropwizard.jersey.jsr310.LocalDateParam;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class BaseRetrievalResource<T, R> {
    public static final String MEDIA_TYPE_CSV = "text/csv";
    protected final Function<List<T>, R> contentEncapsulator;
    public final IntFunction<List<T>> extractionFunction;
    protected static final CsvMapper DEFAULT_CSV_MAPPER = ((CsvMapper)new CsvMapper().enable(CsvParser.Feature.IGNORE_TRAILING_UNMAPPABLE).enable(CsvParser.Feature.FAIL_ON_MISSING_COLUMNS).enable(CsvParser.Feature.SKIP_EMPTY_LINES).findAndRegisterModules().registerModule(new BasicIsoDateModule()).enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN)).enable(CsvGenerator.Feature.STRICT_CHECK_FOR_QUOTING);
    private static final String NOT_FOUND_MESSAGE_TEMPLATE = "No data found for year %s";
    private final Map<Integer, List<T>> perYearEntries = new ConcurrentHashMap<Integer, List<T>>();
    private final Map<Integer, String> perYearCsv = new ConcurrentHashMap<Integer, String>();
    protected final List<Integer> supportedYears;

    protected BaseRetrievalResource(OpenApiApplicationConfiguration pricerConfiguration, Supplier<CsvMapper> csvMapperSupplier, Function<CsvMapper, CsvSchema> csvSchemaGenerator, Function<List<T>, R> contentEncapsulator, IntFunction<List<T>> extractionFunction) {
        CsvMapper csvMapper = csvMapperSupplier.get();
        CsvSchema csvSchema = csvSchemaGenerator.apply(csvMapper);
        this.supportedYears = pricerConfiguration.getSupportedYears();
        this.contentEncapsulator = contentEncapsulator;
        this.extractionFunction = extractionFunction;
        pricerConfiguration.getSupportedYears().forEach(pricerYear -> this.extractAndPopulate(csvMapper, csvSchema, (Integer)pricerYear));
    }

    protected void extractAndPopulate(CsvMapper csvMapper, CsvSchema csvSchema, Integer pricerYear) {
        List<T> entries = this.extract(pricerYear);
        if (!entries.isEmpty()) {
            entries = entries.stream().sorted(Comparator.comparing(this::getDate).reversed()).sorted(Comparator.comparing(this::getKey)).collect(Collectors.toList());
            this.addEntries(pricerYear, entries);
            try {
                this.addCsv(pricerYear, csvMapper.writer(csvSchema).writeValueAsString(entries));
            }
            catch (JsonProcessingException jpe) {
                throw new IllegalStateException("Failed to convert entries to CSV for year " + pricerYear, jpe);
            }
        }
    }

    protected void addEntries(Integer year, List<T> entries) {
        this.perYearEntries.put(year, entries);
    }

    protected void addCsv(Integer year, String entryCsv) {
        this.perYearCsv.put(year, entryCsv);
    }

    protected Response getPerYearEntries(int year, String contentType) throws YearNotImplementedException {
        if (!this.supportedYears.contains(year)) {
            throw new YearNotImplementedException(LocalDate.of(year, 1, 1), "findAll.path param year");
        }
        switch (contentType) {
            case "application/json": {
                List<T> entries = this.perYearEntries.get(year);
                if (entries == null) {
                    throw new NotFoundException(String.format(NOT_FOUND_MESSAGE_TEMPLATE, year));
                }
                return Response.ok(this.contentEncapsulator.apply(entries)).header("Content-Type", "application/json").build();
            }
            case "text/csv": {
                String csvEntries = this.perYearCsv.get(year);
                if (csvEntries == null) {
                    throw new NotFoundException(String.format(NOT_FOUND_MESSAGE_TEMPLATE, year));
                }
                return Response.ok(csvEntries).header("Content-Type", MEDIA_TYPE_CSV).build();
            }
        }
        throw new NotAcceptableException(String.format("%s is not supported. Must be one of: %s", contentType, String.join((CharSequence)", ", "application/json", MEDIA_TYPE_CSV)));
    }

    protected List<T> findByPredicate(int year, Predicate<T> filter) {
        List<T> matchedEntries = this.perYearEntries.get(year);
        if (matchedEntries != null && filter != null && (matchedEntries = matchedEntries.stream().filter(filter).collect(Collectors.toList())).isEmpty()) {
            matchedEntries = null;
        }
        return matchedEntries;
    }

    protected Response respondWithEntries(List<T> matchedEntries) {
        if (matchedEntries == null) {
            throw new NotFoundException("No matching entries found");
        }
        return Response.ok(this.contentEncapsulator.apply(matchedEntries)).header("Content-Type", "application/json").build();
    }

    protected Response findExactMatch(int year, String key, LocalDateParam effectiveDate) throws YearNotImplementedException {
        if (!this.supportedYears.contains(year)) {
            throw new YearNotImplementedException(LocalDate.of(year, 1, 1), "findAll.path param year");
        }
        Predicate<Object> filter = entry -> key.equals(this.getKey(entry));
        if (effectiveDate != null) {
            filter = filter.and(entry -> ((LocalDate)effectiveDate.get()).equals(this.getDate(entry)));
        }
        return this.respondWithEntries(this.findByPredicate(year, filter));
    }

    protected Response findByCodeAndDateRange(String key, int limit, LocalDateParam afterDate, LocalDateParam beforeDate, boolean exclusiveAfter, boolean exclusiveBefore) {
        BiPredicate<LocalDate, LocalDate> condition;
        List<Object> returnEntries = new ArrayList();
        Predicate<Object> filter = entry -> key.equals(this.getKey(entry));
        if (afterDate != null) {
            condition = exclusiveAfter ? LocalDateUtils::isAfter : LocalDateUtils::isAfterOrEqual;
            filter = filter.and(entry -> condition.test(this.getDate(entry), (LocalDate)afterDate.get()));
        }
        if (beforeDate != null) {
            condition = exclusiveBefore ? LocalDateUtils::isBefore : LocalDateUtils::isBeforeOrEqual;
            filter = filter.and(entry -> condition.test(this.getDate(entry), (LocalDate)beforeDate.get()));
        }
        Iterator iterator = this.supportedYears.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList()).iterator();
        while (iterator.hasNext()) {
            int year = (Integer)iterator.next();
            List<Object> matchedEntries = this.findByPredicate(year, filter);
            if (matchedEntries != null) {
                returnEntries.addAll(matchedEntries);
            }
            if (returnEntries.size() < limit) continue;
            break;
        }
        if (returnEntries.size() > limit) {
            returnEntries = returnEntries.subList(0, limit);
        }
        return this.respondWithEntries(returnEntries.isEmpty() ? null : returnEntries);
    }

    public List<T> extract(int pricerYear) {
        return this.extractionFunction.apply(pricerYear);
    }

    protected abstract LocalDate getDate(T var1);

    protected abstract String getKey(T var1);
}

