/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;

@Schema(description="The billing information associated with the claim.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="SNF-INPUT-DATA", value="<structure>")})})
public class SnfClaimData
extends ClaimData {
    @ArraySchema(arraySchema=@Schema(description="The diagnosis codes associated with this claim.", example="[\"B10\",\"A509\"]", maxLength=7, extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="SNF-DIAGNOSIS-CODES", value="PIC X(175)")})}))
    @Size(max=25, min=1)
    private @Size(max=25, min=1) List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> diagnosisCodes;
    @NotNull
    @Pattern(regexp="[A-Z\\d]{5}", message="must be five alphanumeric characters")
    @Schema(description="The Health Insurance Prospective Payment System Code (HIPPS) code.", example="BARD0", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="SNF-HIPPS-CODE", value="PIC X(05)")})})
    private @NotNull @Pattern(regexp="[A-Z\\d]{5}", message="must be five alphanumeric characters") String hippsCode;
    @Max(value=999L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The number of prior SNF days from claims history.", example="15", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PDPM-DATA", value="SNF-PDPM-PRIOR-DAYS PIC 999")})})
    private @Max(value=999L) @Min(value=0L) @NotNull Integer pdpmPriorDays;
    @NotNull
    @Schema(description="The start date of service.", example="2020-05-13", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="SNF-FROM-DATE", value="PIC X(08)")})})
    @StrictLocalDate
    private LocalDate serviceFromDate;
    @NotNull
    @Schema(description="The end date of service.", example="2020-05-25", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="SNF-THRU-DATE", value="PIC X(08)")})})
    @StrictLocalDate
    private LocalDate serviceThroughDate;
    @Max(value=99L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The number of service units reported.", example="23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PDPM-DATA", value="SNF-PDPM-UNITS PIC 99")})})
    private @Max(value=99L) @Min(value=0L) @NotNull Integer serviceUnits;

    @Generated
    public List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> getDiagnosisCodes() {
        return this.diagnosisCodes;
    }

    @Generated
    public String getHippsCode() {
        return this.hippsCode;
    }

    @Generated
    public Integer getPdpmPriorDays() {
        return this.pdpmPriorDays;
    }

    @Generated
    public LocalDate getServiceFromDate() {
        return this.serviceFromDate;
    }

    @Generated
    public LocalDate getServiceThroughDate() {
        return this.serviceThroughDate;
    }

    @Generated
    public Integer getServiceUnits() {
        return this.serviceUnits;
    }

    @Generated
    public void setDiagnosisCodes(List<@Pattern(regexp="[A-Z\\d]{2,7}", message="must be two to seven alphanumeric characters") String> diagnosisCodes) {
        this.diagnosisCodes = diagnosisCodes;
    }

    @Generated
    public void setHippsCode(String hippsCode) {
        this.hippsCode = hippsCode;
    }

    @Generated
    public void setPdpmPriorDays(Integer pdpmPriorDays) {
        this.pdpmPriorDays = pdpmPriorDays;
    }

    @Generated
    public void setServiceFromDate(LocalDate serviceFromDate) {
        this.serviceFromDate = serviceFromDate;
    }

    @Generated
    public void setServiceThroughDate(LocalDate serviceThroughDate) {
        this.serviceThroughDate = serviceThroughDate;
    }

    @Generated
    public void setServiceUnits(Integer serviceUnits) {
        this.serviceUnits = serviceUnits;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnfClaimData)) {
            return false;
        }
        SnfClaimData other = (SnfClaimData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$pdpmPriorDays = this.getPdpmPriorDays();
        Integer other$pdpmPriorDays = other.getPdpmPriorDays();
        if (this$pdpmPriorDays == null ? other$pdpmPriorDays != null : !((Object)this$pdpmPriorDays).equals(other$pdpmPriorDays)) {
            return false;
        }
        Integer this$serviceUnits = this.getServiceUnits();
        Integer other$serviceUnits = other.getServiceUnits();
        if (this$serviceUnits == null ? other$serviceUnits != null : !((Object)this$serviceUnits).equals(other$serviceUnits)) {
            return false;
        }
        List<String> this$diagnosisCodes = this.getDiagnosisCodes();
        List<String> other$diagnosisCodes = other.getDiagnosisCodes();
        if (this$diagnosisCodes == null ? other$diagnosisCodes != null : !((Object)this$diagnosisCodes).equals(other$diagnosisCodes)) {
            return false;
        }
        String this$hippsCode = this.getHippsCode();
        String other$hippsCode = other.getHippsCode();
        if (this$hippsCode == null ? other$hippsCode != null : !this$hippsCode.equals(other$hippsCode)) {
            return false;
        }
        LocalDate this$serviceFromDate = this.getServiceFromDate();
        LocalDate other$serviceFromDate = other.getServiceFromDate();
        if (this$serviceFromDate == null ? other$serviceFromDate != null : !((Object)this$serviceFromDate).equals(other$serviceFromDate)) {
            return false;
        }
        LocalDate this$serviceThroughDate = this.getServiceThroughDate();
        LocalDate other$serviceThroughDate = other.getServiceThroughDate();
        return !(this$serviceThroughDate == null ? other$serviceThroughDate != null : !((Object)this$serviceThroughDate).equals(other$serviceThroughDate));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnfClaimData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $pdpmPriorDays = this.getPdpmPriorDays();
        result = result * 59 + ($pdpmPriorDays == null ? 43 : ((Object)$pdpmPriorDays).hashCode());
        Integer $serviceUnits = this.getServiceUnits();
        result = result * 59 + ($serviceUnits == null ? 43 : ((Object)$serviceUnits).hashCode());
        List<String> $diagnosisCodes = this.getDiagnosisCodes();
        result = result * 59 + ($diagnosisCodes == null ? 43 : ((Object)$diagnosisCodes).hashCode());
        String $hippsCode = this.getHippsCode();
        result = result * 59 + ($hippsCode == null ? 43 : $hippsCode.hashCode());
        LocalDate $serviceFromDate = this.getServiceFromDate();
        result = result * 59 + ($serviceFromDate == null ? 43 : ((Object)$serviceFromDate).hashCode());
        LocalDate $serviceThroughDate = this.getServiceThroughDate();
        result = result * 59 + ($serviceThroughDate == null ? 43 : ((Object)$serviceThroughDate).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SnfClaimData(diagnosisCodes=" + this.getDiagnosisCodes() + ", hippsCode=" + this.getHippsCode() + ", pdpmPriorDays=" + this.getPdpmPriorDays() + ", serviceFromDate=" + this.getServiceFromDate() + ", serviceThroughDate=" + this.getServiceThroughDate() + ", serviceUnits=" + this.getServiceUnits() + ")";
    }

    @Generated
    public SnfClaimData() {
    }
}

