/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.core.ReturnCode;
import gov.cms.fiss.pricers.snf.core.SnfPricerContext;
import gov.cms.fiss.pricers.snf.core.tables.CbsaWageIndexEntry;
import java.math.BigDecimal;
import java.time.LocalDate;

public class DetermineWageIndex
implements CalculationRule<SnfClaimPricingRequest, SnfClaimPricingResponse, SnfPricerContext> {
    @Override
    public void calculate(SnfPricerContext context) {
        BigDecimal specialWageIndex = context.getProviderData().getSpecialWageIndex();
        String cbsa = context.getProviderData().getCbsaActualGeographicLocation();
        if (context.hasSpecialWageIndexAdjustment()) {
            context.setWageIndex(specialWageIndex);
        } else {
            LocalDate throughDate = context.getClaimData().getServiceThroughDate();
            CbsaWageIndexEntry wageIndexEntry = context.getDataTables().getCbsaWageIndexEntry(cbsa, throughDate);
            if (wageIndexEntry == null) {
                context.applyReturnCodeAndTerminate(ReturnCode.INVALID_CBSA_OR_WAGE_INDEX_30);
                return;
            }
            context.setWageIndex(wageIndexEntry.getGeographicWageIndex());
        }
    }
}

