/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.rules.rate_selection;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingRequest;
import gov.cms.fiss.pricers.snf.api.v2.SnfClaimPricingResponse;
import gov.cms.fiss.pricers.snf.core.ReturnCode;
import gov.cms.fiss.pricers.snf.core.SnfPricerContext;
import gov.cms.fiss.pricers.snf.core.tables.NonTherapyAncillaryRateEntry;

public class SelectNonTherapyAncillaryRate
implements CalculationRule<SnfClaimPricingRequest, SnfClaimPricingResponse, SnfPricerContext> {
    @Override
    public void calculate(SnfPricerContext context) {
        NonTherapyAncillaryRateEntry entry;
        String group = Character.toString(context.getHippsCode().charAt(3));
        if (context.hasAidsAdjustment()) {
            if (group.matches("[A-D]")) {
                group = "A";
            } else if (group.equals("E")) {
                group = "B";
            } else if (group.equals("F")) {
                group = "C";
            }
        }
        if ((entry = context.getDataTables().getNonTherapyAncillaryRate(context.hasRuralCbsa(), group)) == null) {
            context.applyReturnCodeAndTerminate(ReturnCode.INVALID_RATE_COMPONENT_20);
            return;
        }
        if (context.hasQualityAdjustment()) {
            context.setNonTherapyAncillaryRate(entry.getQualityAdjustedRate());
        } else {
            context.setNonTherapyAncillaryRate(entry.getRate());
        }
    }
}

