/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import java.util.Locale;
import net.sourceforge.argparse4j.helper.MessageLocalization;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MetavarInference;

public class CaseInsensitiveEnumArgumentType<T extends Enum<T>>
implements ArgumentType<T>,
MetavarInference {
    protected Class<T> type_;
    private final Locale lowerCasingLocale_;

    @Deprecated
    public CaseInsensitiveEnumArgumentType(Class<T> type) {
        this(type, Locale.getDefault());
    }

    protected CaseInsensitiveEnumArgumentType(Class<T> type, Locale lowerCasingLocale) {
        this.type_ = type;
        this.lowerCasingLocale_ = lowerCasingLocale;
    }

    @Override
    public T convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        String valueForComparison = this.toCaseInsensitiveForm(value);
        for (Enum t2 : (Enum[])this.type_.getEnumConstants()) {
            if (!this.toCaseInsensitiveForm(this.toStringRepresentation(t2)).equals(valueForComparison)) continue;
            return (T)t2;
        }
        String choices = TextHelper.concat(this.getStringRepresentations(), 0, ",", "{", "}");
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, MessageLocalization.localize(parser.getConfig().getResourceBundle(), "couldNotConvertChooseFromError"), value, choices), parser, arg);
    }

    protected String toStringRepresentation(T t2) {
        return ((Enum)t2).name();
    }

    @Override
    public String[] inferMetavar() {
        return new String[]{TextHelper.concat(this.getStringRepresentations(), 0, ",", "{", "}")};
    }

    protected Object[] getStringRepresentations() {
        return this.type_.getEnumConstants();
    }

    private String toCaseInsensitiveForm(String value) {
        return value.toLowerCase(this.lowerCasingLocale_);
    }
}

