// Generated by delombok at Thu Nov 13 21:14:24 UTC 2025
package gov.cms.fiss.pricers.snf.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.snf.api.validation.ValidSignedDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;

@Schema(description = "The SNF prospective payment data.", extensions = @Extension(name = "cobol-declaration", properties = @ExtensionProperty(name = "SNF-INPUT-DATA", value = "<structure>")))
public class SnfPaymentData extends PaymentData {
  @NotNull
  @Pattern(regexp = "^[YN0]$", message = "must be one of \'Y\', \'N\', or \'0\'")
  @Schema(description = "The flag indicating if an AIDS adjustment is applicable.", example = "Y", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "AIDS-ADD-ON-IND", value = "PIC X")})})
  private String aidsAddOnIndicator = "0";
  @NotNull
  @Pattern(regexp = "^[YN0]$", message = "must be one of \'Y\', \'N\', or \'0\'")
  @Schema(description = "The flag indicating if a quality reporting program (QRP) adjustment is applicable.", example = "Y", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "QRP-IND", value = "PIC X")})})
  private String qualityReportingProgramIndicator = "0";
  @NotNull
  @Pattern(regexp = "^[RU]$", message = "must be one of \'R\' or \'U\'")
  @Schema(description = "The flag indicating if core-based statistical area (CBSA) is rural or urban.", example = "U", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "REGION-IND", value = "PIC X")})})
  private String regionIndicator;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The value-based purchasing payment difference.", example = "324.23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "VBP-PAY-DIFF", value = "PIC S9(06)V9(02)")})})
  @ValidSignedDecimalOutputWithTwoFractionDigits
  private BigDecimal valueBasedPurchasingPaymentDifference;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAidsAddOnIndicator() {
    return this.aidsAddOnIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getQualityReportingProgramIndicator() {
    return this.qualityReportingProgramIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRegionIndicator() {
    return this.regionIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getValueBasedPurchasingPaymentDifference() {
    return this.valueBasedPurchasingPaymentDifference;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAidsAddOnIndicator(final String aidsAddOnIndicator) {
    this.aidsAddOnIndicator = aidsAddOnIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setQualityReportingProgramIndicator(final String qualityReportingProgramIndicator) {
    this.qualityReportingProgramIndicator = qualityReportingProgramIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegionIndicator(final String regionIndicator) {
    this.regionIndicator = regionIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setValueBasedPurchasingPaymentDifference(final BigDecimal valueBasedPurchasingPaymentDifference) {
    this.valueBasedPurchasingPaymentDifference = valueBasedPurchasingPaymentDifference;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof SnfPaymentData)) return false;
    final SnfPaymentData other = (SnfPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$aidsAddOnIndicator = this.getAidsAddOnIndicator();
    final java.lang.Object other$aidsAddOnIndicator = other.getAidsAddOnIndicator();
    if (this$aidsAddOnIndicator == null ? other$aidsAddOnIndicator != null : !this$aidsAddOnIndicator.equals(other$aidsAddOnIndicator)) return false;
    final java.lang.Object this$qualityReportingProgramIndicator = this.getQualityReportingProgramIndicator();
    final java.lang.Object other$qualityReportingProgramIndicator = other.getQualityReportingProgramIndicator();
    if (this$qualityReportingProgramIndicator == null ? other$qualityReportingProgramIndicator != null : !this$qualityReportingProgramIndicator.equals(other$qualityReportingProgramIndicator)) return false;
    final java.lang.Object this$regionIndicator = this.getRegionIndicator();
    final java.lang.Object other$regionIndicator = other.getRegionIndicator();
    if (this$regionIndicator == null ? other$regionIndicator != null : !this$regionIndicator.equals(other$regionIndicator)) return false;
    final java.lang.Object this$valueBasedPurchasingPaymentDifference = this.getValueBasedPurchasingPaymentDifference();
    final java.lang.Object other$valueBasedPurchasingPaymentDifference = other.getValueBasedPurchasingPaymentDifference();
    if (this$valueBasedPurchasingPaymentDifference == null ? other$valueBasedPurchasingPaymentDifference != null : !this$valueBasedPurchasingPaymentDifference.equals(other$valueBasedPurchasingPaymentDifference)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof SnfPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $aidsAddOnIndicator = this.getAidsAddOnIndicator();
    result = result * PRIME + ($aidsAddOnIndicator == null ? 43 : $aidsAddOnIndicator.hashCode());
    final java.lang.Object $qualityReportingProgramIndicator = this.getQualityReportingProgramIndicator();
    result = result * PRIME + ($qualityReportingProgramIndicator == null ? 43 : $qualityReportingProgramIndicator.hashCode());
    final java.lang.Object $regionIndicator = this.getRegionIndicator();
    result = result * PRIME + ($regionIndicator == null ? 43 : $regionIndicator.hashCode());
    final java.lang.Object $valueBasedPurchasingPaymentDifference = this.getValueBasedPurchasingPaymentDifference();
    result = result * PRIME + ($valueBasedPurchasingPaymentDifference == null ? 43 : $valueBasedPurchasingPaymentDifference.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "SnfPaymentData(aidsAddOnIndicator=" + this.getAidsAddOnIndicator() + ", qualityReportingProgramIndicator=" + this.getQualityReportingProgramIndicator() + ", regionIndicator=" + this.getRegionIndicator() + ", valueBasedPurchasingPaymentDifference=" + this.getValueBasedPurchasingPaymentDifference() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SnfPaymentData() {
  }
}
