/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidOutputCbsa;
import gov.cms.fiss.pricers.common.api.validation.ValidWageIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import lombok.Generated;

@Schema(description="Defines the payment data resulting from claim pricing.")
public class PaymentData {
    @Schema(description="The final core-based statistical area (CBSA) used for pricing.", example="32")
    @ValidOutputCbsa
    private String finalCbsa;
    @BigDecimalScale(scale=4)
    @Schema(description="The final wage index used for pricing.", example="1.9844")
    @ValidWageIndex
    private BigDecimal finalWageIndex;
    @BigDecimalScale
    @ValidDecimalOutputWithTwoFractionDigits
    @NotNull
    @Schema(description="The rate at which the claim will be paid.", example="1238.45")
    private BigDecimal totalPayment;

    @Generated
    public String getFinalCbsa() {
        return this.finalCbsa;
    }

    @Generated
    public BigDecimal getFinalWageIndex() {
        return this.finalWageIndex;
    }

    @Generated
    public BigDecimal getTotalPayment() {
        return this.totalPayment;
    }

    @Generated
    public void setFinalCbsa(String finalCbsa) {
        this.finalCbsa = finalCbsa;
    }

    @Generated
    public void setFinalWageIndex(BigDecimal finalWageIndex) {
        this.finalWageIndex = finalWageIndex;
    }

    @Generated
    public void setTotalPayment(BigDecimal totalPayment) {
        this.totalPayment = totalPayment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentData)) {
            return false;
        }
        PaymentData other = (PaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$finalCbsa = this.getFinalCbsa();
        String other$finalCbsa = other.getFinalCbsa();
        if (this$finalCbsa == null ? other$finalCbsa != null : !this$finalCbsa.equals(other$finalCbsa)) {
            return false;
        }
        BigDecimal this$finalWageIndex = this.getFinalWageIndex();
        BigDecimal other$finalWageIndex = other.getFinalWageIndex();
        if (this$finalWageIndex == null ? other$finalWageIndex != null : !((Object)this$finalWageIndex).equals(other$finalWageIndex)) {
            return false;
        }
        BigDecimal this$totalPayment = this.getTotalPayment();
        BigDecimal other$totalPayment = other.getTotalPayment();
        return !(this$totalPayment == null ? other$totalPayment != null : !((Object)this$totalPayment).equals(other$totalPayment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $finalCbsa = this.getFinalCbsa();
        result = result * 59 + ($finalCbsa == null ? 43 : $finalCbsa.hashCode());
        BigDecimal $finalWageIndex = this.getFinalWageIndex();
        result = result * 59 + ($finalWageIndex == null ? 43 : ((Object)$finalWageIndex).hashCode());
        BigDecimal $totalPayment = this.getTotalPayment();
        result = result * 59 + ($totalPayment == null ? 43 : ((Object)$totalPayment).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PaymentData(finalCbsa=" + this.getFinalCbsa() + ", finalWageIndex=" + this.getFinalWageIndex() + ", totalPayment=" + this.getTotalPayment() + ")";
    }

    @Generated
    public PaymentData() {
    }
}

