/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.snf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.snf.core.tables.NursingRateEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class NursingRateLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/nursing-rates-%s.csv";
    private final CsvContentReader<NursingRateEntry> contentProvider = new CsvContentReader<NursingRateEntry>(NursingRateEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public NursingRateLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, Map<String, NursingRateEntry>> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, Map<String, NursingRateEntry>> generate(String csvFile) {
        List<NursingRateEntry> content = this.contentProvider.read(csvFile);
        BinaryOperator comparator = BinaryOperator.maxBy((a, b) -> 0);
        Collector<NursingRateEntry, ?, Map> collector = Collectors.toMap(NursingRateEntry::getGroup, Function.identity(), comparator, HashMap::new);
        return LookupGenerator.generateCrossReferenceToMap(NursingRateEntry::getRegion, content, HashMap::new, collector);
    }
}

