// Generated by delombok at Thu Nov 13 21:14:46 UTC 2025
package gov.cms.fiss.pricers.snf.core.tables;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.snf.core.tables.PhysicalAndOccupationalTherapyRateEntry.Fields;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import javax.annotation.concurrent.Immutable;

/**
 * Model for the PT/OT CSV file.
 */
@Immutable
@JsonDeserialize(builder = PhysicalAndOccupationalTherapyRateEntry.PhysicalAndOccupationalTherapyRateEntryBuilder.class)
@JsonPropertyOrder({Fields.REGION, Fields.GROUP, Fields.PHYSICAL_THERAPY_RATE, Fields.QUALITY_ADJUSTED_PHYSICAL_THERAPY_RATE, Fields.OCCUPATIONAL_THERAPY_RATE, Fields.QUALITY_ADJUSTED_OCCUPATIONAL_THERAPY_RATE})
public class PhysicalAndOccupationalTherapyRateEntry {

  @JsonPOJOBuilder(withPrefix = "")
  public static class PhysicalAndOccupationalTherapyRateEntryBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String region;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String group;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal physicalTherapyRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal qualityAdjustedPhysicalTherapyRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal occupationalTherapyRate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal qualityAdjustedOccupationalTherapyRate;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    PhysicalAndOccupationalTherapyRateEntryBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PhysicalAndOccupationalTherapyRateEntry.PhysicalAndOccupationalTherapyRateEntryBuilder region(final String region) {
      this.region = region;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PhysicalAndOccupationalTherapyRateEntry.PhysicalAndOccupationalTherapyRateEntryBuilder group(final String group) {
      this.group = group;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PhysicalAndOccupationalTherapyRateEntry.PhysicalAndOccupationalTherapyRateEntryBuilder physicalTherapyRate(final BigDecimal physicalTherapyRate) {
      this.physicalTherapyRate = physicalTherapyRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PhysicalAndOccupationalTherapyRateEntry.PhysicalAndOccupationalTherapyRateEntryBuilder qualityAdjustedPhysicalTherapyRate(final BigDecimal qualityAdjustedPhysicalTherapyRate) {
      this.qualityAdjustedPhysicalTherapyRate = qualityAdjustedPhysicalTherapyRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PhysicalAndOccupationalTherapyRateEntry.PhysicalAndOccupationalTherapyRateEntryBuilder occupationalTherapyRate(final BigDecimal occupationalTherapyRate) {
      this.occupationalTherapyRate = occupationalTherapyRate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PhysicalAndOccupationalTherapyRateEntry.PhysicalAndOccupationalTherapyRateEntryBuilder qualityAdjustedOccupationalTherapyRate(final BigDecimal qualityAdjustedOccupationalTherapyRate) {
      this.qualityAdjustedOccupationalTherapyRate = qualityAdjustedOccupationalTherapyRate;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PhysicalAndOccupationalTherapyRateEntry build() {
      return new PhysicalAndOccupationalTherapyRateEntry(this.region, this.group, this.physicalTherapyRate, this.qualityAdjustedPhysicalTherapyRate, this.occupationalTherapyRate, this.qualityAdjustedOccupationalTherapyRate);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "PhysicalAndOccupationalTherapyRateEntry.PhysicalAndOccupationalTherapyRateEntryBuilder(region=" + this.region + ", group=" + this.group + ", physicalTherapyRate=" + this.physicalTherapyRate + ", qualityAdjustedPhysicalTherapyRate=" + this.qualityAdjustedPhysicalTherapyRate + ", occupationalTherapyRate=" + this.occupationalTherapyRate + ", qualityAdjustedOccupationalTherapyRate=" + this.qualityAdjustedOccupationalTherapyRate + ")";
    }
  }

  @Pattern(regexp = "RURAL|URBAN", message = "must be either RURAL or URBAN")
  private final String region;
  @Pattern(regexp = "[A-P]", message = "must be single letter A-P")
  private final String group;
  @Digits(integer = 4, fraction = 2)
  @DecimalMin("0.0")
  @DecimalMax("9999.99")
  private final BigDecimal physicalTherapyRate;
  @Digits(integer = 4, fraction = 2)
  @DecimalMin("0.0")
  @DecimalMax("9999.99")
  private final BigDecimal qualityAdjustedPhysicalTherapyRate;
  @Digits(integer = 4, fraction = 2)
  @DecimalMin("0.0")
  @DecimalMax("9999.99")
  private final BigDecimal occupationalTherapyRate;
  @Digits(integer = 4, fraction = 2)
  @DecimalMin("0.0")
  @DecimalMax("9999.99")
  private final BigDecimal qualityAdjustedOccupationalTherapyRate;

  public PhysicalAndOccupationalTherapyRateEntryBuilder copyBuilder() {
    return PhysicalAndOccupationalTherapyRateEntry.builder().region(getRegion()).group(getGroup()).physicalTherapyRate(getPhysicalTherapyRate()).qualityAdjustedPhysicalTherapyRate(getQualityAdjustedPhysicalTherapyRate()).occupationalTherapyRate(getOccupationalTherapyRate()).qualityAdjustedOccupationalTherapyRate(getQualityAdjustedOccupationalTherapyRate());
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  PhysicalAndOccupationalTherapyRateEntry(final String region, final String group, final BigDecimal physicalTherapyRate, final BigDecimal qualityAdjustedPhysicalTherapyRate, final BigDecimal occupationalTherapyRate, final BigDecimal qualityAdjustedOccupationalTherapyRate) {
    this.region = region;
    this.group = group;
    this.physicalTherapyRate = physicalTherapyRate;
    this.qualityAdjustedPhysicalTherapyRate = qualityAdjustedPhysicalTherapyRate;
    this.occupationalTherapyRate = occupationalTherapyRate;
    this.qualityAdjustedOccupationalTherapyRate = qualityAdjustedOccupationalTherapyRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static PhysicalAndOccupationalTherapyRateEntry.PhysicalAndOccupationalTherapyRateEntryBuilder builder() {
    return new PhysicalAndOccupationalTherapyRateEntry.PhysicalAndOccupationalTherapyRateEntryBuilder();
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof PhysicalAndOccupationalTherapyRateEntry)) return false;
    final PhysicalAndOccupationalTherapyRateEntry other = (PhysicalAndOccupationalTherapyRateEntry) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$region = this.getRegion();
    final java.lang.Object other$region = other.getRegion();
    if (this$region == null ? other$region != null : !this$region.equals(other$region)) return false;
    final java.lang.Object this$group = this.getGroup();
    final java.lang.Object other$group = other.getGroup();
    if (this$group == null ? other$group != null : !this$group.equals(other$group)) return false;
    final java.lang.Object this$physicalTherapyRate = this.getPhysicalTherapyRate();
    final java.lang.Object other$physicalTherapyRate = other.getPhysicalTherapyRate();
    if (this$physicalTherapyRate == null ? other$physicalTherapyRate != null : !this$physicalTherapyRate.equals(other$physicalTherapyRate)) return false;
    final java.lang.Object this$qualityAdjustedPhysicalTherapyRate = this.getQualityAdjustedPhysicalTherapyRate();
    final java.lang.Object other$qualityAdjustedPhysicalTherapyRate = other.getQualityAdjustedPhysicalTherapyRate();
    if (this$qualityAdjustedPhysicalTherapyRate == null ? other$qualityAdjustedPhysicalTherapyRate != null : !this$qualityAdjustedPhysicalTherapyRate.equals(other$qualityAdjustedPhysicalTherapyRate)) return false;
    final java.lang.Object this$occupationalTherapyRate = this.getOccupationalTherapyRate();
    final java.lang.Object other$occupationalTherapyRate = other.getOccupationalTherapyRate();
    if (this$occupationalTherapyRate == null ? other$occupationalTherapyRate != null : !this$occupationalTherapyRate.equals(other$occupationalTherapyRate)) return false;
    final java.lang.Object this$qualityAdjustedOccupationalTherapyRate = this.getQualityAdjustedOccupationalTherapyRate();
    final java.lang.Object other$qualityAdjustedOccupationalTherapyRate = other.getQualityAdjustedOccupationalTherapyRate();
    if (this$qualityAdjustedOccupationalTherapyRate == null ? other$qualityAdjustedOccupationalTherapyRate != null : !this$qualityAdjustedOccupationalTherapyRate.equals(other$qualityAdjustedOccupationalTherapyRate)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof PhysicalAndOccupationalTherapyRateEntry;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $region = this.getRegion();
    result = result * PRIME + ($region == null ? 43 : $region.hashCode());
    final java.lang.Object $group = this.getGroup();
    result = result * PRIME + ($group == null ? 43 : $group.hashCode());
    final java.lang.Object $physicalTherapyRate = this.getPhysicalTherapyRate();
    result = result * PRIME + ($physicalTherapyRate == null ? 43 : $physicalTherapyRate.hashCode());
    final java.lang.Object $qualityAdjustedPhysicalTherapyRate = this.getQualityAdjustedPhysicalTherapyRate();
    result = result * PRIME + ($qualityAdjustedPhysicalTherapyRate == null ? 43 : $qualityAdjustedPhysicalTherapyRate.hashCode());
    final java.lang.Object $occupationalTherapyRate = this.getOccupationalTherapyRate();
    result = result * PRIME + ($occupationalTherapyRate == null ? 43 : $occupationalTherapyRate.hashCode());
    final java.lang.Object $qualityAdjustedOccupationalTherapyRate = this.getQualityAdjustedOccupationalTherapyRate();
    result = result * PRIME + ($qualityAdjustedOccupationalTherapyRate == null ? 43 : $qualityAdjustedOccupationalTherapyRate.hashCode());
    return result;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String REGION = "region";
    public static final java.lang.String GROUP = "group";
    public static final java.lang.String PHYSICAL_THERAPY_RATE = "physicalTherapyRate";
    public static final java.lang.String QUALITY_ADJUSTED_PHYSICAL_THERAPY_RATE = "qualityAdjustedPhysicalTherapyRate";
    public static final java.lang.String OCCUPATIONAL_THERAPY_RATE = "occupationalTherapyRate";
    public static final java.lang.String QUALITY_ADJUSTED_OCCUPATIONAL_THERAPY_RATE = "qualityAdjustedOccupationalTherapyRate";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getRegion() {
    return this.region;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getGroup() {
    return this.group;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPhysicalTherapyRate() {
    return this.physicalTherapyRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getQualityAdjustedPhysicalTherapyRate() {
    return this.qualityAdjustedPhysicalTherapyRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOccupationalTherapyRate() {
    return this.occupationalTherapyRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getQualityAdjustedOccupationalTherapyRate() {
    return this.qualityAdjustedOccupationalTherapyRate;
  }
}
