
* PROGRAM: COST_SHARING_EDUCATION_DIABETES.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR EDUCATION DIABETES CLAIMS;


%MACRO DIAB_COST_SHARE(SERV_CAT);

  DATA DIAB_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY='14e'));
  RUN;

  DATA DIAB_FILE;
    SET  PBP_FILE (KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B14E_MAXENR_AMT_DIAB PBP_B14E_MAXENR_PER_DIAB
                   PBP_B14E_COPAY_AMT_MIN_DIAB PBP_B14E_COPAY_AMT_MAX_DIAB
                   PBP_B14E_COINS_PCT_MIN_DIAB PBP_B14E_COINS_PCT_MAX_DIAB
                   PBP_B14E_DED_AMT_DIAB
                   PBP_A_PLAN_TYPE
                   PBP_D_DIFF_DEDUCT_14E_AMT
                   PBP_B14E_COINS_EHC
                   PBP_B14E_COPAY_EHC
                   PBP_B14E_DED_EHC
                   PBP_B14E_MAXENR_EHC
                   );
    JOIN_ID = '1';
    %ANNUALIZATION(PBP_B14E_MAXENR_PER_DIAB,PBP_B14E_MAXENR_AMT_DIAB);
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.YEAR, P.*
      FROM DIAB_BASEID B, DIAB_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;
     
  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='14e'));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  DATA &SERV_CAT;
    SET CAT_JOIN (DROP = JOIN_ID);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;

    IF PLAN_DED_CAT='1' THEN DO;
      IF PLAN_DED_AMTTOT_MC_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC_PTB;
      ELSE CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC;
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN 
      CAT_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_14E_AMT;
    ELSE IF SUBSTR(PBP_B14E_DED_EHC,3,1) = '1' THEN
      CAT_DEDUCTIBLE=PBP_B14E_DED_AMT_DIAB;
        
    IF PBP_B14E_MAXENR_AMT_DIAB NE . & SUBSTR(PBP_B14E_MAXENR_EHC,3,1) = '1' THEN 
      BENE_MAXIMUM = PBP_B14E_MAXENR_AMT_DIAB;
    
    IF CAT_DEDUCTIBLE = . THEN DO;
      IF SUBSTR(PBP_B14E_COPAY_EHC,3,1) = '1' THEN 
        COST = SUM(COST,(VISITS*PBP_B14E_COPAY_AMT_MIN_DIAB));
      IF SUBSTR(PBP_B14E_COINS_EHC,3,1) = '1' THEN 
        COST = SUM(COST,(AMTTOT*PBP_B14E_COINS_PCT_MIN_DIAB));
    END;
    ELSE DO;
      IF AMTTOT <= CAT_DEDUCTIBLE THEN DO;
        COST = AMTTOT;
      END;
      ELSE DO;
        COST = CAT_DEDUCTIBLE;
        DEDUCT_SHARE = CAT_DEDUCTIBLE / AMTTOT;
        AMTTOT = SUM(AMTTOT,-CAT_DEDUCTIBLE);
        VISITS = VISITS * (1 - DEDUCT_SHARE);
        IF SUBSTR(PBP_B14E_COPAY_EHC,3,1) = '1' THEN 
          COST = SUM(COST,(VISITS*PBP_B14E_COPAY_AMT_MIN_DIAB));
        IF SUBSTR(PBP_B14E_COINS_EHC,3,1) = '1' THEN 
          COST = SUM(COST,(AMTTOT*PBP_B14E_COINS_PCT_MIN_DIAB));
      END;
    END;
    
    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN 
      COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;
    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "14e";
  RUN;

  PROC APPEND DATA=DIAB(KEEP=HPLAN YEAR BASEID COST_SHARE_COST 
    COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;
  
  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE DIAB DIAB_BASEID DIAB_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;


