
* PROGRAM: FINISH_MRX.SAS;
* DESCRIPTION: FINISH THE MRX EXTRACT CREATION;

OPTIONS MSGLEVEL=I;

LIBNAME FORM "&FORMULARY";

%MACRO TIERCNT();
  %IF &INPUT^=INPUTCMS %THEN %DO;
    PROC SORT DATA=FORM.FORMULARY (KEEP=FORMULARY_ID TIER_LEVEL_VALUE) OUT=FORMSORT NODUPKEY;
    BY FORMULARY_ID TIER_LEVEL_VALUE;
    RUN;
  %END;
  %ELSE %IF &INPUT=INPUTCMS %THEN %DO;
    PROC SORT DATA=FORM.FORMULARYTIERS (KEEP=FORMULARY_ID TIER_LEVEL RENAME=TIER_LEVEL=TIER_LEVEL_VALUE) OUT=FORMSORT NODUPKEY;
    BY FORMULARY_ID TIER_LEVEL_VALUE;
    RUN;
  %END;
%MEND;

%TIERCNT();

DATA FORMROLL (KEEP=FORMULARY_ID T1-T10 TCNT);
  SET FORMSORT;
  BY FORMULARY_ID TIER_LEVEL_VALUE;
  RETAIN T1-T10 TCNT;
  ARRAY T(10) T1-T10;
  IF FIRST.FORMULARY_ID THEN DO;
    TCNT=0;
    DO I=1 TO 10;
      T(I)=.;
    END;
  END;
  TCNT+1;
  T(TCNT)=TIER_LEVEL_VALUE;
  IF LAST.FORMULARY_ID THEN OUTPUT;
RUN;

DATA MRX_TEMP_FORM;
  MERGE MRX_FILE(IN=A) FORMROLL (IN=B);
  BY FORMULARY_ID;
  IF A;
  FORMFLAG=B;
RUN;

DATA MRX_TEMP3;
  SET MRX_TEMP_FORM;
  IF PLAN_COINS=. & PLAN_COINS_T^=. THEN PLAN_COINS=PLAN_COINS_T;
  IF PLAN_COPAY=. & PLAN_COPAY_T^=. THEN PLAN_COPAY=PLAN_COPAY_T;
  IF PLAN_COINS_GAP=. & PLAN_COINS_GAP_T^=. THEN PLAN_COINS_GAP=PLAN_COINS_GAP_T;
  IF PLAN_COPAY_GAP=. & PLAN_COPAY_GAP_T^=. THEN PLAN_COPAY_GAP=PLAN_COPAY_GAP_T;
  ARRAY T(10) T1-T10;
  IF FORMFLAG=1 & MRX_TIER_ID=' ' & MRX_BENEFIT_TYPE IN ('2','3','4') THEN DO;
    DO I=1 TO TCNT;
      MRX_TIER_ID=LEFT(PUT(T(I),2.));
      OUTPUT;
    END;
  END;
  ELSE OUTPUT;
RUN;

DATA MRX_EXTRACT;
  SET MRX_TEMP3 (DROP= PLAN_COINS_T PLAN_COPAY_T PLAN_COINS_GAP_T PLAN_COPAY_GAP_T
    TIERFLAG PLANFORMFLAG FORMFLAG TCNT T1-T10 I CONTRACT_ID PLAN_ID);
  if mrx_alt_ded_type_yn ='2' then do;                             
    if mrx_alt_ded_tier_cstshr_yn = '1' then do;                            
      mrx_alt_gen_cstshr_struct = SUBSTR(mrx_tier_cstshr_struct_type,1,1);                            
      PLAN_COINS_PRE = PLAN_COINS;                            
      PLAN_COPAY_PRE = PLAN_COPAY;                            
    end;                             
  end;
  LENGTH PLAN_COINS PLAN_COINS_CAT PLAN_COINS_CAT_BRAND PLAN_COINS_CAT_GEN PLAN_COINS_GAP PLAN_COINS_PRE
         PLAN_COPAY PLAN_COPAY_CAT PLAN_COPAY_CAT_BRAND PLAN_COPAY_CAT_GEN PLAN_COPAY_GAP PLAN_COPAY_PRE
         PLAN_DEDUCTIBLE PLAN_ICL PLAN_THRESHOLD 5;
RUN;
