
* PROGRAM: COST_SHARING_ASC.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR ASC CLAIMS;


%MACRO ASC_COST_SHARE(SERV_CAT);

  PROC SUMMARY DATA=&INC NWAY MISSING;
    WHERE CATEGORY IN('9a1');
    CLASS BASEID YEAR;
    VAR AMTTOT;
    OUTPUT OUT=CAT_SUMMARY (DROP=_TYPE_ _FREQ_) SUM=;
  RUN;
  
  %obsnvars(CAT_SUMMARY);
  
  DATA FMTDATA;
    SET CAT_SUMMARY END=LAST;
    LENGTH HLO $1 START $12;
    FMTNAME='$CATFMT';
    START=BASEID || YEAR;
    LABEL=AMTTOT;
    HLO=' ';
    OUTPUT;
    IF LAST THEN DO;
      START='OTHER';
      LABEL=0;
      HLO='O';
      OUTPUT;
    END;
    KEEP FMTNAME START LABEL HLO;
  RUN;
    
  PROC FORMAT CNTLIN=FMTDATA;
  RUN;

  DATA ASC_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY='9b'));
  RUN;
 
  DATA ASC_FILE;
    SET  PBP_FILE (KEEP =
              CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
              PBP_B9B_DED_AMT PBP_B9B_MAXENR_AMT
              PBP_B9B_MAXENR_PER PBP_B9B_COINS_PCT_MC 
              PBP_B9B_COPAY_MC_AMT PBP_B9B_MAXENR_TYPE 
              PBP_B9A_MAXENR_OHS_AMT PBP_B9A_MAXENR_OHS_PER
              PBP_A_PLAN_TYPE PBP_D_DIFF_DEDUCT_9B_AMT);
    JOIN_ID = '1';
    %ANNUALIZATION(PBP_B9B_MAXENR_PER,PBP_B9B_MAXENR_AMT);
    %ANNUALIZATION(PBP_B9A_MAXENR_OHS_PER,PBP_B9A_MAXENR_OHS_AMT);
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.YEAR, P.*
      FROM ASC_BASEID B, ASC_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
     ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
       QUIT;
     RUN;
     
     DATA CAT_JOIN;
     MERGE CAT_JOIN (IN = A) 
           PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='9b'));
     BY HPLAN BASEID YEAR CATEGORY;
     IF A;
     LENGTH PLAN_DED_CAT $1;
     IF B THEN PLAN_DED_CAT='1';
     ELSE PLAN_DED_CAT='0';
  RUN;

  DATA &SERV_CAT;
    SET CAT_JOIN (DROP = JOIN_ID);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;
    
    IF PLAN_DED_CAT='1' THEN DO;
      IF PLAN_DED_AMTTOT_MC_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC_PTB;
      ELSE CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC;
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN 
      CAT_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_9B_AMT;
    ELSE CAT_DEDUCTIBLE=PBP_B9B_DED_AMT;
    
    BASEIDYR=BASEID || YEAR;
    IF PBP_B9B_MAXENR_AMT = . AND PBP_B9B_MAXENR_TYPE = '1' THEN DO;
      %IF "&NOBS." > "0" %THEN %DO;
        AMTTOTE=INPUT(PUT(BASEIDYR,$CATFMT.),8.);
      %END;
      %ELSE %DO;
        AMTTOTE=0;
      %END;
      PBPCAT_TOT=SUM(AMTTOTE,AMTTOT);
      IF PBPCAT_TOT>0 THEN 
        MAXENR_AMT=PBP_B9A_MAXENR_OHS_AMT*(AMTTOT/PBPCAT_TOT);
    END;
    ELSE DO;
      MAXENR_AMT=PBP_B9B_MAXENR_AMT;
    END;
    
    IF MAXENR_AMT NE . THEN BENE_MAXIMUM=MAXENR_AMT;

    IF CAT_DEDUCTIBLE = . THEN DO;
      COST = SUM(COST,(VISITS*PBP_B9B_COPAY_MC_AMT));
      COST = SUM(COST,(AMTTOT*PBP_B9B_COINS_PCT_MC));
    END;
    ELSE DO;
      IF AMTTOT <= CAT_DEDUCTIBLE THEN DO;
        COST = AMTTOT;
      END;
      ELSE DO;
        COST = CAT_DEDUCTIBLE;
        DEDUCT_SHARE = CAT_DEDUCTIBLE / AMTTOT;
        AMTTOT = SUM(AMTTOT,-CAT_DEDUCTIBLE);
        VISITS = VISITS * (1 - DEDUCT_SHARE);
        COST = SUM(COST,(VISITS*PBP_B9B_COPAY_MC_AMT));
        COST = SUM(COST,(AMTTOT*PBP_B9B_COINS_PCT_MC));
      END;
    END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN 
      COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "9b";
  RUN;

  PROC APPEND DATA=ASC(KEEP=HPLAN YEAR BASEID COST_SHARE_COST 
    COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE ASC ASC_BASEID ASC_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;



