
* PROGRAM: COST_SHARING_DENTAL.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR DENTAL CLAIMS;

DATA DENTAL_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='16'));
SRVCNT = 0;
SRVCNT = SUM(DVEXTRAC,DVRTCNAL,DVCROWN,DVBRIDGE,DVOTHER,DVORTHO,DVCLEAN,DVEXAM,DVXRAYS,DVFILLNG);
RUN;

data DENTAL_FILE;
    SET  PBP_FILE (KEEP =
        CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
        PBP_B16A_MAXENR_AMT PBP_B16A_MAXENR_PER
        PBP_B16B_MAXENR_AMT PBP_B16B_MAXENR_PER
        PBP_B16A_BENDESC_AMO_PC PBP_B16A_BENDESC_AMO_DX PBP_B16A_BENDESC_AMO_OE
        PBP_B16B_MAXBENE_TYPE PBP_B16B_BENDESC_AMO_EPE PBP_B16B_BENDESC_AMO_RS
        PBP_B16B_BENDESC_AMO_POO
        PBP_B16A_COPAY_AMT_PCMIN
        PBP_B16A_COPAY_AMT_DXMIN
        PBP_B16A_COPAY_AMT_OEMIN
        PBP_B16B_COPAY_AMT_EPEMIN
        PBP_B16B_COPAY_AMT_RSMIN
        PBP_B16B_COPAY_AMT_POOMIN
        PBP_B16A_COINS_PCT_PC PBP_B16A_DED_AMT PBP_B16B_DED_AMT
        PBP_B16A_COINS_PCT_DX
        PBP_B16A_COINS_PCT_OE
        PBP_B16B_COINS_PCT_EPE
        PBP_B16B_COINS_PCT_RS
        PBP_B16B_COINS_PCT_POO
        PBP_B16A_COPAY_OV_AMT
        PBP_B16A_COINS_PCT_OV
        PBP_B16A_COINS_CSERV_SC_POV
        PBP_B16A_COPAY_CSERV_SC_POV
        PBP_B16A_MAXPLAN_AMT
        PBP_B16A_MAXPLAN_PER
        PBP_B16B_MAXPLAN_AMT
        PBP_B16B_MAXPLAN_PER
        PBP_B16B_MAXBENE_TYPE
        PBP_B16B_MAXENR_TYPE

        PBP_B16A_BENDESC_NUMV_OE
        PBP_B16A_BENDESC_NUMV_PC
        PBP_B16A_BENDESC_NUMV_DX
        PBP_B16B_BENDESC_NUMV_RS
        PBP_B16B_BENDESC_NUMV_EPE
        PBP_B16B_BENDESC_NUMV_POO
        PBP_B16A_BENDESC_PER_OE
        PBP_B16A_BENDESC_PER_PC
        PBP_B16A_BENDESC_PER_DX
        PBP_B16B_BENDESC_PER_RS
        PBP_B16B_BENDESC_PER_EPE
        PBP_B16B_BENDESC_PER_POO);
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.year, b.amttot, b.dvclean, b.dvexam, b.dvxrays, b.dvfillng,
       b.dvextrac, b.dvrtcnal, b.dvcrown, b.dvbridge, b.dvother, b.dvortho, b.srvcnt, p.*
      from DENTAL_BASEID b, DENTAL_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO DENTAL_COST_SHARE(SERV_CAT);

%LET SERV_CAT = DENTAL;
  DATA &SERV_CAT;
 ARRAY MX PBP_B16A_BENDESC_NUMV_OE PBP_B16A_BENDESC_NUMV_PC PBP_B16A_BENDESC_NUMV_DX
          PBP_B16B_BENDESC_NUMV_RS PBP_B16B_BENDESC_NUMV_EPE PBP_B16B_BENDESC_NUMV_POO
          PBP_B16A_MAXENR_AMT PBP_B16B_MAXENR_AMT PBP_B16A_MAXPLAN_AMT PBP_B16B_MAXPLAN_AMT;
 ARRAY SX SERVICE_MAX_OE SERVICE_MAX_PC SERVICE_MAX_DX
          SERVICE_MAX_RS SERVICE_MAX_EPE SERVICE_MAX_POO
          BENE_MAXIMUM_P BENE_MAXIMUM_C PLAN_MAXIMUM_P PLAN_MAXIMUM_C;
    set cat_join (drop = join_id);

 DO I = 1 TO 10;
  IF MX(I) NE . THEN DO;
    SX(I) = MX(I);
  END;
 END;

  PREV_AM = '000';
  IF PBP_B16A_BENDESC_AMO_PC IN ('1','2') THEN SUBSTR(PREV_AM,1,1) = '1';
  IF PBP_B16A_BENDESC_AMO_DX IN ('1','2') THEN SUBSTR(PREV_AM,2,1) = '1';
  IF PBP_B16A_BENDESC_AMO_OE IN ('1','2') THEN SUBSTR(PREV_AM,3,1) = '1';

  COMP_AM = '000';
  IF PBP_B16B_BENDESC_AMO_EPE IN ('1','2') THEN SUBSTR(COMP_AM,1,1) = '1';
  IF PBP_B16B_BENDESC_AMO_RS IN ('1','2') THEN SUBSTR(COMP_AM,2,1) = '1';
  IF PBP_B16B_BENDESC_AMO_POO IN ('1','2') THEN SUBSTR(COMP_AM,3,1) = '1';

  OV_SVCS_COINS = '000';
  IF SUBSTR(PBP_B16A_COINS_CSERV_SC_POV,3,1) = '1' THEN SUBSTR(OV_SVCS_COINS,1,1) = '1';
  IF SUBSTR(PBP_B16A_COINS_CSERV_SC_POV,1,1) = '1' THEN SUBSTR(OV_SVCS_COINS,2,1) = '1';
  IF SUBSTR(PBP_B16A_COINS_CSERV_SC_POV,2,1) = '1' THEN SUBSTR(OV_SVCS_COINS,3,1) = '1';

  OV_SVCS_COPAY = '000';
  IF SUBSTR(PBP_B16A_COPAY_CSERV_SC_POV,3,1) = '1' THEN SUBSTR(OV_SVCS_COPAY,1,1) = '1';
  IF SUBSTR(PBP_B16A_COPAY_CSERV_SC_POV,1,1) = '1' THEN SUBSTR(OV_SVCS_COPAY,2,1) = '1';
  IF SUBSTR(PBP_B16A_COPAY_CSERV_SC_POV,2,1) = '1' THEN SUBSTR(OV_SVCS_COPAY,3,1) = '1';

    PER_SERVICE_AMT = AMTTOT / SRVCNT;

    NONCOV_COST = 0;

    PREV_SERVICE_CNT = SUM(DVCLEAN,DVEXAM,DVXRAYS);
    COMP_SERVICE_CNT = SUM(DVFILLNG, DVEXTRAC, DVRTCNAL, DVCROWN, DVBRIDGE, DVOTHER, DVORTHO);

    AMTTOT_PREV = PREV_SERVICE_CNT * PER_SERVICE_AMT;
    AMTTOT_COMP = COMP_SERVICE_CNT * PER_SERVICE_AMT;

    ARRAY DC DVEXTRAC DVRTCNAL DVCROWN DVBRIDGE DVOTHER DVORTHO DVFILLNG;
    ARRAY DP DVCLEAN DVEXAM DVXRAYS;

    IF AMTTOT_PREV <= PBP_B16A_DED_AMT THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,AMTTOT_PREV);
      DO OVER DP;
        DP = 0;
      END;
    END;
    ELSE IF PBP_B16A_DED_AMT > 0 THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,PBP_B16A_DED_AMT);
      DED_SHARE = PBP_B16A_DED_AMT / AMTTOT_PREV;
      AMTTOT_PREV = SUM(AMTTOT_PREV,-PBP_B16A_DED_AMT);
      DO OVER DP;
        DP = DP * (1 - DED_SHARE);
      END;
    END;

    IF AMTTOT_COMP <= PBP_B16B_DED_AMT THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,AMTTOT_COMP);
      DO OVER DC;
        DC = 0;
      END;
    END;
    ELSE IF PBP_B16B_DED_AMT > 0 THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,PBP_B16B_DED_AMT);
      DED_SHARE = PBP_B16B_DED_AMT / AMTTOT_COMP;
      AMTTOT_COMP = SUM(AMTTOT_COMP,-PBP_B16B_DED_AMT);
      DO OVER DC;
        DC = DC * (1 - DED_SHARE);
      END;
    END;


    * APPLY SERVICE COUNT MAX FIRST;
     IF SERVICE_MAX_OE > 0 AND SERVICE_MAX_OE < DVEXAM THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(DVEXAM,-SERVICE_MAX_OE) * PER_SERVICE_AMT);
        DVEXAM = SERVICE_MAX_OE;
     END;
     IF SERVICE_MAX_PC > 0 AND SERVICE_MAX_PC < DVCLEAN THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(DVCLEAN,-SERVICE_MAX_PC) * PER_SERVICE_AMT);
        DVCLEAN = SERVICE_MAX_PC;
     END;
     IF SERVICE_MAX_DX > 0 AND SERVICE_MAX_DX < DVXRAYS THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(DVXRAYS,-SERVICE_MAX_DX) * PER_SERVICE_AMT);
        DVXRAYS = SERVICE_MAX_DX;
     END;
     IF SERVICE_MAX_RS > 0 AND SERVICE_MAX_RS < DVFILLNG THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(DVFILLNG,-SERVICE_MAX_RS) * PER_SERVICE_AMT);
        DVFILLNG = SERVICE_MAX_RS;
     END;
     IF SERVICE_MAX_EPE > 0 AND SERVICE_MAX_EPE < SUM(DVEXTRAC,DVRTCNAL) THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(DVEXTRAC,DVRTCNAL,-SERVICE_MAX_EPE) * PER_SERVICE_AMT);
        DVEXTRAC = SERVICE_MAX_EPE * (DVEXTRAC/SUM(DVEXTRAC,DVRTCNAL));
        DVRTCNAL = SERVICE_MAX_EPE * (DVRTCNAL/SUM(DVEXTRAC,DVRTCNAL));
     END;
     IF SERVICE_MAX_POO > 0 AND SERVICE_MAX_POO < SUM(DVCROWN,DVBRIDGE,DVOTHER,DVORTHO) THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(DVCROWN,DVBRIDGE,DVOTHER,DVORTHO,-SERVICE_MAX_POO) * PER_SERVICE_AMT);
        DVCROWN = SERVICE_MAX_POO * (DVCROWN/SUM(DVCROWN,DVBRIDGE,DVOTHER,DVORTHO));
        DVBRIDGE = SERVICE_MAX_POO * (DVBRIDGE/SUM(DVCROWN,DVBRIDGE,DVOTHER,DVORTHO));
        DVOTHER = SERVICE_MAX_POO * (DVOTHER/SUM(DVCROWN,DVBRIDGE,DVOTHER,DVORTHO));
        DVORTHO = SERVICE_MAX_POO * (DVORTHO/SUM(DVCROWN,DVBRIDGE,DVOTHER,DVORTHO));
     END;

    PREV_SERVICE_CNT = SUM(DVCLEAN,DVEXAM,DVXRAYS);
    COMP_SERVICE_CNT = SUM(DVFILLNG, DVEXTRAC, DVRTCNAL, DVCROWN, DVBRIDGE, DVOTHER, DVORTHO);

    AMTTOT_PREV = PREV_SERVICE_CNT * PER_SERVICE_AMT;
    AMTTOT_COMP = COMP_SERVICE_CNT * PER_SERVICE_AMT;


    NONCOV_COST_MAXDOL = 0;
    NONCOV_COST_MAXDOL_P = 0;
    NONCOV_COST_MAXDOL_C = 0;

    * APPLY PLAN MAXIMUM;
    IF PBP_B16B_MAXBENE_TYPE = '1' THEN DO;
      NONCOV_COST_MAXDOL = SUM(NONCOV_COST_MAXDOL,MAX(0,SUM(AMTTOT_PREV,AMTTOT_COMP,-PLAN_MAXIMUM_P)));

      IF SUM(AMTTOT_PREV,AMTTOT_COMP) > 0 THEN
        COVERED_SHARE = SUM(AMTTOT_PREV,AMTTOT_COMP,-NONCOV_COST_MAXDOL) / SUM(AMTTOT_PREV,AMTTOT_COMP);

      COVERED_SHARE_P = COVERED_SHARE;

      COVERED_SHARE_C = COVERED_SHARE;

      DO OVER DP;
        DP = DP * COVERED_SHARE_P;
      END;
      DO OVER DC;
        DC = DC * COVERED_SHARE_C;
      END;
    END;
    ELSE DO;
      IF PLAN_MAXIMUM_P > 0 THEN NONCOV_COST_MAXDOL_P = MAX(0,SUM(AMTTOT_PREV,-PLAN_MAXIMUM_P));
      IF PLAN_MAXIMUM_C > 0 THEN NONCOV_COST_MAXDOL_C = MAX(0,SUM(AMTTOT_COMP,-PLAN_MAXIMUM_C));

      NONCOV_COST_MAXDOL = SUM(NONCOV_COST_MAXDOL_P,NONCOV_COST_MAXDOL_C);

      IF AMTTOT_PREV > 0 THEN
          COVERED_SHARE_P = SUM(AMTTOT_PREV,-NONCOV_COST_MAXDOL_P) / AMTTOT_PREV;
      IF AMTTOT_COMP > 0 THEN
          COVERED_SHARE_C = SUM(AMTTOT_COMP,-NONCOV_COST_MAXDOL_C) / AMTTOT_COMP;

      DO OVER DP;
        DP = DP * COVERED_SHARE_P;
      END;
      DO OVER DC;
        DC = DC * COVERED_SHARE_C;
      END;
    END;

    *APPLY INDIVIDUAL COSTS FOR PREV BENEFITS;

    IF DVCLEAN > 0 THEN DO;
      IF SUBSTR(PREV_AM,1,1) = '1' THEN DO;
        IF SUBSTR(OV_SVCS_COPAY,1,1) = '0' THEN PC_COST_SHARE = PBP_B16A_COPAY_AMT_PCMIN * DVCLEAN;
        IF SUBSTR(OV_SVCS_COINS,1,1) = '0' THEN
           PC_COST_SHARE = SUM(PC_COST_SHARE,(PER_SERVICE_AMT * DVCLEAN * PBP_B16A_COINS_PCT_PC));
      END;
      ELSE DO;
        PC_OTHER_COST = PER_SERVICE_AMT * DVCLEAN;
      END;
    END;

    IF DVXRAYS > 0 THEN DO;
      IF SUBSTR(PREV_AM,2,1) = '1' THEN DO;
        IF SUBSTR(OV_SVCS_COPAY,2,1) = '0' THEN DX_COST_SHARE = PBP_B16A_COPAY_AMT_DXMIN * DVXRAYS;
        IF SUBSTR(OV_SVCS_COINS,2,1) = '0' THEN
          DX_COST_SHARE = SUM(DX_COST_SHARE,(PER_SERVICE_AMT * DVXRAYS * PBP_B16A_COINS_PCT_DX));
      END;
      ELSE DO;
        DX_OTHER_COST = PER_SERVICE_AMT * DVXRAYS;
      END;
    END;

    IF DVEXAM > 0 THEN DO;
      IF SUBSTR(PREV_AM,3,1) = '1' THEN DO;
        IF SUBSTR(OV_SVCS_COPAY,3,1) = '0' THEN OE_COST_SHARE = PBP_B16A_COPAY_AMT_OEMIN * DVEXAM;
        IF SUBSTR(OV_SVCS_COINS,3,1) = '0' THEN
           OE_COST_SHARE = SUM(OE_COST_SHARE,(PER_SERVICE_AMT * DVEXAM * PBP_B16A_COINS_PCT_OE));
      END;
      ELSE DO;
        OE_OTHER_COST = PER_SERVICE_AMT * DVEXAM;
      END;
    END;

    *APPLY OFFICE VISIT COSTS FOR PREV BENEFITS;

    IF SUBSTR(PREV_AM,1,1) = '1' AND SUBSTR(OV_SVCS_COPAY,1,1) = '1' THEN
       OV_COST_SHARE = PBP_B16A_COPAY_OV_AMT * DVCLEAN;
    ELSE IF SUBSTR(PREV_AM,3,1) = '1' AND SUBSTR(OV_SVCS_COPAY,3,1) = 1 THEN
       OV_COST_SHARE = PBP_B16A_COPAY_OV_AMT * DVEXAM;
    ELSE IF SUBSTR(PREV_AM,2,1) = '1' AND SUBSTR(OV_SVCS_COPAY,2,1) = 1 THEN
       OV_COST_SHARE = PBP_B16A_COPAY_OV_AMT * DVXRAYS;

    IF SUBSTR(PREV_AM,1,1) = '1' AND SUBSTR(OV_SVCS_COINS,1,1) = '1' THEN
      OV_COST_SHARE = SUM(OV_COST_SHARE,PER_SERVICE_AMT * DVCLEAN * PBP_B16A_COINS_PCT_OV);
    ELSE IF SUBSTR(PREV_AM,3,1) = '1' AND SUBSTR(OV_SVCS_COINS,3,1) = '1' THEN
      OV_COST_SHARE = SUM(OV_COST_SHARE,PER_SERVICE_AMT * DVEXAM * PBP_B16A_COINS_PCT_OV);
    ELSE IF SUBSTR(PREV_AM,2,1) = '1' AND SUBSTR(OV_SVCS_COINS,2,1) = '1' THEN
      OV_COST_SHARE = SUM(OV_COST_SHARE,PER_SERVICE_AMT * DVXRAYS * PBP_B16A_COINS_PCT_OV);

    *APPLY INDIVIDUAL COSTS FOR COMP BENEFITS;

    IF DVEXTRAC > 0 THEN DO;
      IF PBP_B16B_BENDESC_AMO_EPE IN ('1','2') THEN DO;
        ENDO_COST_SHARE = SUM(PBP_B16B_COPAY_AMT_EPEMIN*DVEXTRAC,(PER_SERVICE_AMT*DVEXTRAC*PBP_B16B_COINS_PCT_EPE));
      END;
      ELSE DO;
        ENDO_OTHER_COST = PER_SERVICE_AMT * DVEXTRAC;
      END;
    END;

    IF DVRTCNAL > 0 THEN DO;
      IF PBP_B16B_BENDESC_AMO_EPE IN ('1','2') THEN DO;
        ENDO_COST_SHARE = SUM(ENDO_COST_SHARE,SUM(PBP_B16B_COPAY_AMT_EPEMIN * DVRTCNAL,
                       (PER_SERVICE_AMT * DVRTCNAL * PBP_B16B_COINS_PCT_EPE)));
      END;
      ELSE DO;
        ENDO_OTHER_COST = SUM(ENDO_OTHER_COST,PER_SERVICE_AMT * DVRTCNAL);
      END;
    END;

    IF DVFILLNG > 0 THEN DO;
      IF PBP_B16B_BENDESC_AMO_RS IN ('1','2') THEN DO;
        FILL_COST_SHARE = SUM(PBP_B16B_COPAY_AMT_RSMIN*DVFILLNG,(PER_SERVICE_AMT*DVFILLNG*PBP_B16B_COINS_PCT_RS));
      END;
      ELSE DO;
        FILL_OTHER_COST = PER_SERVICE_AMT * DVFILLNG;
      END;
    END;

    IF DVCROWN > 0 THEN DO;
      IF PBP_B16B_BENDESC_AMO_POO IN ('1','2') THEN DO;
        PROS_COST_SHARE = SUM(PBP_B16B_COPAY_AMT_POOMIN*DVCROWN,(PER_SERVICE_AMT*DVCROWN*PBP_B16B_COINS_PCT_POO));
      END;
      ELSE DO;
        PROS_OTHER_COST = PER_SERVICE_AMT * DVCROWN;
      END;
    END;

    IF DVBRIDGE > 0 THEN DO;
      IF PBP_B16B_BENDESC_AMO_POO IN ('1','2') THEN DO;
        PROS_COST_SHARE = SUM(PROS_COST_SHARE,SUM(PBP_B16B_COPAY_AMT_POOMIN * DVBRIDGE,
                        (PER_SERVICE_AMT * DVBRIDGE * PBP_B16B_COINS_PCT_POO)));
      END;
      ELSE DO;
        PROS_OTHER_COST = SUM(PROS_OTHER_COST,PER_SERVICE_AMT * DVBRIDGE);
      END;
    END;

    IF DVOTHER > 0 THEN DO;
      IF PBP_B16B_BENDESC_AMO_POO IN ('1','2') THEN DO;
        PROS_COST_SHARE =
         SUM(PROS_COST_SHARE,SUM(PBP_B16B_COPAY_AMT_POOMIN*DVOTHER,(PER_SERVICE_AMT*DVOTHER*PBP_B16B_COINS_PCT_POO)));
      END;
      ELSE DO;
        PROS_OTHER_COST = SUM(PROS_OTHER_COST,PER_SERVICE_AMT * DVOTHER);
      END;
    END;

    IF DVORTHO > 0 THEN DO;
      IF PBP_B16B_BENDESC_AMO_POO IN ('1','2') THEN DO;
        PROS_COST_SHARE =
           SUM(PROS_COST_SHARE,SUM(PBP_B16B_COPAY_AMT_POOMIN*DVORTHO,(PER_SERVICE_AMT*DVORTHO*PBP_B16B_COINS_PCT_POO)));
      END;
      ELSE DO;
        PROS_OTHER_COST = SUM(PROS_OTHER_COST,PER_SERVICE_AMT * DVORTHO);
      END;
    END;

    COST_SHARE_COST_P = SUM(PC_COST_SHARE,DX_COST_SHARE,OE_COST_SHARE,OV_COST_SHARE);
    COST_SHARE_COST_C = SUM(ENDO_COST_SHARE,FILL_COST_SHARE,PROS_COST_SHARE);

    IF PBP_B16B_MAXENR_TYPE = '1' THEN
       COST_SHARE_COST = MIN(BENE_MAXIMUM_P,SUM(COST_SHARE_COST_P,COST_SHARE_COST_C));
    ELSE DO;
      IF BENE_MAXIMUM_P >= 0 AND COST_SHARE_COST_P >= 0 THEN COST_SHARE_COST_P = MIN(COST_SHARE_COST_P,BENE_MAXIMUM_P);
      IF BENE_MAXIMUM_C >= 0 AND COST_SHARE_COST_C >= 0 THEN COST_SHARE_COST_C = MIN(COST_SHARE_COST_C,BENE_MAXIMUM_C);
      COST_SHARE_COST = SUM(COST_SHARE_COST_P,COST_SHARE_COST_C);
    END;

    OTHER_COST = SUM(PC_OTHER_COST, DX_OTHER_COST, OE_OTHER_COST,
       ENDO_OTHER_COST, FILL_OTHER_COST, PROS_OTHER_COST, NONCOV_COST, NONCOV_COST_MAXDOL);

    COST_SHARE_COST_MC  = 0;
    COST_SHARE_COST_AMO = COST_SHARE_COST;

    CATEGORY = "16";


  RUN;

%MEND DENTAL_COST_SHARE;

%MACRO RUN_COST;
%LET CAT = DENTAL;
RUN;

%DENTAL_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC SORT DATA = DENTAL;
  BY HPLAN;
RUN;

PROC SUMMARY DATA = DENTAL NWAY MISSING;
  CLASS YEAR BASEID;
  BY HPLAN;
  VAR COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO OTHER_COST AMTTOT;
  ID CATEGORY;
  OUTPUT OUT = TOTDENTAL(RENAME = _FREQ_=RCCNT) SUM = ;
RUN;

DATA TOTDENTAL;
RETAIN COST 0;
SET TOTDENTAL;
RUN;

PROC APPEND DATA=TOTDENTAL(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE DENTAL TOTDENTAL DENTAL_BASEID DENTAL_FILE CAT_JOIN;
QUIT;
RUN;
