
* PROGRAM: COST_SHARING_ORTHOTICS.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR ORTHOTICS CLAIMS;

DATA ORTHOTICS_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(SOURCE='orthotics'));
RUN;

data ORTHOTICS_FILE;
    SET  PBP_FILE (KEEP = CONTRACT_ID PLAN_ID SEGMENT_ID  HPLAN
                   PBP_B11B_DED_AMT PBP_B11B_MAXENR_AMT
                   PBP_B11B_MAXENR_PER PBP_B11B_COINS_PCT_MC PBP_B11B_COPAY_MCMIN_AMT
                   PBP_B11B_MAXENR_COST_TYPE PBP_B11A_MAXENR_AMT PBP_B11A_MAXENR_PER);
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from ORTHOTICS_BASEID b, ORTHOTICS_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO ORTHOTICS_COST_SHARE(SERV_CAT);

%LET SERV_CAT = ORTHOTICS;
  DATA &SERV_CAT;
    set cat_join (drop = join_id);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF PBP_B11B_MAXENR_AMT = . AND PBP_B11B_MAXENR_COST_TYPE = '1' THEN DO;
      MAXENR_AMT = PBP_B11A_MAXENR_AMT;
      MAXENR_PER = PBP_B11A_MAXENR_PER;
    END;
    ELSE DO;
      MAXENR_AMT = PBP_B11B_MAXENR_AMT;
      MAXENR_PER = PBP_B11B_MAXENR_PER;
    END;

    IF MAXENR_AMT NE . THEN BENE_MAXIMUM = MAXENR_AMT;

      IF PBP_B11B_DED_AMT = . THEN DO;
        COST = SUM(COST,(VISITS*PBP_B11B_COPAY_MCMIN_AMT));
        COST = SUM(COST,AMTTOT*PBP_B11B_COINS_PCT_MC);
      END;
      ELSE DO;
        IF AMTTOT <= PBP_B11B_DED_AMT THEN DO;
          COST = AMTTOT;
        END;
        ELSE DO;
          COST = PBP_B11B_DED_AMT;
          DEDUCT_SHARE = PBP_B11B_DED_AMT / AMTTOT;
          AMTTOT = SUM(AMTTOT,-PBP_B11B_DED_AMT);
          VISITS = VISITS * (1 - DEDUCT_SHARE);
          COST = SUM(COST,(VISITS*PBP_B11B_COPAY_MCMIN_AMT));
          COST = SUM(COST,AMTTOT*PBP_B11B_COINS_PCT_MC);
        END;
      END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "11b";
  RUN;

%MEND ORTHOTICS_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=ORTHOTICS;
RUN;

%ORTHOTICS_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE ORTHOTICS_BASEID ORTHOTICS_FILE CAT_JOIN;
QUIT;
RUN;
