
* PROGRAM: COST_SHARING_OTHER.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR OTHER CLAIMS;

DATA OTHER_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='7g'));
RUN;

data OTHER_FILE;
    SET  PBP_FILE(KEEP=
       CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
       PBP_B7G_DED_AMT PBP_B7G_MAXENR_AMT
       PBP_B7G_MAXENR_PER PBP_B7G_COINS_PCT_MC PBP_B7G_COPAY_MC_AMT);
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from OTHER_BASEID b, OTHER_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO OTHER_COST_SHARE(SERV_CAT);

%LET SERV_CAT = OTHER;
  DATA &SERV_CAT;
    set cat_join (drop = join_id);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF PBP_B7G_MAXENR_AMT NE . THEN BENE_MAXIMUM = PBP_B7G_MAXENR_AMT;


      IF PBP_B7G_DED_AMT = . THEN DO;
        COST = SUM(COST,(VISITS*PBP_B7G_COPAY_MC_AMT));
        COST = SUM(COST,AMTTOT*PBP_B7G_COINS_PCT_MC);
      END;
      ELSE DO;
        IF AMTTOT <= PBP_B7G_DED_AMT THEN DO;
          COST = AMTTOT;
        END;
        ELSE DO;
         COST = PBP_B7G_DED_AMT;
          DEDUCT_SHARE = PBP_B7G_DED_AMT / AMTTOT;
          AMTTOT = SUM(AMTTOT,-PBP_B7G_DED_AMT);
          VISITS = VISITS * (1 - DEDUCT_SHARE);
          COST = SUM(COST,(VISITS*PBP_B7G_COPAY_MC_AMT));
          COST = SUM(COST,AMTTOT*PBP_B7G_COINS_PCT_MC);
        END;
      END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "7g";
  RUN;

%MEND OTHER_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=OTHER;
RUN;

%OTHER_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC APPEND DATA=OTHER(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE OTHER OTHER_BASEID OTHER_FILE CAT_JOIN;
QUIT;
RUN;
