
* PROGRAM: PBP_IMPORT.SAS;
* DESCRIPTION: IMPORT THE INDIVIDUAL PBP TABLES AND MERGE TOGETHER;

*FROM MAIN CALLING PROGRAM;

LIBNAME LIBRARY "&INPUTDIR";

%MACRO PLANS;
%IF "&PLANFILE" NE "" %THEN %DO;
*READ THE PLANFILE;
DATA PLANFILE;
INFILE "&PLANFILE";
INPUT @1 HPLAN $CHAR11.;
RUN;

PROC PRINT DATA=PLANFILE;
TITLE 'PLANFILE';
RUN;
%END;
%ELSE %DO;
DATA PLANFILE;
STOP;
RUN;
%END;
%MEND;
RUN;

%PLANS;
RUN;

DATA _NULL_;
CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
STOP;
SET PLANFILE NOBS=NUMOBS;
STOP;
RUN;

%MACRO FMT;
%IF &NUM > 0 %THEN %DO;
DATA HPLAN_FMT (KEEP=START LABEL HLO FMTNAME);
  SET PLANFILE (RENAME=HPLAN=START) END=LAST;
  LENGTH FMTNAME $8 LABEL $3 HLO $1;
  FMTNAME='$HPLANF';
  LABEL='YES';
  HLO=' ';
  OUTPUT;
  IF LAST THEN DO;
    START='OTHER';
    LABEL='NO';
    HLO='O';
    OUTPUT;
  END;
RUN;
%END;
%ELSE %DO;
DATA HPLAN_FMT (KEEP=START LABEL HLO FMTNAME);
  LENGTH FMTNAME $8 LABEL $3 HLO $1;
  FMTNAME='$HPLANF';
  START='OTHER';
  LABEL='YES';
  HLO='O';
  OUTPUT;
RUN;
%END;
RUN;
%MEND;
RUN;

%FMT;
RUN;

PROC FORMAT CNTLIN=HPLAN_FMT LIB=LIBRARY;
RUN;


PROC IMPORT OUT= WORK.PBPPLANS
            DATATABLE= "PBPPLANS"
            DBMS=ACCESS REPLACE;
     DATABASE="&PBP\PBPPLANS&RUNYEAR..MDB";
     SCANMEMO=YES;
     USEDATE=NO;
     SCANTIME=YES;
RUN;

DATA PBPPLANS MAPD MAON PDP MSA;
LENGTH SEGMENT_ID_N 3 QID $12;
LENGTH TYPE $4;
KEEP QID PBP_A_CONTRACT_NUMBER
PBP_A_PLAN_IDENTIFIER
PBP_A_SEGMENT_ID
PBP_A_PLAN_TYPE
PBP_A_ORG_TYPE
PBP_A_PLAN_NAME
PBP_A_ORG_NAME
PBP_A_SPECIAL_NEED_FLAG
PBP_A_SPECIAL_NEED_PLAN_TYPE
PBP_A_SNP_PCT
PBP_A_SNP_POP
MRX_DRUG_BEN_YN
SEGMENT_ID_N TYPE;
SET PBPPLANS;
SEGMENT_ID_N = INPUT(PBP_A_SEGMENT_ID,3.);
QID = LEFT(PBP_A_CONTRACT_NUMBER||PBP_A_PLAN_IDENTIFIER||PUT(SEGMENT_ID_N,Z3.));
* SUBSET FOR THE PLANFILE PLANS;
IF PUT(QID,$HPLANF.) = 'YES';
IF PBP_A_PLAN_TYPE IN('29','30','32') THEN TYPE = 'PDP';
ELSE TYPE = 'MAPD';
IF TYPE = 'MAPD' THEN DO;
   IF MRX_DRUG_BEN_YN = '2' THEN TYPE = 'MAON';
END;
IF PBP_A_ORG_TYPE='02' AND
      PBP_A_PLAN_TYPE='07' THEN TYPE = 'MSA';
IF TYPE = 'PDP' THEN OUTPUT PDP;
ELSE IF TYPE = 'MAPD' THEN OUTPUT MAPD;
ELSE IF TYPE = 'MAON' THEN OUTPUT MAON;
*ELSE IF TYPE = 'MSA' THEN OUTPUT MSA;
OUTPUT PBPPLANS;
RUN;

%GLOBAL MAON PDP MAPD MSA;
RUN;

DATA _NULL_;
CALL SYMPUT('MAON',TRIM(LEFT(PUT(NUMOBS,4.))));
PUT NUMOBS=;
STOP;
SET MAON NOBS=NUMOBS;
STOP;
RUN;

DATA _NULL_;
CALL SYMPUT('PDP',TRIM(LEFT(PUT(NUMOBS,4.))));
PUT NUMOBS=;
STOP;
SET PDP NOBS=NUMOBS;
STOP;
RUN;

DATA _NULL_;
CALL SYMPUT('MAPD',TRIM(LEFT(PUT(NUMOBS,4.))));
PUT NUMOBS=;
STOP;
SET MAPD NOBS=NUMOBS;
STOP;
RUN;

DATA _NULL_;
CALL SYMPUT('MSA',TRIM(LEFT(PUT(NUMOBS,4.))));
PUT NUMOBS=;
STOP;
SET MSA NOBS=NUMOBS;
STOP;
RUN;


%PUT _USER_;

DATA _NULL_;
CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
STOP;
SET PBPPLANS NOBS=NUMOBS;
STOP;
RUN;

%MACRO FMT;
%IF &NUM > 0 %THEN %DO;
DATA PLAN_FMT (KEEP=START LABEL HLO FMTNAME);
  SET PBPPLANS (RENAME=QID=START) END=LAST;
  LENGTH FMTNAME $8 LABEL $4 HLO $1;
  FMTNAME='$TYPEF';
  LABEL=TYPE;
  HLO=' ';
  OUTPUT;
  IF LAST THEN DO;
    START='OTHER';
    LABEL='NO';
    HLO='O';
    OUTPUT;
  END;
RUN;
%END;
%ELSE %DO;
DATA PLAN_FMT (KEEP=START LABEL HLO FMTNAME);
  LENGTH FMTNAME $8 LABEL $4 HLO $1;
  FMTNAME='$TYPEF';
  START='OTHER';
  LABEL='NO';
  HLO='O';
  OUTPUT;
RUN;
%END;
RUN;
%MEND;
RUN;

%FMT;
RUN;

PROC FORMAT CNTLIN=PLAN_FMT LIB=LIBRARY;
RUN;

DATA CONTPLAN;
LENGTH START $8;
RETAIN FMTNAME '$CONTPLNF';
SET PLAN_FMT(RENAME=START=HPLAN DROP=FMTNAME);
START = SUBSTR(HPLAN,1,8);
RUN;

proc sort data = contplan nodupkey;
by start;
run;

PROC FORMAT CNTLIN=CONTPLAN LIB=LIBRARY;
RUN;

PROC SORT DATA=PBPPLANS;
BY QID;
RUN;

*RUN THE IMPORTS AND CONVERSION TO NUMERIC FOR THE PBP TABLES;

PROC IMPORT OUT= WORK.PBP
DATATABLE= "PBP "
            DBMS=ACCESS REPLACE;
     DATABASE="&PBP\PBP&RUNYEAR..MDB";
     SCANMEMO=YES;
     USEDATE=NO;
     SCANTIME=YES;
RUN;

PROC SORT DATA= PBP ;
BY QID;
RUN;

%INCLUDE IN0(CONVERT);
RUN;

%PBPIMPCONV(PBPB1);
RUN;

%PBPIMPCONV(PBPB1_B);
RUN;

%PBPIMPCONV(PBPB10);
RUN;

%PBPIMPCONV(PBPB11);
RUN;

%PBPIMPCONV(PBPB12);
RUN;

%PBPIMPCONV(PBPB13);
RUN;

%PBPIMPCONV(PBPB14);
RUN;

%PBPIMPCONV(PBPB15);
RUN;

%PBPIMPCONV(PBPB16);
RUN;

%PBPIMPCONV(PBPB17);
RUN;

%PBPIMPCONV(PBPB18);
RUN;

%PBPIMPCONV(PBPB2);
RUN;

%PBPIMPCONV(PBPB2_B);
RUN;

%PBPIMPCONV(PBPB20);
RUN;

DATA _NULL_;
CALL SYMPUT('B20OBS',TRIM(LEFT(PUT(NUMOBS,4.))));
STOP;
SET PBPB20 NOBS=NUMOBS;
STOP;
RUN;

%PBPIMPCONV(PBPB3);
RUN;

%PBPIMPCONV(PBPB4);
RUN;

%PBPIMPCONV(PBPB5);
RUN;

%PBPIMPCONV(PBPB6);
RUN;

%PBPIMPCONV(PBPB7);
RUN;

%PBPIMPCONV(PBPB8);
RUN;

%PBPIMPCONV(PBPB9);
RUN;

%PBPIMPCONV(PBPD);
RUN;

%MACRO BUILDFILE;
DATA PBP_FILE(RENAME=QID=HPLAN);
KEEP QID CONTRACT_ID PLAN_ID SEGMENT_ID SEGMENT_ID_N PBP_A_PLAN_TYPE PBP_A_ORG_TYPE
PBP_A_PLAN_NAME PBP_A_ORG_NAME PBP_A_SPECIAL_NEED_FLAG PBP_A_SPECIAL_NEED_PLAN_TYPE PBP_A_SNP_PCT
PBP_A_SNP_POP MRX_DRUG_BEN_YN PBP_A_ORG_MARKETING_NAME;
%INCLUDE IN0(PBPKEEP);
MERGE PBPPLANS(IN=INPLAN
    RENAME=(PBP_A_CONTRACT_NUMBER=CONTRACT_ID PBP_A_PLAN_IDENTIFIER=PLAN_ID PBP_A_SEGMENT_ID=SEGMENT_ID))
PBP(DROP=PBP_A_CONTRACT_NUMBER PBP_A_PLAN_IDENTIFIER PBP_A_SEGMENT_ID PBP_A_PLAN_NAME PBP_A_PLAN_TYPE
    PBP_A_ORG_TYPE PBP_A_ORG_NAME PBP_A_SPECIAL_NEED_FLAG PBP_A_SPECIAL_NEED_PLAN_TYPE PBP_A_SNP_PCT
    PBP_A_SNP_POP)
PBPB1
PBPB1_B PBPB10 PBPB11 PBPB12
PBPB13 PBPB14 PBPB15 PBPB16
PBPB17 PBPB18 PBPB2 PBPB2_B
PBPB3 PBPB4 PBPB5 PBPB6 PBPB7
PBPB8 PBPB9 PBPD PBPB20;
BY QID;
IF INPLAN;
  ARRAY DIV100
      PBP_B1A_COINS_AD_PCT_INTRVL1 - PBP_B1A_COINS_AD_PCT_INTRVL3
      PBP_B1A_COINS_MCS_PCT
      PBP_B1A_COINS_MCS_PCT_INTRVL1 - PBP_B1A_COINS_MCS_PCT_INTRVL3
      PBP_B1A_COINS_NMCS_PCT
      PBP_B1A_COINS_NMCS_PCT_INTRVL1 - PBP_B1A_COINS_NMCS_PCT_INTRVL3
      PBP_B1B_COINS_AD_PCT_INTRVL1 - PBP_B1B_COINS_AD_PCT_INTRVL3
      PBP_B1B_COINS_MCS_PCT_INTRVL1 - PBP_B1B_COINS_MCS_PCT_INTRVL3
      PBP_B1B_COINS_NMCS_PCT_INTRVL1 - PBP_B1B_COINS_NMCS_PCT_INTRVL3
      PBP_B1B_COINS_PCT_MCS
      PBP_B1B_COINS_PCT_NMCS
      PBP_B2_COINS_AD_PCT_INTRVL1 - PBP_B2_COINS_AD_PCT_INTRVL3
      PBP_B2_COINS_MCS_PCT
      PBP_B2_COINS_MCS_PCT_INTRVL1 - PBP_B2_COINS_MCS_PCT_INTRVL3
      PBP_B2_COINS_NMCS_PCT
      PBP_B2_COINS_NMCS_PCT_INTRVL1 - PBP_B2_COINS_NMCS_PCT_INTRVL3
      PBP_B3_COINS_PCT_MC_MIN_PRS
      PBP_B3_COINS_PCT_MC_MIN_ICRS
      PBP_B3_COINS_PCT_MC_MIN_CRS
      PBP_B4A_COINS_PCT_MC_MIN
      PBP_B4B_COINS_PCT_MC_MIN
      PBP_B6_COINS_PCT_MC_MIN
      PBP_B7A_COINS_PCT_MC_MIN
      PBP_B7A_IA_NUC_COINS_PCT_MAX
      PBP_B7A_IA_NUC_COINS_PCT_MIN
      PBP_B7B_COINS_PCT_MC_MIN
      PBP_B7C_COINS_PCT_MC
      PBP_B7D_COINS_PCT_MC_MIN
      PBP_B7E_COINS_MCIS_MINPCT
      PBP_B7E_COINS_MCGS_MINPCT

      PBP_B7F_COINS_PCT_MC_MIN
      PBP_B7G_COINS_PCT_MC
      PBP_B7H_COINS_MCIS_MINPCT
      PBP_B7H_COINS_MCGS_MINPCT
      PBP_B7I_COINS_PCT_MC

      PBP_B8A_COINS_PCT_DMC
      PBP_B8A_COINS_PCT_DMC_MAX
      PBP_B8A_COINS_PCT_LAB
      PBP_B8A_COINS_PCT_LAB_MAX
      PBP_B8A_COST_SHARE_COINS_MIN
      PBP_B8B_COINS_PCT_CMC
      PBP_B8B_COINS_PCT_DRS
      PBP_B8B_COINS_PCT_TMC

      PBP_B9A_COINS_PCT_MC
      PBP_B9B_COINS_PCT_MC

      PBP_B10A_COINS_PCT_MC

      PBP_B11A_COINS_PCT_MC
      PBP_B11B_COINS_PCT_MC
      PBP_B11B_COINS_PCT_MCMS_MIN

      PBP_B12_COINS_PCT_MC

      PBP_B16A_COINS_PCT_DX
      PBP_B16A_COINS_PCT_OE
      PBP_B16A_COINS_PCT_OV
      PBP_B16A_COINS_PCT_PC

      PBP_B16B_COINS_PCT_EPE
      PBP_B16B_COINS_PCT_POO
      PBP_B16B_COINS_PCT_RS
      PBP_B16B_COINS_PCT_MC

      PBP_B17A_COINS_MCMIN_PCT
      PBP_B18A_MED_COINS_PCT
      MRX_B_CHEMO_COINS_PCT
      MRX_B_COINS_PCT
      %IF &B20OBS > 0 %THEN %DO;
      PBP_B20_COINS_MC_PCT
      PBP_B20_B_COINS_MIN_PCT
      %END;
      ;

   IF PBP_A_PLAN_TYPE='18' THEN DO;
     IF PBP_B20_COPAY_MIN_MC_AMT NE . THEN MRX_B_COPAY_MIN_AMT   = PBP_B20_COPAY_MIN_MC_AMT;
     ELSE MRX_B_COPAY_MIN_AMT=.;
     IF PBP_B20_COINS_MC_PCT     NE . THEN MRX_B_CHEMO_COINS_PCT = PBP_B20_COINS_MC_PCT;
     ELSE MRX_B_COINS_PCT=.;
     IF PBP_B20_B_MIN_COPAY      NE . THEN MRX_B_COPAY_MIN_AMT   = PBP_B20_B_MIN_COPAY;
     ELSE MRX_B_COPAY_MIN_AMT=.;
     IF PBP_B20_B_COINS_MIN_PCT  NE . THEN MRX_B_COINS_PCT       = PBP_B20_B_COINS_MIN_PCT;
     ELSE MRX_B_COINS_PCT=.;
    END;

  DO OVER DIV100;
    IF DIV100 NE . THEN
    DIV100 = DIV100 / 100.0;
  END;
*PRE-PROCESS THE DST DATA FOR PLANS THAT HAVE COPAY OR COINS AND CHARGE THE MEDICARE-DEFINED AMOUNTS;
*ASSUME IF CHARGE BOTH COINS AND COPAY, THEN EQUIVALENT TO THE MEDICARE-DEFINED COPAYS;

IF (PBP_B1A_COINS_YN='1' AND PBP_B1A_MDCR_COINS_CSTSHRS_YN='1') OR
   (PBP_B1A_COPAY_YN='1' AND PBP_B1A_MDCR_COPAY_CSTSHRS_YN='1') THEN DO;
     PBP_B1A_DED_AMT                  =  1132;
     PBP_B1A_COPAY_MCS_BGND_INTRVL1   =   0  ;
     PBP_B1A_COPAY_MCS_BGND_INTRVL2   =   61 ;
     PBP_B1A_COPAY_MCS_BGND_INTRVL3   =   91 ;
     PBP_B1A_COPAY_MCS_ENDD_INTRVL1   =   60 ;
     PBP_B1A_COPAY_MCS_ENDD_INTRVL2   =   90 ;
     PBP_B1A_COPAY_MCS_ENDD_INTRVL3   =   150;
     PBP_B1A_COPAY_MCS_AMT_INTRVL1    =     0;
     PBP_B1A_COPAY_MCS_AMT_INTRVL2    =   283;
     PBP_B1A_COPAY_MCS_AMT_INTRVL3    =   566;
   END;

  * CONVERT MAXIMUM TO ANNUAL;
    IF PBP_B1A_MAXENR_AMT NE . THEN DO;
      IF PBP_B1A_MAXENR_PER = '1' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B1A_MAXENR_PER = '2' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B1A_MAXENR_PER = '3' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B1A_MAXENR_PER = '4' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B1A_MAXENR_PER = '5' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B1A_MAXENR_PER = '6' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT * 4; * EVERY BENEFIT PERIOD;
      ELSE IF PBP_B1A_MAXENR_PER = '7' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT; * EVERY STAY;
      ELSE IF PBP_B1A_MAXENR_PER = '8' THEN PBP_B1A_MAXENR_AMT = PBP_B1A_MAXENR_AMT; * OTHER;
    END;

*PRE-PROCESS THE DST DATA FOR PLANS THAT HAVE COPAY OR COINS AND CHARGE THE MEDICARE-DEFINED AMOUNTS;
*ASSUME IF CHARGE BOTH COINS AND COPAY, THEN EQUIVALENT TO THE MEDICARE-DEFINED COPAYS;

IF (PBP_B1B_COINS_YN='1' AND PBP_B1B_MDCR_COINS_CSTSHRS_YN='1') OR
   (PBP_B1B_COPAY_YN='1' AND PBP_B1B_MDCR_COPAY_CSTSHRS_YN='1') THEN
   DO;
     PBP_B1B_DED_AMT                  =  1132;
     PBP_B1B_COPAY_MCS_BGND_INTRVL1   =   0  ;
     PBP_B1B_COPAY_MCS_BGND_INTRVL2   =   61 ;
     PBP_B1B_COPAY_MCS_BGND_INTRVL3   =   91 ;
     PBP_B1B_COPAY_MCS_ENDD_INTRVL1   =   60 ;
     PBP_B1B_COPAY_MCS_ENDD_INTRVL2   =   90 ;
     PBP_B1B_COPAY_MCS_ENDD_INTRVL3   =   150;
     PBP_B1B_COPAY_MCS_AMT_INTRVL1    =     0;
     PBP_B1B_COPAY_MCS_AMT_INTRVL2    =   283;
     PBP_B1B_COPAY_MCS_AMT_INTRVL3    =   566;
   END;

    IF PBP_B1B_MAXENR_AMT NE . THEN DO;
      IF PBP_B1B_MAXENR_PER = '1' THEN PBP_B1B_MAXENR_AMT = PBP_B1B_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B1B_MAXENR_PER = '2' THEN PBP_B1B_MAXENR_AMT = PBP_B1B_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B1B_MAXENR_PER = '3' THEN PBP_B1B_MAXENR_AMT = PBP_B1B_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B1B_MAXENR_PER = '4' THEN PBP_B1B_MAXENR_AMT = PBP_B1B_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B1B_MAXENR_PER = '5' THEN PBP_B1B_MAXENR_AMT = PBP_B1B_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B1B_MAXENR_PER = '6' THEN PBP_B1B_MAXENR_AMT = PBP_B1B_MAXENR_AMT * 4; * EVERY BENEFIT PERIOD;
      ELSE IF PBP_B1B_MAXENR_PER = '7' THEN PBP_B1B_MAXENR_AMT = PBP_B1B_MAXENR_AMT; * EVERY STAY;
      ELSE IF PBP_B1B_MAXENR_PER = '8' THEN PBP_B1B_MAXENR_AMT = PBP_B1B_MAXENR_AMT; * OTHER;
    END;

  **** DEFINE THE MEDICARE DEFINED AMOUNTS ***;
  IF PBP_B2_BENDESC_YN='2' AND
     ( PBP_B2_MDCR_COINS_CSTSHRS_YN='1' OR PBP_B2_MDCR_COPAY_CSTSHRS_YN='1' )
     THEN DO;
       PBP_B2_COPAY_MCS_AMT_INTRVL1=0;
       PBP_B2_COPAY_MCS_AMT_INTRVL2=141.5;
       PBP_B2_COPAY_MCS_BGND_INTRVL1 = 1;
       PBP_B2_COPAY_MCS_BGND_INTRVL2 = 21;
       PBP_B2_COPAY_MCS_BGND_INTRVL3 = .;
       PBP_B2_COPAY_MCS_ENDD_INTRVL1 = 20;
       PBP_B2_COPAY_MCS_ENDD_INTRVL2 = 100;
       PBP_B2_COPAY_MCS_ENDD_INTRVL3 = .;
     END;

    IF PBP_B2_MAXENR_AMT NE . THEN DO;
      IF PBP_B2_MAXENR_PER = '1' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B2_MAXENR_PER = '2' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B2_MAXENR_PER = '3' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B2_MAXENR_PER = '4' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B2_MAXENR_PER = '5' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B2_MAXENR_PER = '6' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT; * EVERY STAY;
      ELSE IF PBP_B2_MAXENR_PER = '7' THEN PBP_B2_MAXENR_AMT = PBP_B2_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B3_MAXENR_AMT NE . THEN DO;
      IF PBP_B3_MAXENR_PER = '1' THEN PBP_B3_MAXENR_AMT = PBP_B3_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B3_MAXENR_PER = '2' THEN PBP_B3_MAXENR_AMT = PBP_B3_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B3_MAXENR_PER = '3' THEN PBP_B3_MAXENR_AMT = PBP_B3_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B3_MAXENR_PER = '4' THEN PBP_B3_MAXENR_AMT = PBP_B3_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B3_MAXENR_PER = '5' THEN PBP_B3_MAXENR_AMT = PBP_B3_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B3_MAXENR_PER = '6' THEN PBP_B3_MAXENR_AMT = PBP_B3_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B4A_MAXENR_AMT NE . THEN DO;
      IF PBP_B4A_MAXENR_PER = '1' THEN PBP_B4A_MAXENR_AMT = PBP_B4A_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B4A_MAXENR_PER = '2' THEN PBP_B4A_MAXENR_AMT = PBP_B4A_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B4A_MAXENR_PER = '3' THEN PBP_B4A_MAXENR_AMT = PBP_B4A_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B4A_MAXENR_PER = '4' THEN PBP_B4A_MAXENR_AMT = PBP_B4A_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B4A_MAXENR_PER = '5' THEN PBP_B4A_MAXENR_AMT = PBP_B4A_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B4A_MAXENR_PER = '6' THEN PBP_B4A_MAXENR_AMT = PBP_B4A_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B4B_MAXENR_AMT NE . THEN DO;
      IF PBP_B4B_MAXENR_PER = '1' THEN PBP_B4B_MAXENR_AMT = PBP_B4B_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B4B_MAXENR_PER = '2' THEN PBP_B4B_MAXENR_AMT = PBP_B4B_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B4B_MAXENR_PER = '3' THEN PBP_B4B_MAXENR_AMT = PBP_B4B_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B4B_MAXENR_PER = '4' THEN PBP_B4B_MAXENR_AMT = PBP_B4B_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B4B_MAXENR_PER = '5' THEN PBP_B4B_MAXENR_AMT = PBP_B4B_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B4B_MAXENR_PER = '6' THEN PBP_B4B_MAXENR_AMT = PBP_B4B_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B6_MAXENR_AMT NE . THEN DO;
      IF PBP_B6_MAXENR_PER = '1' THEN PBP_B6_MAXENR_AMT = PBP_B6_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B6_MAXENR_PER = '2' THEN PBP_B6_MAXENR_AMT = PBP_B6_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B6_MAXENR_PER = '3' THEN PBP_B6_MAXENR_AMT = PBP_B6_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B6_MAXENR_PER = '4' THEN PBP_B6_MAXENR_AMT = PBP_B6_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B6_MAXENR_PER = '5' THEN PBP_B6_MAXENR_AMT = PBP_B6_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B6_MAXENR_PER = '6' THEN PBP_B6_MAXENR_AMT = PBP_B6_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B7A_MAXENR_AMT NE . THEN DO;
      IF PBP_B7A_MAXENR_PER = '1' THEN PBP_B7A_MAXENR_AMT = PBP_B7A_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B7A_MAXENR_PER = '2' THEN PBP_B7A_MAXENR_AMT = PBP_B7A_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B7A_MAXENR_PER = '3' THEN PBP_B7A_MAXENR_AMT = PBP_B7A_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B7A_MAXENR_PER = '4' THEN PBP_B7A_MAXENR_AMT = PBP_B7A_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B7A_MAXENR_PER = '5' THEN PBP_B7A_MAXENR_AMT = PBP_B7A_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B7A_MAXENR_PER = '6' THEN PBP_B7A_MAXENR_AMT = PBP_B7A_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B7B_MAXENR_AMT NE . THEN DO;
      IF PBP_B7B_MAXENR_PER = '1' THEN PBP_B7B_MAXENR_AMT = PBP_B7B_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B7B_MAXENR_PER = '2' THEN PBP_B7B_MAXENR_AMT = PBP_B7B_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B7B_MAXENR_PER = '3' THEN PBP_B7B_MAXENR_AMT = PBP_B7B_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B7B_MAXENR_PER = '4' THEN PBP_B7B_MAXENR_AMT = PBP_B7B_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B7B_MAXENR_PER = '5' THEN PBP_B7B_MAXENR_AMT = PBP_B7B_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B7B_MAXENR_PER = '6' THEN PBP_B7B_MAXENR_AMT = PBP_B7B_MAXENR_AMT; * OTHER;
    END;

      IF PBP_B7C_MAXENR_AMT NE . THEN DO;
        IF PBP_B7C_MAXENR_PER = '1' THEN PBP_B7C_MAXENR_AMT = PBP_B7C_MAXENR_AMT / 3; * EVERY THREE YEARS;
        ELSE IF PBP_B7C_MAXENR_PER = '2' THEN PBP_B7C_MAXENR_AMT = PBP_B7C_MAXENR_AMT / 2; * EVERY TWO YEARS;
        ELSE IF PBP_B7C_MAXENR_PER = '3' THEN PBP_B7C_MAXENR_AMT = PBP_B7C_MAXENR_AMT / 1; * EVERY YEAR;
        ELSE IF PBP_B7C_MAXENR_PER = '4' THEN PBP_B7C_MAXENR_AMT = PBP_B7C_MAXENR_AMT * 2; * EVERY SIX MONTHS;
        ELSE IF PBP_B7C_MAXENR_PER = '5' THEN PBP_B7C_MAXENR_AMT = PBP_B7C_MAXENR_AMT * 4; * EVERY THREE MONTHS;
        ELSE IF PBP_B7C_MAXENR_PER = '6' THEN PBP_B7C_MAXENR_AMT = PBP_B7C_MAXENR_AMT; * OTHER;
      END;

    IF PBP_B7D_MAXENR_AMT NE . THEN DO;
      IF PBP_B7D_MAXENR_PER = '1' THEN PBP_B7D_MAXENR_AMT = PBP_B7D_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B7D_MAXENR_PER = '2' THEN PBP_B7D_MAXENR_AMT = PBP_B7D_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B7D_MAXENR_PER = '3' THEN PBP_B7D_MAXENR_AMT = PBP_B7D_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B7D_MAXENR_PER = '4' THEN PBP_B7D_MAXENR_AMT = PBP_B7D_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B7D_MAXENR_PER = '5' THEN PBP_B7D_MAXENR_AMT = PBP_B7D_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B7D_MAXENR_PER = '6' THEN PBP_B7D_MAXENR_AMT = PBP_B7D_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B7E_MAXENR_AMT NE . THEN DO;
      IF PBP_B7E_MAXENR_PER = '1' THEN PBP_B7E_MAXENR_AMT = PBP_B7E_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B7E_MAXENR_PER = '2' THEN PBP_B7E_MAXENR_AMT = PBP_B7E_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B7E_MAXENR_PER = '3' THEN PBP_B7E_MAXENR_AMT = PBP_B7E_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B7E_MAXENR_PER = '4' THEN PBP_B7E_MAXENR_AMT = PBP_B7E_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B7E_MAXENR_PER = '5' THEN PBP_B7E_MAXENR_AMT = PBP_B7E_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B7E_MAXENR_PER = '6' THEN PBP_B7E_MAXENR_AMT = PBP_B7E_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B7F_MAXENR_AMT NE . THEN DO;
      IF PBP_B7F_MAXENR_PER = '1' THEN PBP_B7F_MAXENR_AMT = PBP_B7F_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B7F_MAXENR_PER = '2' THEN PBP_B7F_MAXENR_AMT = PBP_B7F_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B7F_MAXENR_PER = '3' THEN PBP_B7F_MAXENR_AMT = PBP_B7F_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B7F_MAXENR_PER = '4' THEN PBP_B7F_MAXENR_AMT = PBP_B7F_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B7F_MAXENR_PER = '5' THEN PBP_B7F_MAXENR_AMT = PBP_B7F_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B7F_MAXENR_PER = '6' THEN PBP_B7F_MAXENR_AMT = PBP_B7F_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B7G_MAXENR_AMT NE . THEN DO;
      IF PBP_B7G_MAXENR_PER = '1' THEN PBP_B7G_MAXENR_AMT = PBP_B7G_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B7G_MAXENR_PER = '2' THEN PBP_B7G_MAXENR_AMT = PBP_B7G_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B7G_MAXENR_PER = '3' THEN PBP_B7G_MAXENR_AMT = PBP_B7G_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B7G_MAXENR_PER = '4' THEN PBP_B7G_MAXENR_AMT = PBP_B7G_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B7G_MAXENR_PER = '5' THEN PBP_B7G_MAXENR_AMT = PBP_B7G_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B7G_MAXENR_PER = '6' THEN PBP_B7G_MAXENR_AMT = PBP_B7G_MAXENR_AMT; * OTHER;
    END;


    IF PBP_B7H_MAXENR_AMT NE . THEN DO;
      IF PBP_B7H_MAXENR_PER = '1' THEN PBP_B7H_MAXENR_AMT = PBP_B7H_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B7H_MAXENR_PER = '2' THEN PBP_B7H_MAXENR_AMT = PBP_B7H_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B7H_MAXENR_PER = '3' THEN PBP_B7H_MAXENR_AMT = PBP_B7H_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B7H_MAXENR_PER = '4' THEN PBP_B7H_MAXENR_AMT = PBP_B7H_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B7H_MAXENR_PER = '5' THEN PBP_B7H_MAXENR_AMT = PBP_B7H_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B7H_MAXENR_PER = '6' THEN PBP_B7H_MAXENR_AMT = PBP_B7H_MAXENR_AMT; * OTHER;
    END;

      IF PBP_B7I_MAXENR_AMT NE . THEN DO;
        IF PBP_B7I_MAXENR_PER = '1' THEN PBP_B7I_MAXENR_AMT = PBP_B7I_MAXENR_AMT / 3; * EVERY THREE YEARS;
        ELSE IF PBP_B7I_MAXENR_PER = '2' THEN PBP_B7I_MAXENR_AMT = PBP_B7I_MAXENR_AMT / 2; * EVERY TWO YEARS;
        ELSE IF PBP_B7I_MAXENR_PER = '3' THEN PBP_B7I_MAXENR_AMT = PBP_B7I_MAXENR_AMT / 1; * EVERY YEAR;
        ELSE IF PBP_B7I_MAXENR_PER = '4' THEN PBP_B7I_MAXENR_AMT = PBP_B7I_MAXENR_AMT * 2; * EVERY SIX MONTHS;
        ELSE IF PBP_B7I_MAXENR_PER = '5' THEN PBP_B7I_MAXENR_AMT = PBP_B7I_MAXENR_AMT * 4; * EVERY THREE MONTHS;
        ELSE IF PBP_B7I_MAXENR_PER = '6' THEN PBP_B7I_MAXENR_AMT = PBP_B7I_MAXENR_AMT; * OTHER;
      END;

  IF PBP_B8A_MAXENR_AMT NE . THEN DO;
    IF PBP_B8A_MAXENR_PER = '1' THEN PBP_B8A_MAXENR_AMT = PBP_B8A_MAXENR_AMT / 3; * EVERY THREE YEARS;
    ELSE IF PBP_B8A_MAXENR_PER = '2' THEN PBP_B8A_MAXENR_AMT = PBP_B8A_MAXENR_AMT / 2; * EVERY TWO YEARS;
    ELSE IF PBP_B8A_MAXENR_PER = '3' THEN PBP_B8A_MAXENR_AMT = PBP_B8A_MAXENR_AMT / 1; * EVERY YEAR;
    ELSE IF PBP_B8A_MAXENR_PER = '4' THEN PBP_B8A_MAXENR_AMT = PBP_B8A_MAXENR_AMT * 2; * EVERY SIX MONTHS;
    ELSE IF PBP_B8A_MAXENR_PER = '5' THEN PBP_B8A_MAXENR_AMT = PBP_B8A_MAXENR_AMT * 4; * EVERY THREE MONTHS;
    ELSE IF PBP_B8A_MAXENR_PER = '6' THEN PBP_B8A_MAXENR_AMT = PBP_B8A_MAXENR_AMT; * OTHER;
  END;

  IF PBP_B8B_MAXENR_AMT NE . THEN DO;
     IF PBP_B8B_MAXENR_PER = '1' THEN PBP_B8B_MAXENR_AMT = PBP_B8B_MAXENR_AMT / 3; * EVERY THREE YEARS;
     ELSE IF PBP_B8B_MAXENR_PER = '2' THEN PBP_B8B_MAXENR_AMT = PBP_B8B_MAXENR_AMT / 2; * EVERY TWO YEARS;
     ELSE IF PBP_B8B_MAXENR_PER = '3' THEN PBP_B8B_MAXENR_AMT = PBP_B8B_MAXENR_AMT / 1; * EVERY YEAR;
     ELSE IF PBP_B8B_MAXENR_PER = '4' THEN PBP_B8B_MAXENR_AMT = PBP_B8B_MAXENR_AMT * 2; * EVERY SIX MONTHS;
     ELSE IF PBP_B8B_MAXENR_PER = '5' THEN PBP_B8B_MAXENR_AMT = PBP_B8B_MAXENR_AMT * 4; * EVERY THREE MONTHS;
     ELSE IF PBP_B8B_MAXENR_PER = '6' THEN PBP_B8B_MAXENR_AMT = PBP_B8B_MAXENR_AMT; * OTHER;
  END;

    IF PBP_B9A_MAXENR_AMT NE . THEN DO;
      IF PBP_B9A_MAXENR_PER = '1' THEN PBP_B9A_MAXENR_AMT = PBP_B9A_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B9A_MAXENR_PER = '2' THEN PBP_B9A_MAXENR_AMT = PBP_B9A_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B9A_MAXENR_PER = '3' THEN PBP_B9A_MAXENR_AMT = PBP_B9A_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B9A_MAXENR_PER = '4' THEN PBP_B9A_MAXENR_AMT = PBP_B9A_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B9A_MAXENR_PER = '5' THEN PBP_B9A_MAXENR_AMT = PBP_B9A_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B9A_MAXENR_PER = '6' THEN PBP_B9A_MAXENR_AMT = PBP_B9A_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B9B_MAXENR_AMT NE . THEN DO;
      IF PBP_B9B_MAXENR_PER = '1' THEN PBP_B9B_MAXENR_AMT = PBP_B9B_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B9B_MAXENR_PER = '2' THEN PBP_B9B_MAXENR_AMT = PBP_B9B_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B9B_MAXENR_PER = '3' THEN PBP_B9B_MAXENR_AMT = PBP_B9B_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B9B_MAXENR_PER = '4' THEN PBP_B9B_MAXENR_AMT = PBP_B9B_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B9B_MAXENR_PER = '5' THEN PBP_B9B_MAXENR_AMT = PBP_B9B_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B9B_MAXENR_PER = '6' THEN PBP_B9B_MAXENR_AMT = PBP_B9B_MAXENR_AMT; * OTHER;
    END;

  IF PBP_B10A_MAXENR_AMT NE . THEN DO;
    IF PBP_B10A_MAXENR_PER = '1' THEN PBP_B10A_MAXENR_AMT = PBP_B10A_MAXENR_AMT / 3; * EVERY THREE YEARS;
    ELSE IF PBP_B10A_MAXENR_PER = '2' THEN PBP_B10A_MAXENR_AMT = PBP_B10A_MAXENR_AMT / 2; * EVERY TWO YEARS;
    ELSE IF PBP_B10A_MAXENR_PER = '3' THEN PBP_B10A_MAXENR_AMT = PBP_B10A_MAXENR_AMT / 1; * EVERY YEAR;
    ELSE IF PBP_B10A_MAXENR_PER = '4' THEN PBP_B10A_MAXENR_AMT = PBP_B10A_MAXENR_AMT * 2; * EVERY SIX MONTHS;
    ELSE IF PBP_B10A_MAXENR_PER = '5' THEN PBP_B10A_MAXENR_AMT = PBP_B10A_MAXENR_AMT * 4; * EVERY THREE MONTHS;
    ELSE IF PBP_B10A_MAXENR_PER = '6' THEN PBP_B10A_MAXENR_AMT = PBP_B10A_MAXENR_AMT; * OTHER;
  END;

    IF PBP_B11A_MAXENR_AMT NE . THEN DO;
      IF PBP_B11A_MAXENR_PER = '1' THEN PBP_B11A_MAXENR_AMT = PBP_B11A_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B11A_MAXENR_PER = '2' THEN PBP_B11A_MAXENR_AMT = PBP_B11A_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B11A_MAXENR_PER = '3' THEN PBP_B11A_MAXENR_AMT = PBP_B11A_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B11A_MAXENR_PER = '4' THEN PBP_B11A_MAXENR_AMT = PBP_B11A_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B11A_MAXENR_PER = '5' THEN PBP_B11A_MAXENR_AMT = PBP_B11A_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B11A_MAXENR_PER = '6' THEN PBP_B11A_MAXENR_AMT = PBP_B11A_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B11B_MAXENR_AMT NE . THEN DO;
      IF PBP_B11B_MAXENR_PER = '1' THEN PBP_B11B_MAXENR_AMT = PBP_B11B_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B11B_MAXENR_PER = '2' THEN PBP_B11B_MAXENR_AMT = PBP_B11B_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B11B_MAXENR_PER = '3' THEN PBP_B11B_MAXENR_AMT = PBP_B11B_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B11B_MAXENR_PER = '4' THEN PBP_B11B_MAXENR_AMT = PBP_B11B_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B11B_MAXENR_PER = '5' THEN PBP_B11B_MAXENR_AMT = PBP_B11B_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B11B_MAXENR_PER = '6' THEN PBP_B11B_MAXENR_AMT = PBP_B11B_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B12_MAXENR_AMT NE . THEN DO;
      IF PBP_B12_MAXENR_PER = '1' THEN PBP_B12_MAXENR_AMT = PBP_B12_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B12_MAXENR_PER = '2' THEN PBP_B12_MAXENR_AMT = PBP_B12_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B12_MAXENR_PER = '3' THEN PBP_B12_MAXENR_AMT = PBP_B12_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B12_MAXENR_PER = '4' THEN PBP_B12_MAXENR_AMT = PBP_B12_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B12_MAXENR_PER = '5' THEN PBP_B12_MAXENR_AMT = PBP_B12_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B12_MAXENR_PER = '6' THEN PBP_B12_MAXENR_AMT = PBP_B12_MAXENR_AMT; * OTHER;
    END;

 ARRAY MX PBP_B16A_BENDESC_NUMV_OE PBP_B16A_BENDESC_NUMV_PC PBP_B16A_BENDESC_NUMV_DX
          PBP_B16B_BENDESC_NUMV_RS PBP_B16B_BENDESC_NUMV_EPE PBP_B16B_BENDESC_NUMV_POO
          PBP_B16A_MAXENR_AMT PBP_B16B_MAXENR_AMT PBP_B16A_MAXPLAN_AMT PBP_B16B_MAXPLAN_AMT;
 ARRAY PX PBP_B16A_BENDESC_PER_OE PBP_B16A_BENDESC_PER_PC PBP_B16A_BENDESC_PER_DX
          PBP_B16B_BENDESC_PER_RS PBP_B16B_BENDESC_PER_EPE PBP_B16B_BENDESC_PER_POO
          PBP_B16A_MAXENR_PER PBP_B16B_MAXENR_PER PBP_B16A_MAXPLAN_PER PBP_B16B_MAXPLAN_PER;

 DO I = 1 TO 10;
  IF MX(I) NE . THEN DO;
    IF PX(I)  = '1' THEN MX(I) = MX(I)  / 3; * EVERY THREE YEARS;
    ELSE IF PX(I)  = '2' THEN MX(I) = MX(I)  / 2; * EVERY TWO YEARS;
    ELSE IF PX(I)  = '3' THEN MX(I) = MX(I) / 1; * EVERY YEAR;
    ELSE IF PX(I)  = '4' THEN MX(I) = MX(I)  * 2; * EVERY SIX MONTHS;
    ELSE IF PX(I)  = '5' THEN MX(I) = MX(I)  * 4; * EVERY THREE MONTHS;
    ELSE IF PX(I)  = '6' THEN MX(I) = MX(I) ; * OTHER;
  END;
 END;

    IF PBP_B17A_MAXENR_AMT NE . THEN DO;
      IF PBP_B17A_MAXENR_PER = '1' THEN PBP_B17A_MAXENR_AMT = PBP_B17A_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B17A_MAXENR_PER = '2' THEN PBP_B17A_MAXENR_AMT = PBP_B17A_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B17A_MAXENR_PER = '3' THEN PBP_B17A_MAXENR_AMT = PBP_B17A_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B17A_MAXENR_PER = '4' THEN PBP_B17A_MAXENR_AMT = PBP_B17A_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B17A_MAXENR_PER = '5' THEN PBP_B17A_MAXENR_AMT = PBP_B17A_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B17A_MAXENR_PER = '6' THEN PBP_B17A_MAXENR_AMT = PBP_B17A_MAXENR_AMT; * OTHER;
    END;

    IF PBP_B18A_MAXENR_AMT NE . THEN DO;
      IF PBP_B18A_MAXENR_PER = '1' THEN PBP_B18A_MAXENR_AMT = PBP_B18A_MAXENR_AMT / 3; * EVERY THREE YEARS;
      ELSE IF PBP_B18A_MAXENR_PER = '2' THEN PBP_B18A_MAXENR_AMT = PBP_B18A_MAXENR_AMT / 2; * EVERY TWO YEARS;
      ELSE IF PBP_B18A_MAXENR_PER = '3' THEN PBP_B18A_MAXENR_AMT = PBP_B18A_MAXENR_AMT / 1; * EVERY YEAR;
      ELSE IF PBP_B18A_MAXENR_PER = '4' THEN PBP_B18A_MAXENR_AMT = PBP_B18A_MAXENR_AMT * 2; * EVERY SIX MONTHS;
      ELSE IF PBP_B18A_MAXENR_PER = '5' THEN PBP_B18A_MAXENR_AMT = PBP_B18A_MAXENR_AMT * 4; * EVERY THREE MONTHS;
      ELSE IF PBP_B18A_MAXENR_PER = '6' THEN PBP_B18A_MAXENR_AMT = PBP_B18A_MAXENR_AMT; * OTHER;
    END;

   IF MRX_B_MAX_OOP_AMT ^ = . THEN DO;
      IF MRX_B_MAX_OOP_PER = '1' THEN MRX_B_MAX_OOP_AMT = MRX_B_MAX_OOP_AMT / 3;
      ELSE IF MRX_B_MAX_OOP_PER = '2' THEN MRX_B_MAX_OOP_AMT = MRX_B_MAX_OOP_AMT / 2;
      ELSE IF MRX_B_MAX_OOP_PER = '3' THEN MRX_B_MAX_OOP_AMT = MRX_B_MAX_OOP_AMT;
      ELSE IF MRX_B_MAX_OOP_PER = '4' THEN MRX_B_MAX_OOP_AMT = MRX_B_MAX_OOP_AMT * 2;
      ELSE IF MRX_B_MAX_OOP_PER = '5' THEN MRX_B_MAX_OOP_AMT = MRX_B_MAX_OOP_AMT * 4;
      ELSE IF MRX_B_MAX_OOP_PER = '6' THEN MRX_B_MAX_OOP_AMT = MRX_B_MAX_OOP_AMT * 12;
    END;
RUN;
%MEND;
RUN;

%BUILDFILE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE PBPPLANS PBP PBPB1
PBPB1_B PBPB10 PBPB11 PBPB12
PBPB13 PBPB14 PBPB14_2 PBPB15 PBPB16
PBPB17 PBPB18 PBPB2 PBPB2_B
PBPB3 PBPB4 PBPB5 PBPB6 PBPB7
PBPB8 PBPB9 PBPD PBPB20
NEWPBPB1 NEWPBPB1_B NEWPBPB10 NEWPBPB11 NEWPBPB12
NEWPBPB13 NEWPBPB14 NEWPBPB14_2 NEWPBPB15 NEWPBPB16
NEWPBPB17 NEWPBPB18 NEWPBPB2 NEWPBPB2_B
NEWPBPB3 NEWPBPB4 NEWPBPB5 NEWPBPB6 NEWPBPB7
NEWPBPB8 NEWPBPB9 NEWPBPD;
QUIT;
RUN;
