
* PLAN_CATNAME_NEW.SAS;
* DESCRIPTION: PERFORM FINAL CALCULATIONS AND CREATE FINAL SPREADSHEET;

LIBNAME LIBRARY "&INPUTDIR";

PROC FORMAT LIB=LIBRARY;
 VALUE $CATNAME
'1a'  = 'Inpatient_Hospital_Acute_Care'
'1b'  = 'Inpatient_Mental_Health_Care'
'2'   = 'Skilled_Nursing_Facility'
'4a'  ='Emergency_Care'
'4b'  ='Urgently_Needed_Care'
'6'   ='Home_Health_Agency'
'7a'  ='Primary_Care_Physician'
'7b'  ='Chiropractic_Services'
'7c'  ='Occupational_Therapy'
'7d'  ='Physician_Specialists'
'7e'  ='Outpatient_Mental_Health_Care'
'7f'  ='Podiatry_Services'
'7g'  ='Other_Health_Professionals'
'7h'  ='Psychiatric_Care'
'7i'  ='Physical_and_Speech_Therapy'
'8al' ='Outpatient_Lab'
'8ad' ='Diagnostic_Tests_and_Procedures'
'8br' ='Therapeutic_Radiation'
'8bx' ='Outpatient_X_Rays'
'8bd' ='Diagnostic_Radiological_Services'
'9a'  ='Outpatient_Hospital_Services'
'9b'  ='Ambulatory_Surgical_Center'
'9d'  ='Cardiac_Rehabilitation_Services'
'15c' ='Chemotherapy_Drugs'
'10a' ='Ambulance'
'11a' ='Durable_Medical_Equipment'
'11b' ='Prosthetic_Devices'
'12'  ='Renal_Dialysis'
'14d' ='Pap_Pelvic_Exams'
'14h' ='Screen_Mammography_Exams'
'15m' ='Medicare_Covered_Part_B_Drugs'
'16'  ='Preventative_Comp_Dental'
'16b' ='Medicare_Covered_Dental'
'17a' ='Eye_Exams'
'18a' ='Hearing_Exams'
'all' ='Total'
 ;;
 RUN;

%MACRO PLAN;

 DATA  BASEID_CATEGORY_ALLYEARS;
 SET

 %IF &PDP > 0 OR &MAPD > 0 OR &MSA > 0 %THEN %DO;
      BASEID_PLAN_CATEGORY_PARTD_&YEAR1(RENAME=CWGT=COMBO_WGT)
      BASEID_PLAN_CATEGORY_PARTD_&YEAR2(RENAME=CWGT=COMBO_WGT)
 %END;


 %IF &MAPD > 0 OR &MAON > 0 OR &MSA > 0 %THEN %DO;
      BASEID_PLAN_CATEGORY_COMP_&YEAR1(RENAME=CWGT=COMBO_WGT)
      BASEID_PLAN_CATEGORY_COMP_&YEAR2(RENAME=CWGT=COMBO_WGT)
 %END;
 ;
 BY CELL_GROUP HPLAN CATEGORY;
 RUN;

DATA CCOHORT;
  SET    &INP(KEEP=BASEID CSYRWGT YEAR);
  IF YEAR = "&YEAR1" THEN SOURCE = "&MCBSYR1";
  ELSE IF YEAR = "&YEAR2" THEN SOURCE = "&MCBSYR2";
     COMBO_WGT = CSYRWGT;
RUN;

PROC SUMMARY DATA = CCOHORT NWAY MISSING;
  VAR COMBO_WGT;
  OUTPUT OUT = COHORT_CELL_GROUP(DROP=_FREQ_ _TYPE_) SUM = COMBOWGT_SUM;
RUN;

PROC MEANS DATA =  BASEID_CATEGORY_ALLYEARS NOPRINT;
  CLASS HPLAN CATEGORY;
  WEIGHT COMBO_WGT;
  VAR MONTHLY_COST;
  OUTPUT OUT = PLAN MEAN = MONTHLY_COST_MEAN
                    SUM = MONTHLY_COST_SUM;
RUN;

DATA PLAN_COSTS;
  IF _N_ = 1 THEN SET COHORT_CELL_GROUP(KEEP = COMBOWGT_SUM);
  SET PLAN(IN = A);
  MONTHLY_COST_MEAN      = MONTHLY_COST_SUM / COMBOWGT_SUM;
  RUN;

PROC SORT DATA=PLAN_COSTS OUT= PLAN_COSTS;
BY HPLAN;
RUN;

DATA SECTION_A(RENAME=(PBP_A_ORG_TYPE=ORG_TYPE
                       PBP_A_PLAN_TYPE=PLAN_TYPE PBP_A_ORG_MARKETING_NAME=MARKETING_NAME
                       PBP_A_ORG_NAME=ORG_NAME PBP_A_Plan_Name=Plan_Name));
LENGTH TYPE $4;
  SET  PBP_FILE;
  TYPE = PUT(HPLAN,$TYPEF.);
  IF TYPE NE 'NO';
RUN;

DATA PLAN_COSTS_CAT(DROP=_TYPE_ _FREQ_  COMBOWGT_SUM);
LENGTH CATNAME $ 50;
SET  PLAN_COSTS(WHERE=(_TYPE_ ^=0 AND HPLAN ^=:' ' AND CATEGORY ^= '   '));
CATNAME = PUT(CATEGORY,$CATNAME.);
RUN;

* FOR NONMSA PLANS;
DATA PLAN_CATS(KEEP=HPLAN CATNAME CATEGORY MONTHLY_COST_MEAN);
 SET  PLAN_COSTS_CAT;
RUN;

PROC TRANSPOSE DATA=PLAN_CATS(DROP=CATEGORY) OUT=PARTC_PLANS(DROP=_NAME_);
VAR MONTHLY_COST_MEAN;
ID CATNAME;
BY HPLAN;
RUN;

DATA PARTC_PLANS;
SET PARTC_PLANS;
IF PUT(HPLAN,$TYPEF.) NE 'MSA';
RUN;

PROC SORT;
BY HPLAN;
RUN;

%IF &MSA > 0 %THEN %DO;
DATA PLAN_CATS_MSA(KEEP=HPLAN CATNAME CATEGORY MONTHLY_COST_MEAN);
LENGTH CATNAME $ 50;
SET  PLAN_CATEGORY_PREMIUMMSA;
CATNAME = PUT(CATEGORY,$CATNAME.);
RUN;

PROC TRANSPOSE DATA=PLAN_CATS_MSA(DROP=CATEGORY) OUT=PARTC_PLANS_MSA(DROP=_NAME_);
VAR MONTHLY_COST_MEAN;
ID CATNAME;
BY HPLAN;
RUN;

PROC SORT;
BY HPLAN;
RUN;
%END;

DATA PARTC_PLANS_ALL;
SET
    %IF &MAPD > 0 OR &MAON > 0 %THEN %DO;
    PARTC_PLANS
    %END;
    %IF &MSA > 0 %THEN %DO;
    PARTC_PLANS_MSA
    %END;
;
BY HPLAN;
RUN;

PROC SORT DATA=PARTC_PLANS_ALL;
BY HPLAN;
RUN;
DATA PARTC_PLANS
%IF &MAPD > 0 OR &PDP > 0 %THEN %DO;
(DROP=_15)
%END;
;
%IF &MAON = 0 AND &MAPD = 0 AND &PDP > 0 %THEN %DO;
RETAIN
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Cardiac_Rehabilitation_Services
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams .;

%END;
 SET PARTC_PLANS_ALL;
%IF &MAON = 0 AND &MAPD = 0 AND &PDP > 0 %THEN %DO;
 ALL = .;
%END;
%IF &MAPD > 0 OR &PDP > 0 %THEN %DO;
 PartD = _15;
%END;
RUN;

DATA PARTC_PLANS_CD(DROP=MARKETING_NAME TYPE);
LENGTH HPLAN $12
       CONTRACT_ID $5
       Plan_ID $3
       Segment_ID $3
       ORG_MKT_NAME $ 50
       Plan_Name    $ 75
       YEAR         $4
       PARTD 8;
ARRAY ACAT (35)
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Cardiac_Rehabilitation_Services
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams;

 MERGE PARTC_PLANS(IN=A)
       SECTION_A(IN=C DROP=Segment_ID_N KEEP=PLAN_TYPE TYPE HPLAN CONTRACT_ID Plan_ID Segment_ID MARKETING_NAME Plan_Name);
BY HPLAN;
IF HPLAN = 'FFS' THEN CONTRACT_ID = 'FFS';
IF HPLAN = 'FFS' THEN DELETE;
IF TYPE = 'MAON' THEN PARTD = .;
IF TOTAL = . THEN TOTAL = ALL;
Grand_Total = SUM(TOTAL,PartD);
YEAR = "&RUNYEAR";
ORG_MKT_NAME  = MARKETING_NAME;
*Segment_ID = Segment_ID_N;
IF TOTAL = . THEN TOTAL = ALL;
/*IF TYPE = 'MSA' THEN DO;
   TOTAL = 0;
   DO I = 1 TO DIM(ACAT);
      TOTAL = SUM(TOTAL,ACAT(I));
   END;
   Grand_Total = SUM(TOTAL,PARTD);
END;*/
IF TYPE = 'PDP' THEN DO;
   DO I = 1 TO DIM(ACAT);
      ACAT(I) = .;
   END;
   TOTAL = .;
   Grand_Total = SUM(TOTAL,PartD);
   * DELETE PDP EMPLOYER PLANS THAT WILL NOT HAVE ANY RESULTS;
   IF Plan_ID =: '8' THEN DELETE;
END;
*KEEP ONLY PLANS BEING RUN;
IF PUT(HPLAN,$TYPEF.) NE 'NO';
RUN;

PROC SORT DATA=PARTC_PLANS_CD OUT=PARTC_PLANS_CD;
BY HPLAN;
RUN;

DATA  OOPCS_ALL_FINAL_CD(DROP=SEGMENT SEGMENT_N
RENAME=(CONTRACT_ID=Contract_Number
ORG_MKT_NAME=Organization_Marketing_Name YEAR=Benefit_Year));
LENGTH CONTRACT_ID $5 Plan_ID $3 Segment_ID $3 ORG_MKT_NAME $50 Plan_Name $75 YEAR $4
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Cardiac_Rehabilitation_Services
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams
Total
PartD
Grand_Total 8;
LENGTH SEGMENT_N 8;
SET PARTC_PLANS_CD(KEEP=CONTRACT_ID Plan_ID Segment_ID ORG_MKT_NAME Plan_Name YEAR
 Inpatient_Hospital_Acute_Care
 Inpatient_Mental_Health_Care
 Skilled_Nursing_Facility
 Emergency_Care
 Urgently_Needed_Care
 Home_Health_Agency
 Primary_Care_Physician
 Chiropractic_Services
 Occupational_Therapy
 Physician_Specialists
 Outpatient_Mental_Health_Care
 Podiatry_Services
 Other_Health_Professionals
 Psychiatric_Care
 Physical_and_Speech_Therapy
 Outpatient_Lab
 Diagnostic_Tests_and_Procedures
 Therapeutic_Radiation
 Outpatient_X_Rays
 Diagnostic_Radiological_Services
 Outpatient_Hospital_Services
 Ambulatory_Surgical_Center
 Cardiac_Rehabilitation_Services
 Chemotherapy_Drugs
 Ambulance
 Durable_Medical_Equipment
 Prosthetic_Devices
 Renal_Dialysis
 Pap_Pelvic_Exams
 Screen_Mammography_Exams
 Medicare_Covered_Part_B_Drugs
 Preventative_Comp_Dental
 Medicare_Covered_Dental
 Eye_Exams
 Hearing_Exams
Total
PartD
Grand_Total RENAME=Segment_ID=SEGMENT);
SEGMENT_N = INPUT(SEGMENT,3.);
Segment_ID = PUT(SEGMENT_N,Z3.);
RUN;

PROC EXPORT DATA=  OOPCS_ALL_FINAL_CD
            OUTFILE= "&OOPC"
            DBMS=EXCEL REPLACE;
     SHEET="OOPCS &RUNYEAR";
RUN;
%MEND;
RUN;

%PLAN;
RUN;
