* PROGRAM: BUILD_LOOKUP.SAS;

* first subset the formulary file for the formularies for the planfile.txt;

proc sort data=plan_form out=pforms(keep=formulary_id) nodupkey;
by formulary_id;
run;

proc sort data=form.formulary out=formulary;
by formulary_id;
run;

data formulary_subset;
merge pforms(in=inplan) formulary(in=inform);
by formulary_id;
if inplan and inform;
run;

* merge formulary data with druglist by rxcui, select minimum tier level value;

proc sql;
  create table form_rxcui as
   (select f.formulary_id, f.tier_level_value, d.drugname, d.drug_type
   from formulary_subset f, IN1.druglist_rxcui d
   where f.rxcui = d.rxcui
   )
  ;
;

proc sort data=form_rxcui nodupkey;
by formulary_id drugname tier_level_value drug_type;
run;

data form_rxcui_sub;
set form_rxcui;
by formulary_id drugname tier_level_value;
retain tlvtemp;
if first.drugname then do;
  tlvtemp=tier_level_value;
end;
if tier_level_value=tlvtemp then output;
run;

data low_tiers (keep=formulary_id drugname tier_level_value brand_flag generic_flag);
  set form_rxcui_sub;
  by formulary_id drugname tier_level_value drug_type;
  retain brand_flag generic_flag;
  if first.tier_level_value then do;
    brand_flag='0';
    generic_flag='0';
  end;
  select(drug_type);
    when ('B')  brand_flag='1';
    when ('G')  generic_flag='1';
    otherwise;
  end;
  if last.tier_level_value then output low_tiers;
run;

proc summary data=IN1.druglist_rxcui nway missing;
class drugname drug_type;
var awp_package_price;
output out=median_awp_drugs (drop=_type_ _freq_) median=;
run;

data druglist_rollup (keep=drugname awp_brand awp_generic);
set median_awp_drugs;
by drugname;
array price(2)  awp_brand awp_generic;
retain awp_brand awp_generic;
if first.drugname then do i=1 to 2;
  price(i)=.;
end;
select(drug_type);
  when ('B')  price(1)=awp_package_price;
  when ('G')  price(2)=awp_package_price;
  otherwise;
end;
if last.drugname;
run;

* create shell of all formulary id/drugname combinations;

data _null_;
  set druglist_rollup end = last;
  if last then call symput('drugcnt',left(_n_));
run;

data formlist;
  set formulary_subset;
  by formulary_id;
  if first.formulary_id;
  keep formulary_id;
run;

data shell;
  set formlist end=last;
  do i=1 to &drugcnt.;
    set druglist_rollup (keep=drugname) point=i;
    output;
  end;
  if last then stop;
  keep formulary_id drugname;
run;

* merge tier data onto shell;

data shell_low;
  merge shell (in=a) low_tiers (in=b);
  by formulary_id drugname;
  if a;
  low_tier_flag=b;
run;

proc sort data=shell_low;
  by drugname;
run;

data shell_all;
  merge shell_low (in=a) druglist_rollup (in=b);
  by drugname;
  if a;
  rollup_flag=b;
  if drug_type=' ' then do;
    if awp_generic^=. then drug_type='G';
    else if awp_brand^=. then drug_type='B';
  end;
run;

data drugname_formulary_tiers;
  set shell_all;
  select(tier_level_value);
    when (.)    do;
                  if drug_type='B' then awp_package_price=awp_brand;
                  else if drug_type='G' then awp_package_price=awp_generic;
                end;
    otherwise   do;
                  if drug_type='B' then awp_package_price=awp_brand;
                  else if drug_type='G' then awp_package_price=awp_generic;
                end;
  end;
  keep formulary_id drugname awp_package_price tier_level_value drug_type;
run;

proc sql;
  create table ricpme_sample_cohort as
    (select f.formulary_id, f.tier_level_value, f.awp_package_price, f.drug_type,
            b.baseid, b.rx_script_order, b.drugname, b.drugname_code, b.year
     from IN1.bene_script b, drugname_formulary_tiers f
     where b.drugname = f.drugname
    );

data ricpme_sample_cohort_comp_&year1 ricpme_sample_cohort_comp_&year2;
  set ricpme_sample_cohort;
  length awp_package_price 6 rx_script_order tier_level_value 3;
  drop drugname;
  if year = &year1 then output ricpme_sample_cohort_comp_&year1;
  else if year = &year2 then output ricpme_sample_cohort_comp_&year2;
run;

proc datasets memtype=data lib=work nolist;
delete ricpme_sample_cohort;
run;
