

* PROGRAM: OOPCV4P.SAS;
* DESCRIPTION: MAIN OOPC PROGRAM;

%LET INPUTDIR = c:\oopc\input;
%LET PROGDIR  = c:\oopc\programs;
%LET PBPDIR   = c:\program files\pbp2012;
%LET FORMDIR  = c:\oopc\formulary;
%LET PLANFILE = c:\oopc\programs;
%LET OUTPUT   = c:\oopc\output\;

%LET INPUT=INPUTPLAN;

OPTIONS OBS = MAX NOCENTER MSGLEVEL = N SUMSIZE = 1000M BUFNO = 6
   SORTPGM = SAS  NOSORTEQUALS THREADS = YES NOTES;

OPTIONS NOMPRINT NOSOURCE2;
RUN;

FILENAME IN0     "&INPUTDIR.";
LIBNAME  IN1     "&INPUTDIR.";

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****BEGIN OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;


*SET UP MACRO VARIABLES FOR YEARS;
%LET PBPMAIN       = PBP2012.MDB;
%LET YEAR1         = 2006;
%LET YEAR2         = 2007;
%LET RUNYEAR       = 2012;
%LET MCBSYR1       = 'MCBS 06';
%LET MCBSYR2       = 'MCBS 07';
%LET PARTB_PREMIUM = 99.90; 
%LET DRUG_INF_YR1  = 1.20;
%LET DRUG_INF_YR2  = 1.16; 
%LET PARTB_DEDUCT  = 140.00;
%LET GENERIC_GAP_DISCOUNT = 0.86;
%LET BRAND_GAP_DISCOUNT = 0.5;

%INCLUDE IN0(OOPCV4M.SAS)/SOURCE2;
run;

data _null_;
  ddate = put(date(),YYMMDDN8.);
  put ddate=;
  call symput('file_date', trim(left(ddate)));
run;

%OOPCV4M(RUNYEAR           =2012,
         INP               =IN1.PERSON,
         INC               =IN1.UTILIZATION,
         PBP               =&PBPDIR,
         FORMULARY         =&FORMDIR,
         PLANFILE          =&PROGDIR\PLANFILE.TXT,
         OOPC              =&OUTPUT.OOPC_RUN&file_date..xls);       
run;

DATA _NULL_;
RUNDATE = PUT(DATE(),YYMMDD10.);
PUT "*****ENDED OOPC RUN******";
PUT RUNDATE=;
TIME = time();
PUT TIME = time10.2;
RUN;
