* PROGRAM NAME:  C:\COST_SHARE_AUTOMATE\PARTD_VER\BA_BENEFIT_OOPC_COST_CALCULATION.SAS;

LIBNAME LIBRARY "&INPUTDIR";

%LET BENTYPE = BA;
%LET BENNUM = 3;

%LET MCBS_YEAR = &YEAR1;

DATA PBP_EXTRACT FORMULARY_LIST (KEEP=FORMULARY_ID);
  SET MRX_EXTRACT;

  IF MRX_BENEFIT_TYPE = "&BENNUM.";
  ARRAY CP PLAN_COPAY PLAN_COPAY_CAT PLAN_COPAY_CAT_BRAND PLAN_COPAY_CAT_GEN
           PLAN_COPAY_GAP PLAN_COPAY_PRE;
  DO I = 1 TO 6;
    IF &MCBS_YEAR. = &YEAR1 THEN CP(I) = CP(I) * &DRUG_INF_YR1.;
    ELSE IF &MCBS_YEAR. = &YEAR2 THEN CP(I) = CP(I) * &DRUG_INF_YR2.;
  END;
  LENGTH TIER_LEVEL_VALUE 3;
  TIER_LEVEL_VALUE=INPUT(MRX_TIER_ID,3.);
  OUTPUT PBP_EXTRACT;
  OUTPUT FORMULARY_LIST;
  DROP I MRX_TIER_ID;
RUN;

PROC SORT DATA=PBP_EXTRACT OUT=PLANCNT NODUPKEY;
BY HPLAN;
RUN;

PROC SORT DATA=FORMULARY_LIST NODUPKEY;
  BY FORMULARY_ID;
RUN;

DATA _NULL_;
CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
STOP;
SET FORMULARY_LIST NOBS=NUMOBS;
STOP;
RUN;

%MACRO FMT;
%IF &NUM > 0 %THEN %DO;
DATA FORMULARY_FMT (KEEP=START LABEL HLO FMTNAME);
  SET FORMULARY_LIST (RENAME=FORMULARY_ID=START) END=LAST;
  LENGTH FMTNAME $8 LABEL $3 HLO $1;
  FMTNAME='$FORMF';
  LABEL='YES';
  HLO=' ';
  OUTPUT;
  IF LAST THEN DO;
    START='OTHER';
    LABEL='NO';
    HLO='O';
    OUTPUT;
  END;
RUN;
%END;
%ELSE %DO;
DATA FORMULARY_FMT (KEEP=START LABEL HLO FMTNAME);
  LENGTH FMTNAME $8 LABEL $3 HLO $1;
  FMTNAME='$FORMF';
  START='OTHER';
  LABEL='NO';
  HLO='O';
  OUTPUT;
RUN;
%END;
RUN;
%MEND;
RUN;

%FMT;
RUN;

PROC FORMAT CNTLIN=FORMULARY_FMT;
RUN;

PROC SORT DATA=PBP_EXTRACT;
  BY HPLAN FORMULARY_ID;
RUN;

DATA PBP_EXTRACT;
  SET PBP_EXTRACT;
  BY HPLAN FORMULARY_ID;
  OUTPUT;
  IF LAST.FORMULARY_ID THEN DO;
    TIER_LEVEL_VALUE=.;
    OUTPUT;
  END;
RUN;

%MACRO PLANS;
DATA PLANS(DROP=YEAR);
  %IF &NUM = 0 %THEN %DO;
  SET ricpme_sample_cohort_comp_&MCBS_YEAR(OBS=1);
  DELETE;
  STOP;
  %END;
  %ELSE %DO;
  SET ricpme_sample_cohort_comp_&MCBS_YEAR;
  IF YEAR = &MCBS_YEAR;
  IF PUT(FORMULARY_ID,$FORMF.)='YES';
  IF &MCBS_YEAR. = &YEAR1 THEN AWP_PACKAGE_PRICE = AWP_PACKAGE_PRICE * &DRUG_INF_YR1.;
  ELSE IF &MCBS_YEAR. = &YEAR2 THEN AWP_PACKAGE_PRICE = AWP_PACKAGE_PRICE * &DRUG_INF_YR2.;
  %END;
RUN;
%MEND;
RUN;

%PLANS;
RUN;

PROC SORT DATA=PLANS;
BY FORMULARY_ID BASEID TIER_LEVEL_VALUE RX_SCRIPT_ORDER DRUGNAME_CODE;
RUN;

DATA SHELL_PLANS;
  SET PLANS;
  IF _N_=1 THEN OUTPUT;
  ELSE STOP;
RUN;

DATA SHELL_PBP;
  SET PBP_EXTRACT;
  IF _N_=1 THEN OUTPUT;
  ELSE STOP;
RUN;

DATA PBP_PLANS;
  MERGE SHELL_PLANS (DROP=FORMULARY_ID TIER_LEVEL_VALUE) SHELL_PBP;
  IF _N_=1 THEN DELETE;
RUN;

PROC SQL;
  INSERT INTO PBP_PLANS
     SELECT A.AWP_PACKAGE_PRICE, A.DRUG_TYPE, A.BASEID, A.RX_SCRIPT_ORDER, A.DRUGNAME_CODE,
       P.*
     FROM PLANS A, PBP_EXTRACT P
     WHERE (A.FORMULARY_ID = P.FORMULARY_ID) AND (A.TIER_LEVEL_VALUE = P.TIER_LEVEL_VALUE);
   ;

PROC SORT DATA=PBP_PLANS OVERWRITE SORTSIZE=MAX;
BY HPLAN BASEID RX_SCRIPT_ORDER DRUGNAME_CODE TIER_LEVEL_VALUE AWP_PACKAGE_PRICE;
RUN;

DATA &BENTYPE._COST_CALCS_&MCBS_YEAR;
  SET PBP_PLANS;
  BY HPLAN BASEID RX_SCRIPT_ORDER DRUGNAME_CODE TIER_LEVEL_VALUE AWP_PACKAGE_PRICE;
  RETAIN DEDUCTIBLE ICL NONCOVERED_DRUGS COPAY_OOPC COINS_OOPC TOTAL_COVERED_OOPC TOTAL_COSTS
         REMAINING_DEDUCTIBLE REMAINING_ICL THRESHOLD;
  IF FIRST.BASEID THEN DO;
    DEDUCTIBLE = 0;
    ICL = 0;
    THRESHOLD = 0;
    NONCOVERED_DRUGS = 0;
    COPAY_OOPC = 0;
    COINS_OOPC = 0;
    TOTAL_COVERED_OOPC = 0;
    TOTAL_COSTS = 0;
  END;
  IF TIER_LEVEL_VALUE = . THEN NONCOVERED_DRUGS + AWP_PACKAGE_PRICE;
  ELSE DO;
    %INCLUDE IN0(&BENTYPE._CALCS)/SOURCE2;
  END;
  TOTAL_COSTS + AWP_PACKAGE_PRICE;
  IF LAST.BASEID THEN DO;
    TOTAL_OOPC = SUM(NONCOVERED_DRUGS,TOTAL_COVERED_OOPC);
    OUTPUT;
  END;
  KEEP HPLAN BASEID FORMULARY_ID DEDUCTIBLE ICL THRESHOLD NONCOVERED_DRUGS COPAY_OOPC COINS_OOPC
    TOTAL_COVERED_OOPC TOTAL_COSTS TOTAL_OOPC ;
RUN;

PROC DATASETS MEMTYPE=DATA LIB=WORK NOLIST;
DELETE PLANS;
DELETE PBP_PLANS;
RUN;

RUN;
QUIT;
RUN;

%LET MCBS_YEAR = &YEAR2;

DATA PBP_EXTRACT FORMULARY_LIST (KEEP=FORMULARY_ID);
  SET MRX_EXTRACT;

  IF MRX_BENEFIT_TYPE = "&BENNUM.";
  ARRAY CP PLAN_COPAY PLAN_COPAY_CAT PLAN_COPAY_CAT_BRAND PLAN_COPAY_CAT_GEN
           PLAN_COPAY_GAP PLAN_COPAY_PRE;
  DO I = 1 TO 6;
    IF &MCBS_YEAR. = &YEAR1 THEN CP(I) = CP(I) * &DRUG_INF_YR1.;
    ELSE IF &MCBS_YEAR. = &YEAR2 THEN CP(I) = CP(I) * &DRUG_INF_YR2.;
  END;
  LENGTH TIER_LEVEL_VALUE 3;
  TIER_LEVEL_VALUE=INPUT(MRX_TIER_ID,3.);
  OUTPUT PBP_EXTRACT;
  OUTPUT FORMULARY_LIST;
  DROP I MRX_TIER_ID;
RUN;

PROC SORT DATA=PBP_EXTRACT OUT=PLANCNT NODUPKEY;
BY HPLAN;
RUN;

PROC SORT DATA=FORMULARY_LIST NODUPKEY;
  BY FORMULARY_ID;
RUN;

DATA _NULL_;
CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
STOP;
SET FORMULARY_LIST NOBS=NUMOBS;
STOP;
RUN;

%MACRO FMT;
%IF &NUM > 0 %THEN %DO;
DATA FORMULARY_FMT (KEEP=START LABEL HLO FMTNAME);
  SET FORMULARY_LIST (RENAME=FORMULARY_ID=START) END=LAST;
  LENGTH FMTNAME $8 LABEL $3 HLO $1;
  FMTNAME='$FORMF';
  LABEL='YES';
  HLO=' ';
  OUTPUT;
  IF LAST THEN DO;
    START='OTHER';
    LABEL='NO';
    HLO='O';
    OUTPUT;
  END;
RUN;
%END;
%ELSE %DO;
DATA FORMULARY_FMT (KEEP=START LABEL HLO FMTNAME);
  LENGTH FMTNAME $8 LABEL $3 HLO $1;
  FMTNAME='$FORMF';
  START='OTHER';
  LABEL='NO';
  HLO='O';
  OUTPUT;
RUN;
%END;
RUN;
%MEND;
RUN;

%FMT;
RUN;

PROC FORMAT CNTLIN=FORMULARY_FMT;
RUN;

PROC SORT DATA=PBP_EXTRACT;
  BY HPLAN FORMULARY_ID;
RUN;

DATA PBP_EXTRACT;
  SET PBP_EXTRACT;
  BY HPLAN FORMULARY_ID;
  OUTPUT;
  IF LAST.FORMULARY_ID THEN DO;
    TIER_LEVEL_VALUE=.;
    OUTPUT;
  END;
RUN;

%MACRO PLANS;
DATA PLANS(DROP=YEAR);
  %IF &NUM = 0 %THEN %DO;
  SET ricpme_sample_cohort_comp_&MCBS_YEAR(OBS=1);
  DELETE;
  STOP;
  %END;
  %ELSE %DO;
  SET ricpme_sample_cohort_comp_&MCBS_YEAR;
  IF YEAR = &MCBS_YEAR;
  IF PUT(FORMULARY_ID,$FORMF.)='YES';
  IF &MCBS_YEAR. = &YEAR1 THEN AWP_PACKAGE_PRICE = AWP_PACKAGE_PRICE * &DRUG_INF_YR1.;
  ELSE IF &MCBS_YEAR. = &YEAR2 THEN AWP_PACKAGE_PRICE = AWP_PACKAGE_PRICE * &DRUG_INF_YR2.;
  %END;
RUN;
%MEND;
RUN;

%PLANS;
RUN;

PROC SORT DATA=PLANS;
BY FORMULARY_ID BASEID TIER_LEVEL_VALUE RX_SCRIPT_ORDER DRUGNAME_CODE;
RUN;

DATA SHELL_PLANS;
  SET PLANS;
  IF _N_=1 THEN OUTPUT;
  ELSE STOP;
RUN;

DATA SHELL_PBP;
  SET PBP_EXTRACT;
  IF _N_=1 THEN OUTPUT;
  ELSE STOP;
RUN;

DATA PBP_PLANS;
  MERGE SHELL_PLANS (DROP=FORMULARY_ID TIER_LEVEL_VALUE) SHELL_PBP;
  IF _N_=1 THEN DELETE;
RUN;

PROC SQL;
  INSERT INTO PBP_PLANS
     SELECT A.AWP_PACKAGE_PRICE, A.DRUG_TYPE, A.BASEID, A.RX_SCRIPT_ORDER, A.DRUGNAME_CODE,
       P.*
     FROM PLANS A, PBP_EXTRACT P
     WHERE (A.FORMULARY_ID = P.FORMULARY_ID) AND (A.TIER_LEVEL_VALUE = P.TIER_LEVEL_VALUE);
   ;

PROC SORT DATA=PBP_PLANS OVERWRITE SORTSIZE=MAX;
BY HPLAN BASEID RX_SCRIPT_ORDER DRUGNAME_CODE TIER_LEVEL_VALUE AWP_PACKAGE_PRICE;
RUN;

DATA &BENTYPE._COST_CALCS_&MCBS_YEAR;
  SET PBP_PLANS;
  BY HPLAN BASEID RX_SCRIPT_ORDER DRUGNAME_CODE TIER_LEVEL_VALUE AWP_PACKAGE_PRICE;
  RETAIN DEDUCTIBLE ICL NONCOVERED_DRUGS COPAY_OOPC COINS_OOPC TOTAL_COVERED_OOPC TOTAL_COSTS
         REMAINING_DEDUCTIBLE REMAINING_ICL THRESHOLD;
  IF FIRST.BASEID THEN DO;
    DEDUCTIBLE = 0;
    ICL = 0;
    THRESHOLD = 0;
    NONCOVERED_DRUGS = 0;
    COPAY_OOPC = 0;
    COINS_OOPC = 0;
    TOTAL_COVERED_OOPC = 0;
    TOTAL_COSTS = 0;
  END;
  IF TIER_LEVEL_VALUE = . THEN NONCOVERED_DRUGS + AWP_PACKAGE_PRICE;
  ELSE DO;
    %INCLUDE IN0(&BENTYPE._CALCS)/SOURCE2;
  END;
  TOTAL_COSTS + AWP_PACKAGE_PRICE;
  IF LAST.BASEID THEN DO;
    TOTAL_OOPC = SUM(NONCOVERED_DRUGS,TOTAL_COVERED_OOPC);
    OUTPUT;
  END;
  KEEP HPLAN BASEID FORMULARY_ID DEDUCTIBLE ICL THRESHOLD NONCOVERED_DRUGS COPAY_OOPC COINS_OOPC
    TOTAL_COVERED_OOPC TOTAL_COSTS TOTAL_OOPC ;
RUN;

PROC DATASETS MEMTYPE=DATA LIB=WORK NOLIST;
DELETE PLANS;
DELETE PBP_PLANS;
RUN;

RUN;
QUIT;
RUN;
