
* PROGRAM: COST_SHARING_PULMONARY_REHAB.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR CARDIAC PULMONARY CLAIMS;

DATA PULM_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(CATEGORY='3p'));
RUN;

data pulm_file;
    SET  PBP_FILE (KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B3_MAXENR_AMT PBP_B3_MAXENR_PER
                   PBP_B3_COPAY_AMT_MC_MIN_PRS
                   PBP_B3_COINS_PCT_MC_MIN_PRS
                   PBP_B3_DED_AMT );
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from pulm_baseid b, pulm_file p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO PULM_COST_SHARE(SERV_CAT);

  DATA &SERV_CAT;
    set cat_join (drop = join_id);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF PBP_B3_MAXENR_AMT = . THEN DO;
      MAXENR_AMT = PBP_B3_MAXENR_AMT;
      MAXENR_PER = PBP_B3_MAXENR_PER;
    END;
    ELSE DO;
      MAXENR_AMT = PBP_B3_MAXENR_AMT;
      MAXENR_PER = PBP_B3_MAXENR_PER;
    END;

    IF MAXENR_AMT NE . THEN BENE_MAXIMUM = MAXENR_AMT;

      IF PBP_B3_DED_AMT = . THEN DO;
        COST = SUM(COST,(VISITS*PBP_B3_COPAY_AMT_MC_MIN_PRS));
        COST = SUM(COST,(AMTTOT*PBP_B3_COINS_PCT_MC_MIN_PRS));
      END;
      ELSE DO;
        IF AMTTOT <= PBP_B3_DED_AMT THEN DO;
          COST = AMTTOT;
        END;
        ELSE DO;
          COST = PBP_B3_DED_AMT;
          DEDUCT_SHARE = PBP_B3_DED_AMT / AMTTOT;
          AMTTOT = SUM(AMTTOT,-PBP_B3_DED_AMT);
          VISITS = VISITS * (1 - DEDUCT_SHARE);
          COST = SUM(COST,(VISITS*PBP_B3_COPAY_AMT_MC_MIN_PRS));
          COST = SUM(COST,(AMTTOT*PBP_B3_COINS_PCT_MC_MIN_PRS));
        END;
      END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "3p";
  RUN;

%MEND PULM_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=PULM;
RUN;
%PULM_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC APPEND DATA=PULM(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE PULM PULM_BASEID PULM_FILE CAT_JOIN;
QUIT;
RUN;
