
* PROGRAM: COST_SHARING_SUPPLIES.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR SUPPLIES CLAIMS;

DATA SUPPLIES_BASEID;
RETAIN JOIN_ID '1';
SET &INC(WHERE=(SOURCE = 'supplies'));
RUN;

data SUPPLIES_FILE;
    SET PBP_FILE (KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B11B_DED_AMT PBP_B11B_MAXENR_AMT
                   PBP_B11B_MAXENR_PER PBP_B11B_MAXENR_COST_TYPE PBP_B11A_MAXENR_AMT PBP_B11A_MAXENR_PER
                   PBP_B11B_COINS_PCT_MCMS_MIN PBP_B11B_COPAY_MCMS_MIN_AMT);
  join_id = '1';
run;

proc sql;
  create table cat_join as
      (select b.category, b.baseid, b.visits, b.amttot, b.year, p.*
      from SUPPLIES_BASEID b, SUPPLIES_FILE p
      where b.join_id = p.join_id)
    ;
quit;
run;

%MACRO SUPPLIES_COST_SHARE(SERV_CAT);

%LET SERV_CAT = SUPPLIES;
  DATA &SERV_CAT;
    set cat_join (drop = join_id);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;

    IF PBP_B11B_MAXENR_AMT = . AND PBP_B11B_MAXENR_COST_TYPE = '1' THEN DO;
      MAXENR_AMT = PBP_B11A_MAXENR_AMT;
      MAXENR_PER = PBP_B11A_MAXENR_PER;
    END;
    ELSE DO;
      MAXENR_AMT = PBP_B11B_MAXENR_AMT;
      MAXENR_PER = PBP_B11B_MAXENR_PER;
    END;

    IF MAXENR_AMT NE . THEN BENE_MAXIMUM =MAXENR_AMT;

      IF PBP_B11B_DED_AMT = . THEN DO;
        COST = SUM(COST,(VISITS*PBP_B11B_COPAY_MCMS_MIN_AMT));
        COST = SUM(COST,AMTTOT*PBP_B11B_COINS_PCT_MCMS_MIN);
      END;
      ELSE DO;
        IF AMTTOT <= PBP_B11B_DED_AMT THEN DO;
          COST = AMTTOT;
        END;
        ELSE DO;
          COST = PBP_B11B_DED_AMT;
          DEDUCT_SHARE = PBP_B11B_DED_AMT / AMTTOT;
          AMTTOT = SUM(AMTTOT,-PBP_B11B_DED_AMT);
          VISITS = VISITS * (1 - DEDUCT_SHARE);
          COST = SUM(COST,(VISITS*PBP_B11B_COPAY_MCMS_MIN_AMT));
          COST = SUM(COST,AMTTOT*PBP_B11B_COINS_PCT_MCMS_MIN);
        END;
      END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "11b";
  RUN;

%MEND SUPPLIES_COST_SHARE;

%MACRO RUN_COST;
%LET CAT=SUPPLIES;
RUN;

%SUPPLIES_COST_SHARE(&CAT);

%MEND RUN_COST;

%RUN_COST;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE SUPPLIES_BASEID SUPPLIES_FILE CAT_JOIN;
QUIT;
RUN;
