// RugIV.cpp : Defines the entry point for the DLL application.
//
#include "RugIV.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <ctime>

int CheckDate( char * YYYY, char * MM, char * DD )
{
	int year, month, day;

    if ( !isdigit(YYYY[0]) || !isdigit(YYYY[1]) || !isdigit(YYYY[2]) || !isdigit(YYYY[3]) ||
		 !isdigit(MM[0]) || !isdigit(MM[1]) || !isdigit(DD[0]) || !isdigit(DD[1]) )
		 return 1;
	year = atoi( YYYY );
	month = atoi( MM );
	day = atoi( DD );
	if ( year == 0 ) return 1;
	if ( month < 1 || month > 12 ) return 1;
	if ( day < 1 || day > 31 ) return 1;
	if ( ( day == 31 ) &&
		 ( month == 4 || month == 6 || month == 9 || month == 11 ) )
		 return 1;
	if ( month == 2 )
	{
	     if ( day > 29 ) return 1;
		 if ( ( year % 4 != 0 || year % 100 == 0 && year % 400 != 0 ) && day == 29 ) return 1;
	}
	return 0;
}

int CheckYYYYMMDD( char * YYYYMMDD )
{
	char YYYY[5], MM[3], DD[3];

	YYYY[0] = YYYYMMDD[0];
	YYYY[1] = YYYYMMDD[1];
	YYYY[2] = YYYYMMDD[2];
	YYYY[3] = YYYYMMDD[3];
	YYYY[4] = '\0';
	MM[0] = YYYYMMDD[4];
	MM[1] = YYYYMMDD[5];
	MM[2] = '\0';
	DD[0] = YYYYMMDD[6];
	DD[1] = YYYYMMDD[7];
	DD[2] = '\0';
	return CheckDate( YYYY, MM, DD );
}

int daysBetweenTwodates( char * date2, char * date1 )
{
	char dayStr[3], monthStr[3], yearStr[5];
	struct tm time2, time1;
    time_t t2, t1;
	double tDiff, tSpan;
	int dSpan;

    yearStr[0] = date2[0];
    yearStr[1] = date2[1];
    yearStr[2] = date2[2];
    yearStr[3] = date2[3];
	yearStr[4] = '\0';
	monthStr[0] = date2[4];
	monthStr[1] = date2[5];
	monthStr[2] = '\0';
	dayStr[0] = date2[6];
	dayStr[1] = date2[7];
	dayStr[2] = '\0';
	time2.tm_sec = 0;
	time2.tm_min = 0;
	time2.tm_hour = 0;
	time2.tm_mday = atoi(dayStr);
	time2.tm_mon = atoi(monthStr) - 1;
	time2.tm_year = atoi(yearStr) - 1900;

    yearStr[0] = date1[0];
    yearStr[1] = date1[1];
    yearStr[2] = date1[2];
    yearStr[3] = date1[3];
	yearStr[4] = '\0';
	monthStr[0] = date1[4];
	monthStr[1] = date1[5];
	monthStr[2] = '\0';
	dayStr[0] = date1[6];
	dayStr[1] = date1[7];
	dayStr[2] = '\0';
	time1.tm_sec = 0;
	time1.tm_min = 0;
	time1.tm_hour = 0;
	time1.tm_mday = atoi(dayStr);
	time1.tm_mon = atoi(monthStr) - 1;
	time1.tm_year = atoi(yearStr) - 1900;

	t2 = mktime(&time2);
	t1 = mktime(&time1);

	tDiff = difftime(t2, t1);
	tSpan = tDiff/86400.0;
	dSpan = (int)(tSpan + 0.1);

	return dSpan;
}

void GetRug( int index, char * value, double nCmiArray[],
			 double * nCmiValueHier, double * nCmiValueMax,
			 char * sRugHier, int * nRugHier, char * sRugMax,
			 int * nRugMax )
{
	if ( nCmiArray[index] > *nCmiValueMax )
	{
	     if ( -9999 == (int)(*nCmiValueMax) )
		 {
			*nCmiValueHier = nCmiArray[index];
			strcpy( sRugHier, value );
			*nRugHier = index;
		 }
         *nCmiValueMax = nCmiArray[index];
		 strcpy( sRugMax, value );
		 *nRugMax = index;
    }
}

void GetRug_NT( int index, char * value, double nCmiArray[],
			    double * nCmiValueHier_NT, double * nCmiValueMax_NT,
			    char * sRugHier_NT, int * nRugHier_NT, char * sRugMax_NT,
				int * nRugMax_NT )
{
   if ( nCmiArray[index] > *nCmiValueMax_NT )
   {
      if ( -9999 == (int)(*nCmiValueMax_NT) )
      {
          *nCmiValueHier_NT = nCmiArray[index];
		  strcpy( sRugHier_NT, value );
		  *nRugHier_NT = index;
	  }
      *nCmiValueMax_NT = nCmiArray[index];
	  strcpy( sRugMax_NT, value );
	  *nRugMax_NT = index;
   }
}

#ifdef SOLARIS
   int RugCalcIV( char * sMdsRecord,
               char * sRehabType,
			   char * sModel,
			   double nCmiArray[ ],
			   int * l_Mcare_short_stay,
			   char * sAI_code,
			   int * i_adl_tot,
			   int * l_depression,
			   int * i_rnursing_cnt,
			   int *  i_ext_serv_level,
			   int * l_spec_high_cond,
			   int * l_spec_low_cond,
			   int * l_cog_impair,
			   int * l_beh_sympt,
			   int * l_ext_serv,
			   double * n_tot_rehab_min,
			   int * i_tot_rehab_days,
			   int * i_rehab_type_5days,
			   int * i_rehab_type_3days,
			   double * n_avg_rehab_min,
			   int * l_rehab_ultra,
			   int * l_rehab_very,
			   int * l_rehab_high,
			   int * l_rehab_medium,
			   int * l_rehab_low,
			   int * l_special_high,
			   int * l_special_low,
			   int * l_clin_complex,
			   int * l_beh_cog,
			   char *sRugHier,
			   char * sRugMax,
			   int * nRugHier,
			   int * nRugMax,
			   double * nCmiValueHier,
			   double * nCmiValueMax,
			   char *sRugHier_NT,
			   char * sRugMax_NT,
			   int * nRugHier_NT,
			   int * nRugMax_NT,
			   double * nCmiValueHier_NT,
			   double * nCmiValueMax_NT,
			   char * sRugsVersion,
			   char * sDllVersion,
			   int * nError )
#else
extern "C" __declspec(dllexport) int __stdcall
    RugCalcIV( char * sMdsRecord,
               char * sRehabType,
			   char * sModel,
			   double nCmiArray[ ],
			   int * l_Mcare_short_stay,
			   char * sAI_code,
			   int * i_adl_tot,
			   int * l_depression,
			   int * i_rnursing_cnt,
			   int * i_ext_serv_level,
			   int * l_spec_high_cond,
			   int * l_spec_low_cond,
			   int * l_cog_impair,
			   int * l_beh_sympt,
			   int * l_ext_serv,
			   double * n_tot_rehab_min,
			   int * i_tot_rehab_days,
			   int * i_rehab_type_5days,
			   int * i_rehab_type_3days,
			   double * n_avg_rehab_min,
			   int * l_rehab_ultra,
			   int * l_rehab_very,
			   int * l_rehab_high,
			   int * l_rehab_medium,
			   int * l_rehab_low,
			   int * l_special_high,
			   int * l_special_low,
			   int * l_clin_complex,
			   int * l_beh_cog,
			   char *sRugHier,
			   char * sRugMax,
			   int * nRugHier,
			   int * nRugMax,
			   double * nCmiValueHier,
			   double * nCmiValueMax,
			   char *sRugHier_NT,
			   char * sRugMax_NT,
			   int * nRugHier_NT,
			   int * nRugMax_NT,
			   double * nCmiValueHier_NT,
			   double * nCmiValueMax_NT,
			   char * sRugsVersion,
			   char * sDllVersion,
			   int * nError )
#endif
{
	int l_Mcare_short_stay_L, i_adl_tot_L, l_depression_L, i_rnursing_cnt_L;
	int i_ext_serv_level_L, l_ext_serv_L, l_spec_high_cond_L, l_spec_low_cond_L;
	int l_cog_impair_L, l_beh_sympt_L, l_rehab_ultra_L, l_rehab_very_L, l_rehab_high_L;
	int l_rehab_medium_L, l_rehab_low_L, l_special_high_L, l_special_low_L;
	int l_clin_complex_L, l_beh_cog_L, i_tot_rehab_days_L, i_rehab_type_5days_L;
	int i_rehab_type_3days_L;
    double n_tot_rehab_min_L, n_avg_rehab_min_L;

	unsigned int i;
	int i_sl_skin_tx_cnt, i_cc_skin_tx_cnt;
	double n_tot_speech_min, n_tot_ot_min, n_tot_pt_min;

	strcpy( sRugHier, "AAA" );
	*nRugHier = 72;
    *nCmiValueHier = 0.0;
	strcpy( sRugMax, "AAA" );
	*nRugMax = 72;
    *nCmiValueMax = 0.0;
	strcpy( sRugHier_NT, "AAA" );
	*nRugHier_NT = 72;
    *nCmiValueHier_NT = 0.0;
	strcpy( sRugMax_NT, "AAA" );
	*nRugMax_NT = 72;
    *nCmiValueMax_NT = 0.0;
	strcpy( sAI_code, "  " );
    *l_Mcare_short_stay = 0;
    *i_adl_tot = 0;
	*l_depression = 0;
	*i_rnursing_cnt = 0;
	*i_ext_serv_level = 0;
	*l_spec_high_cond = 0;
	*l_spec_low_cond = 0;
	*l_cog_impair = 0;
	*l_beh_sympt = 0;
	*l_ext_serv = 0;
	*n_tot_rehab_min = 0.0;
	*i_tot_rehab_days = 0;
	*i_rehab_type_5days = 0;
	*i_rehab_type_3days = 0;
	*n_avg_rehab_min = 0.0;
	*l_rehab_ultra = 0;
	*l_rehab_very = 0;
	*l_rehab_high = 0;
	*l_rehab_medium = 0;
	*l_rehab_low = 0;
	*l_special_high = 0;
	*l_special_low = 0;
	*l_clin_complex = 0;
	*l_beh_cog = 0;

    l_Mcare_short_stay_L = 0;
    i_adl_tot_L = 0;
	l_depression_L = 0;
	i_rnursing_cnt_L = 0;
	i_ext_serv_level_L = 0;
    l_spec_high_cond_L = 0;
	l_spec_low_cond_L = 0;
	l_cog_impair_L = 0;
	l_beh_sympt_L = 0;
    l_ext_serv_L = 0;
    l_rehab_ultra_L = 0;
	l_rehab_very_L = 0;
	l_rehab_high_L = 0;
	l_rehab_medium_L = 0;
	l_rehab_low_L = 0;
	l_special_high_L = 0;
	l_special_low_L = 0;
	l_clin_complex_L = 0;
    l_beh_cog_L = 0;

	i_sl_skin_tx_cnt = 0;
	i_cc_skin_tx_cnt = 0;
	n_tot_speech_min = 0.0;
	n_tot_ot_min = 0.0;
	n_tot_pt_min = 0.0;

    n_tot_rehab_min_L = 0.0;
    i_rehab_type_5days_L = 0;
    i_rehab_type_3days_L = 0;
    i_tot_rehab_days_L = 0;
    n_avg_rehab_min_L = 0.0;

/* V1.04.0 changed */
	strcpy( sRugsVersion, "1.04" );
	strcpy( sDllVersion, "1.04.1" );
    *nError = 0;

	for ( i=0; i<strlen(sRehabType); i++ )
	      sRehabType[i] = toupper(sRehabType[i]);

    if ( (0!=strcmp(sRehabType, "MCARE")) && (0!=strcmp(sRehabType, "MCAR2")) && (0!=strcmp(sRehabType, "MCAR3")) && (0!=strcmp(sRehabType, "OTHER")) )
	{
		  *nError = 1;
		  return 1;
	}

	if ( (0!=strcmp(sModel, "48")) && (0!=strcmp(sModel, "57")) && (0!=strcmp(sModel, "66")) )
	{
		  *nError = 2;
		  return 1;
	}
	else
	{
          strcat( sRugsVersion, sModel );
	}

	//V1.04 - get A2300 now, so we know if this is before or after 10/01/2019
	char A2300[9];
	long a2300;
    A2300[0] = sMdsRecord[485];
    A2300[1] = sMdsRecord[486];
    A2300[2] = sMdsRecord[487];
    A2300[3] = sMdsRecord[488];
    A2300[4] = sMdsRecord[489];
    A2300[5] = sMdsRecord[490];
    A2300[6] = sMdsRecord[491];
    A2300[7] = sMdsRecord[492];
    A2300[8] = '\0';
	a2300 = atol(A2300);

	//A0310A(270, 271), A0310B(272,273), A0310C(274,274), A0310D(275,275)
	char A0310A[3], A0310B[3];
	int iA0310A, iA0310B;
	char A0310C, A0310D;
	//V1.04 - new A0300 items
	char A0300A[2], A0300B[2];
	int iA0300A, iA0300B;

	A0310A[0] = sMdsRecord[269];
	A0310A[1] = sMdsRecord[270];
	A0310A[2] = '\0';
	A0310B[0] = sMdsRecord[271];
	A0310B[1] = sMdsRecord[272];
	A0310B[2] = '\0';
	A0310C = sMdsRecord[273];
	A0310D = sMdsRecord[274];
	//V1.04 - new A0300 items
	A0300A[0] = sMdsRecord[1700];
	A0300A[1] = '\0';
	A0300B[0] = sMdsRecord[1701];
	A0300B[1] = '\0';

	//V1.04 - new code

	iA0310A = atoi(A0310A);
	iA0310B = atoi(A0310B);


	if (a2300 < 20191001)
	{
		if ( 99==iA0310A && 99==iA0310B )
		{
			 strcpy( sAI_code, "X " );
			 *nError = 3;
			 return 1;
		}
		if ( iA0310A<1 || (iA0310A>6 && iA0310A!=99) )
		{
			 *nError = 3;
			 return 1;
		}
		if ( iA0310B<1 || (iA0310B>7 && iA0310B!=99) )
		{
			 *nError = 3;
			 return 1;
		}
		// Add A0310C!='4' for V1.01.1
		if ( A0310C!='0' && A0310C!='1' &&  A0310C!='2' &&  A0310C!='3' &&  A0310C!='4' )
		{
			 *nError = 3;
			 return 1;

		}
		if ( A0310D!='^' && A0310D!='0' &&  A0310D!='1' )
		{
			 *nError = 3;
			 return 1;
		}
	}
	else
	{
		iA0300A = atoi(A0300A);
		iA0300B = atoi(A0300B);
		if (1==iA0300A)
		{
			//if ( A0300B!='1' &&  A0300B!='2' &&  A0300B!='3' &&  A0300B!='4' &&  A0300B!='5')
			if ( iA0300B<1 || iA0300B>5 )
			{
				*nError = 3;
				return 1;

			}
		}
		else if (0==iA0300A)
		{
			if ( 99==iA0310A && 99==iA0310B )
			{
				 strcpy( sAI_code, "X " );
				 *nError = 3;
				 return 1;
			}
			if ( iA0310A<1 || (iA0310A>6 && iA0310A!=99) )
			{
				 *nError = 3;
				 return 1;
			}
			// RUG-IV not applicable for IPA, so not allowing 08
			if (iA0310B!=1 && iA0310B!=99)
			{
				 *nError = 3;
				 return 1;
			}
		}

	}
    //end changes for v1.04

    for ( i=0; i<73; i++ )
	{
          if ( nCmiArray[i] <= -9999.0 || nCmiArray[i] > 9999.0 )
		  {
			   *nError = 4;
			   break;
		  }
	}
    if ( *nError == 4 ) return 1;

	char G0110A1 = sMdsRecord[645], G0110A2 = sMdsRecord[646];
	char G0110B1 = sMdsRecord[647], G0110B2 = sMdsRecord[648];
	char G0110H1 = sMdsRecord[659], G0110H2 = sMdsRecord[660];
	char G0110I1 = sMdsRecord[661], G0110I2 = sMdsRecord[662];
    int i_bedmob = 0, i_transfer = 0, i_toilet = 0, i_eating = 0;

	if ( G0110A1=='-' || G0110A1=='0' || G0110A1=='1' || G0110A1=='7' ||
		 G0110A1=='8' ) i_bedmob = 0;
	else if ( G0110A1 == '2' ) i_bedmob = 1;
	else if ( G0110A1=='3' &&
		      (G0110A2=='-' || G0110A2=='0' || G0110A2=='1' || G0110A2=='2') ) i_bedmob = 2;
	else if ( G0110A1=='4' &&
		      (G0110A2=='-' || G0110A2=='0' || G0110A2=='1' || G0110A2=='2') ) i_bedmob = 3;
	else if ( (G0110A1=='3' || G0110A1=='4') && G0110A2=='3' ) i_bedmob = 4;

	if ( G0110B1=='-' || G0110B1=='0' || G0110B1=='1' || G0110B1=='7' ||
		 G0110B1=='8' ) i_transfer = 0;
	else if ( G0110B1 == '2' ) i_transfer = 1;
	else if ( G0110B1=='3' &&
		      (G0110B2=='-' || G0110B2=='0' || G0110B2=='1' || G0110B2=='2') ) i_transfer = 2;
	else if ( G0110B1=='4' &&
		      (G0110B2=='-' || G0110B2=='0' || G0110B2=='1' || G0110B2=='2') ) i_transfer = 3;
	else if ( (G0110B1=='3' || G0110B1=='4') && G0110B2=='3' ) i_transfer = 4;

	if ( G0110I1=='-' || G0110I1=='0' || G0110I1=='1' || G0110I1=='7' ||
		 G0110I1=='8' ) i_toilet = 0;
	else if ( G0110I1 == '2' ) i_toilet = 1;
	else if ( G0110I1=='3' &&
		      (G0110I2=='-' || G0110I2=='0' || G0110I2=='1' || G0110I2=='2') ) i_toilet = 2;
	else if ( G0110I1=='4' &&
		      (G0110I2=='-' || G0110I2=='0' || G0110I2=='1' || G0110I2=='2') ) i_toilet = 3;
	else if ( (G0110I1=='3' || G0110I1=='4') && G0110I2=='3' ) i_toilet = 4;

	if ( (G0110H1=='-' || G0110H1=='0' || G0110H1=='1' || G0110H1=='2' || G0110H1=='7' ||
		  G0110H1=='8') && (G0110H2=='-' || G0110H2=='0' || G0110H2=='1' || G0110H2=='8') )
		  i_eating = 0;
	if ( (G0110H1=='-' || G0110H1=='0' || G0110H1=='1' || G0110H1=='2' || G0110H1=='7' ||
		  G0110H1=='8') && (G0110H2=='2' || G0110H2=='3') ) i_eating = 2;
	if ( G0110H1=='3' && (G0110H2=='-' || G0110H2=='0' || G0110H2=='1') ) i_eating = 2;
	if ( G0110H1=='3' && (G0110H2=='2' || G0110H2=='3') ) i_eating = 3;
	if ( G0110H1=='4' && (G0110H2=='-' || G0110H2=='0' || G0110H2=='1') ) i_eating = 2;
	if ( G0110H1=='4' && (G0110H2=='2' || G0110H2=='3') ) i_eating = 4;

	i_adl_tot_L = i_bedmob + i_transfer + i_toilet + i_eating;

	*i_adl_tot = i_adl_tot_L;

	char O0400A1[5], O0400A2[5], O0400A3[5];
    int i_O0400A1, i_O0400A2, i_O0400A3;

	O0400A1[0] = sMdsRecord[1007];
	O0400A1[1] = sMdsRecord[1008];
	O0400A1[2] = sMdsRecord[1009];
	O0400A1[3] = sMdsRecord[1010];
	O0400A1[4] = '\0';
	O0400A2[0] = sMdsRecord[1011];
	O0400A2[1] = sMdsRecord[1012];
	O0400A2[2] = sMdsRecord[1013];
	O0400A2[3] = sMdsRecord[1014];
	O0400A2[4] = '\0';
	O0400A3[0] = sMdsRecord[1015];
	O0400A3[1] = sMdsRecord[1016];
	O0400A3[2] = sMdsRecord[1017];
	O0400A3[3] = sMdsRecord[1018];
	O0400A3[4] = '\0';

    i_O0400A1 = atoi( O0400A1 );
    i_O0400A2 = atoi( O0400A2 );
    i_O0400A3 = atoi( O0400A3 );

	n_tot_speech_min = 0.0;
	if ( i_O0400A1 >= 1 && i_O0400A1 <= 9999 ) n_tot_speech_min += (double)i_O0400A1;
	if ( i_O0400A2 >= 1 && i_O0400A2 <= 9999 ) n_tot_speech_min += (((double)i_O0400A2) / 2.0);
	/* Comment out for V1.01.1
	if ( i_O0400A3 >= 1 && i_O0400A3 <= 9999 ) n_tot_speech_min += (double)i_O0400A3;

    if ( strcmp( "MCARE", sRehabType ) == 0 )
	{
		if ( (n_tot_speech_min>0.0) && ((((double)i_O0400A3)/n_tot_speech_min)>0.25) )
              n_tot_speech_min  = ((double)i_O0400A1 + ((double)i_O0400A2)/2.0) * 4.0 / 3.0;
	}
	*/
    // add for V1.01.1
	if ( i_O0400A3 >= 1 && i_O0400A3 <= 9999 )
	{
/* V1.03.0 changed */
		if ( 0 == strcmp(sRehabType, "MCAR2") || 0 == strcmp(sRehabType, "MCAR3") )
             n_tot_speech_min  += (((double)i_O0400A3)/4.0);
		else
		     n_tot_speech_min += (double)i_O0400A3;
	}
	//Apply group time adjustment if the rehabilitation calculation type is MCARE or MCAR2
	if ( i_O0400A3 >= 1 && i_O0400A3 <= 9999 )
	{
		 double A3Val = 0.0;
/* V1.03.0 changed */
		 if ( (0 == strcmp(sRehabType, "MCAR2")|| 0 == strcmp(sRehabType, "MCAR3")) && (n_tot_speech_min > 0.0) )
		 {
		      A3Val = (((double)i_O0400A3)/4.0) / n_tot_speech_min;
			  if ( A3Val > 0.25 )  {
			       n_tot_speech_min = 0.0;
	               if ( i_O0400A1 >= 1 && i_O0400A1 <= 9999 )
                        n_tot_speech_min  += ((((double)i_O0400A1)*4.0) / 3.0);
	               if ( i_O0400A2 >= 1 && i_O0400A2 <= 9999 )
                        n_tot_speech_min  += ((((double)i_O0400A2)/2.0) * 4.0 / 3.0);
		      }
		 }
		 else if ( (0 == strcmp(sRehabType, "MCARE")) && (n_tot_speech_min > 0.0) )
		 {
		      A3Val = ((double)i_O0400A3) / n_tot_speech_min;
			  if ( A3Val > 0.25 )  {
                   n_tot_speech_min = 0.0;
	               if ( i_O0400A1 >= 1 && i_O0400A1 <= 9999 )
                        n_tot_speech_min  += ((((double)i_O0400A1)*4.0) / 3.0);
	               if ( i_O0400A2 >= 1 && i_O0400A2 <= 9999 )
                        n_tot_speech_min  += ((((double)i_O0400A2)/2.0) * 4.0 / 3.0);
		      }
		 }
	}

    char O0400B1[5], O0400B2[5], O0400B3[5];
    int i_O0400B1, i_O0400B2, i_O0400B3;

	O0400B1[0] = sMdsRecord[1036];
	O0400B1[1] = sMdsRecord[1037];
	O0400B1[2] = sMdsRecord[1038];
	O0400B1[3] = sMdsRecord[1039];
	O0400B1[4] = '\0';
	O0400B2[0] = sMdsRecord[1040];
	O0400B2[1] = sMdsRecord[1041];
	O0400B2[2] = sMdsRecord[1042];
	O0400B2[3] = sMdsRecord[1043];
	O0400B2[4] = '\0';
	O0400B3[0] = sMdsRecord[1044];
	O0400B3[1] = sMdsRecord[1045];
	O0400B3[2] = sMdsRecord[1046];
	O0400B3[3] = sMdsRecord[1047];
	O0400B3[4] = '\0';

    i_O0400B1 = atoi( O0400B1 );
    i_O0400B2 = atoi( O0400B2 );
    i_O0400B3 = atoi( O0400B3 );

	n_tot_ot_min = 0.0;
	if ( i_O0400B1 >= 1 && i_O0400B1 <= 9999 ) n_tot_ot_min += (double)i_O0400B1;
	if ( i_O0400B2 >= 1 && i_O0400B2 <= 9999 ) n_tot_ot_min += (((double)i_O0400B2) / 2.0);

	/* Comment out for V1.01.1
	if ( i_O0400B3 >= 1 && i_O0400B3 <= 9999 ) n_tot_ot_min += (double)i_O0400B3;

    if ( strcmp( "MCARE", sRehabType ) == 0 )
	{
		if ( (n_tot_ot_min>0.0) && ((((double)i_O0400B3)/n_tot_ot_min)>0.25) )
              n_tot_ot_min  = ((double)i_O0400B1 + ((double)i_O0400B2)/2.0) * 4.0 / 3.0;
	}
    */
    // add for V1.01.1
	if ( i_O0400B3 >= 1 && i_O0400B3 <= 9999 )
	{
/* V1.03.0 changed */
		if ( 0 == strcmp(sRehabType, "MCAR2") || 0 == strcmp(sRehabType, "MCAR3") )
             n_tot_ot_min  += (((double)i_O0400B3)/4.0);
		else
		     n_tot_ot_min += (double)i_O0400B3;
	}
	//Apply group time adjustment if the rehabilitation calculation type is MCARE or MCAR2
	if ( i_O0400B3 >= 1 && i_O0400B3 <= 9999 )
	{
		 double B3Val = 0.0;
/* V1.03.0 changed */
		 if ( (0 == strcmp(sRehabType, "MCAR2") || 0 == strcmp(sRehabType, "MCAR3")) && (n_tot_ot_min > 0.0) )
		 {
		      B3Val = (((double)i_O0400B3)/4.0) / n_tot_ot_min;
			  if ( B3Val > 0.25 ) {
                   n_tot_ot_min = 0.0;
	               if ( i_O0400B1 >= 1 && i_O0400B1 <= 9999 )
                        n_tot_ot_min  += ((((double)i_O0400B1)*4.0) / 3.0);
	               if ( i_O0400B2 >= 1 && i_O0400B2 <= 9999 )
                        n_tot_ot_min  += ((((double)i_O0400B2)/2.0) * 4.0 / 3.0);
			  }
		 }
		 else if ( (0 == strcmp(sRehabType, "MCARE")) && (n_tot_ot_min > 0.0) )
		 {
		      B3Val = ((double)i_O0400B3) / n_tot_ot_min;
			  if ( B3Val > 0.25 ) {
                   n_tot_ot_min = 0.0;
	               if ( i_O0400B1 >= 1 && i_O0400B1 <= 9999 )
                        n_tot_ot_min  += ((((double)i_O0400B1)*4.0) / 3.0);
	               if ( i_O0400B2 >= 1 && i_O0400B2 <= 9999 )
                        n_tot_ot_min  += ((((double)i_O0400B2)/2.0) * 4.0 / 3.0);
			  }
		 }
	}


    char O0400C1[5], O0400C2[5], O0400C3[5];
    int i_O0400C1, i_O0400C2, i_O0400C3;

	O0400C1[0] = sMdsRecord[1065];
	O0400C1[1] = sMdsRecord[1066];
	O0400C1[2] = sMdsRecord[1067];
	O0400C1[3] = sMdsRecord[1068];
	O0400C1[4] = '\0';
	O0400C2[0] = sMdsRecord[1069];
	O0400C2[1] = sMdsRecord[1070];
	O0400C2[2] = sMdsRecord[1071];
	O0400C2[3] = sMdsRecord[1072];
	O0400C2[4] = '\0';
	O0400C3[0] = sMdsRecord[1073];
	O0400C3[1] = sMdsRecord[1074];
	O0400C3[2] = sMdsRecord[1075];
	O0400C3[3] = sMdsRecord[1076];
	O0400C3[4] = '\0';

    i_O0400C1 = atoi( O0400C1 );
    i_O0400C2 = atoi( O0400C2 );
    i_O0400C3 = atoi( O0400C3 );

	n_tot_pt_min = 0.0;
	if ( i_O0400C1 >= 1 && i_O0400C1 <= 9999 ) n_tot_pt_min += (double)i_O0400C1;
	if ( i_O0400C2 >= 1 && i_O0400C2 <= 9999 ) n_tot_pt_min += (((double)i_O0400C2) / 2.0);
	/* Comment out for V1.01.1
	if ( i_O0400C3 >= 1 && i_O0400C3 <= 9999 ) n_tot_pt_min += (double)i_O0400C3;

    if ( strcmp( "MCARE", sRehabType ) == 0 )
	{
		if ( (n_tot_pt_min>0.0) && ((((double)i_O0400C3)/n_tot_pt_min)>0.25) )
              n_tot_pt_min  = ((double)i_O0400C1 + ((double)i_O0400C2)/2.0) * 4.0 / 3.0;
	}
    */
    // add for V1.01.1
	if ( i_O0400C3 >= 1 && i_O0400C3 <= 9999 )
	{
/* V1.03.0 changed */
		if ( 0 == strcmp(sRehabType, "MCAR2") || 0 == strcmp(sRehabType, "MCAR3") )
             n_tot_pt_min  += (((double)i_O0400C3)/4.0);
		else
		     n_tot_pt_min += (double)i_O0400C3;
	}
	//Apply group time adjustment if the rehabilitation calculation type is MCARE or MCAR2
	if ( i_O0400C3 >= 1 && i_O0400C3 <= 9999 )
	{
		 double C3Val = 0.0;
/* V1.03.0 changed */
		 if ( (0 == strcmp(sRehabType, "MCAR2")||0 == strcmp(sRehabType, "MCAR3")) && (n_tot_pt_min > 0.0) )
		 {
		      C3Val = (((double)i_O0400C3)/4.0) / n_tot_pt_min;
			  if ( C3Val > 0.25 ) {
			       n_tot_pt_min = 0.0;
	               if ( i_O0400C1 >= 1 && i_O0400C1 <= 9999 )
                        n_tot_pt_min  += ((((double)i_O0400C1)*4.0) / 3.0);
	               if ( i_O0400C2 >= 1 && i_O0400C2 <= 9999 )
                        n_tot_pt_min  += ((((double)i_O0400C2)/2.0) * 4.0 / 3.0);
			  }
		 }
		 else if ( (0 == strcmp(sRehabType, "MCARE")) && (n_tot_pt_min > 0.0) )
		 {
		      C3Val = ((double)i_O0400C3) / n_tot_pt_min;
			  if ( C3Val > 0.25 ) {
			       n_tot_pt_min = 0.0;
	               if ( i_O0400C1 >= 1 && i_O0400C1 <= 9999 )
                        n_tot_pt_min  += ((((double)i_O0400C1)*4.0) / 3.0);
	               if ( i_O0400C2 >= 1 && i_O0400C2 <= 9999 )
                        n_tot_pt_min  += ((((double)i_O0400C2)/2.0) * 4.0 / 3.0);
			  }
		 }
	}

    n_tot_rehab_min_L = n_tot_speech_min + n_tot_ot_min + n_tot_pt_min;
	n_tot_rehab_min_L += 0.00005;
	int i_result = int(n_tot_rehab_min_L * 10000.0);
    n_tot_rehab_min_L = float(i_result) / 10000.0;
	*n_tot_rehab_min = n_tot_rehab_min_L;

	char O0400A4, O0400B4, O0400C4;
	char sO0400A4[2], sO0400B4[2], sO0400C4[2];
	int iO0400A4, iO0400B4, iO0400C4;

    O0400A4 = sMdsRecord[1019];
    O0400B4 = sMdsRecord[1048];
    O0400C4 = sMdsRecord[1077];
	sO0400A4[0] = O0400A4;
	sO0400A4[1] = '\0';
	sO0400B4[0] = O0400B4;
	sO0400B4[1] = '\0';
	sO0400C4[0] = O0400C4;
	sO0400C4[1] = '\0';
    iO0400A4 = atoi( sO0400A4 );
    iO0400B4 = atoi( sO0400B4 );
    iO0400C4 = atoi( sO0400C4 );

	i_rehab_type_5days_L = 0;
	if ( iO0400A4>=5 && iO0400A4<=7 ) i_rehab_type_5days_L++;
	if ( iO0400B4>=5 && iO0400B4<=7 ) i_rehab_type_5days_L++;
	if ( iO0400C4>=5 && iO0400C4<=7 ) i_rehab_type_5days_L++;

	*i_rehab_type_5days = i_rehab_type_5days_L;

	i_rehab_type_3days_L = 0;
	if ( iO0400A4>=3 && iO0400A4<=7 ) i_rehab_type_3days_L++;
	if ( iO0400B4>=3 && iO0400B4<=7 ) i_rehab_type_3days_L++;
	if ( iO0400C4>=3 && iO0400C4<=7 ) i_rehab_type_3days_L++;

	*i_rehab_type_3days = i_rehab_type_3days_L;

	i_tot_rehab_days_L = 0;
	if ( iO0400A4>=1 && iO0400A4<=7 ) i_tot_rehab_days_L += iO0400A4;
	if ( iO0400B4>=1 && iO0400B4<=7 ) i_tot_rehab_days_L += iO0400B4;
	if ( iO0400C4>=1 && iO0400C4<=7 ) i_tot_rehab_days_L += iO0400C4;

    *i_tot_rehab_days = i_tot_rehab_days_L;

	//Assessment reference date A2300 486 - 493 YYYYMMDD
	char DATEA2300[9], YYYYA2300[5], MMA2300[3], DDA2300[3];

	//Start date of most recent Medicare stay A2400B 495 - 502 YYYYMMDD
	char DATEA2400B[9], YYYYA2400B[5], MMA2400B[3], DDA2400B[3];

	//End date of most recent Medicare stay A2400C 503 - 510 YYYYMMDD
	char DATEA2400C[9], YYYYA2400C[5], MMA2400C[3], DDA2400C[3];

	//Speech - language/audiology: start date O0400A5 1021 - 1028 YYYYMMDD
	char DATEO0400A5[9], YYYYO0400A5[5], MMO0400A5[3], DDO0400A5[3];

	//Occupational therapy: start date O0400B5 1050 - 1057 YYYYMMDD
	char DATEO0400B5[9], YYYYO0400B5[5], MMO0400B5[3], DDO0400B5[3];

	//Physical therapy: start date O0400C5 1079 - 1086 YYYYMMDD
	char DATEO0400C5[9], YYYYO0400C5[5], MMO0400C5[3], DDO0400C5[3];

	//Speech - language/audiology: end date O0400A6 1029 - 1036 YYYYMMDD
	char DATEO0400A6[9];

	//Occupational therapy: end date O0400B6 1058 - 1065 YYYYMMDD
	char DATEO0400B6[9];

	//Physical therapy: end date O0400C6 1087 - 1094 YYYYMMDD
	char DATEO0400C6[9];
	char d_rehab_start[9], d_rehab_end[9];
    int l_bad_date = 0, l_rnursing = 0, i_sev_cog_sympt = 0, i_cog_sympt = 0;

	YYYYA2300[0] = sMdsRecord[485];
	YYYYA2300[1] = sMdsRecord[486];
	YYYYA2300[2] = sMdsRecord[487];
	YYYYA2300[3] = sMdsRecord[488];
	YYYYA2300[4] = '\0';
	MMA2300[0] = sMdsRecord[489];
	MMA2300[1] = sMdsRecord[490];
	MMA2300[2] = '\0';
	DDA2300[0] = sMdsRecord[491];
	DDA2300[1] = sMdsRecord[492];
	DDA2300[2] = '\0';
    DATEA2300[0] = YYYYA2300[0];
    DATEA2300[1] = YYYYA2300[1];
    DATEA2300[2] = YYYYA2300[2];
    DATEA2300[3] = YYYYA2300[3];
    DATEA2300[4] = MMA2300[0];
    DATEA2300[5] = MMA2300[1];
    DATEA2300[6] = DDA2300[0];
    DATEA2300[7] = DDA2300[1];
    DATEA2300[8] = '\0';

	YYYYA2400B[0] = sMdsRecord[494];
	YYYYA2400B[1] = sMdsRecord[495];
	YYYYA2400B[2] = sMdsRecord[496];
	YYYYA2400B[3] = sMdsRecord[497];
	YYYYA2400B[4] = '\0';
	MMA2400B[0] = sMdsRecord[498];
	MMA2400B[1] = sMdsRecord[499];
	MMA2400B[2] = '\0';
	DDA2400B[0] = sMdsRecord[500];
	DDA2400B[1] = sMdsRecord[501];
	DDA2400B[2] = '\0';
    DATEA2400B[0] = sMdsRecord[494];
    DATEA2400B[1] = sMdsRecord[495];
    DATEA2400B[2] = sMdsRecord[496];
    DATEA2400B[3] = sMdsRecord[497];
    DATEA2400B[4] = sMdsRecord[498];
    DATEA2400B[5] = sMdsRecord[499];
    DATEA2400B[6] = sMdsRecord[500];
    DATEA2400B[7] = sMdsRecord[501];
    DATEA2400B[8] = '\0';

	YYYYA2400C[0] = sMdsRecord[502];
	YYYYA2400C[1] = sMdsRecord[503];
	YYYYA2400C[2] = sMdsRecord[504];
	YYYYA2400C[3] = sMdsRecord[505];
	YYYYA2400C[4] = '\0';
	MMA2400C[0] = sMdsRecord[506];
	MMA2400C[1] = sMdsRecord[507];
	MMA2400C[2] = '\0';
	DDA2400C[0] = sMdsRecord[508];
	DDA2400C[1] = sMdsRecord[509];
	DDA2400C[2] = '\0';
    DATEA2400C[0] = sMdsRecord[502];
    DATEA2400C[1] = sMdsRecord[503];
    DATEA2400C[2] = sMdsRecord[504];
    DATEA2400C[3] = sMdsRecord[505];
    DATEA2400C[4] = sMdsRecord[506];
    DATEA2400C[5] = sMdsRecord[507];
    DATEA2400C[6] = sMdsRecord[508];
    DATEA2400C[7] = sMdsRecord[509];
    DATEA2400C[8] = '\0';

	YYYYO0400A5[0] = sMdsRecord[1020];
	YYYYO0400A5[1] = sMdsRecord[1021];
	YYYYO0400A5[2] = sMdsRecord[1022];
	YYYYO0400A5[3] = sMdsRecord[1023];
	YYYYO0400A5[4] = '\0';
	MMO0400A5[0] = sMdsRecord[1024];
	MMO0400A5[1] = sMdsRecord[1025];
	MMO0400A5[2] = '\0';
	DDO0400A5[0] = sMdsRecord[1026];
	DDO0400A5[1] = sMdsRecord[1027];
	DDO0400A5[2] = '\0';
    DATEO0400A5[0] = YYYYO0400A5[0];
    DATEO0400A5[1] = YYYYO0400A5[1];
    DATEO0400A5[2] = YYYYO0400A5[2];
    DATEO0400A5[3] = YYYYO0400A5[3];
    DATEO0400A5[4] = MMO0400A5[0];
    DATEO0400A5[5] = MMO0400A5[1];
    DATEO0400A5[6] = DDO0400A5[0];
    DATEO0400A5[7] = DDO0400A5[1];
    DATEO0400A5[8] = '\0';

	YYYYO0400B5[0] = sMdsRecord[1049];
	YYYYO0400B5[1] = sMdsRecord[1050];
	YYYYO0400B5[2] = sMdsRecord[1051];
	YYYYO0400B5[3] = sMdsRecord[1052];
	YYYYO0400B5[4] = '\0';
	MMO0400B5[0] = sMdsRecord[1053];
	MMO0400B5[1] = sMdsRecord[1054];
	MMO0400B5[2] = '\0';
	DDO0400B5[0] = sMdsRecord[1055];
	DDO0400B5[1] = sMdsRecord[1056];
	DDO0400B5[2] = '\0';
    DATEO0400B5[0] = YYYYO0400B5[0];
    DATEO0400B5[1] = YYYYO0400B5[1];
    DATEO0400B5[2] = YYYYO0400B5[2];
    DATEO0400B5[3] = YYYYO0400B5[3];
    DATEO0400B5[4] = MMO0400B5[0];
    DATEO0400B5[5] = MMO0400B5[1];
    DATEO0400B5[6] = DDO0400B5[0];
    DATEO0400B5[7] = DDO0400B5[1];
    DATEO0400B5[8] = '\0';

	YYYYO0400C5[0] = sMdsRecord[1078];
	YYYYO0400C5[1] = sMdsRecord[1079];
	YYYYO0400C5[2] = sMdsRecord[1080];
	YYYYO0400C5[3] = sMdsRecord[1081];
	YYYYO0400C5[4] = '\0';
	MMO0400C5[0] = sMdsRecord[1082];
	MMO0400C5[1] = sMdsRecord[1083];
	MMO0400C5[2] = '\0';
	DDO0400C5[0] = sMdsRecord[1084];
	DDO0400C5[1] = sMdsRecord[1085];
	DDO0400C5[2] = '\0';
    DATEO0400C5[0] = YYYYO0400C5[0];
    DATEO0400C5[1] = YYYYO0400C5[1];
    DATEO0400C5[2] = YYYYO0400C5[2];
    DATEO0400C5[3] = YYYYO0400C5[3];
    DATEO0400C5[4] = MMO0400C5[0];
    DATEO0400C5[5] = MMO0400C5[1];
    DATEO0400C5[6] = DDO0400C5[0];
    DATEO0400C5[7] = DDO0400C5[1];
    DATEO0400C5[8] = '\0';

	l_bad_date = 0;
	if ( CheckDate(YYYYA2300, MMA2300, DDA2300) ) l_bad_date = 1;
	if ( !l_bad_date )
	{
         if ( YYYYA2400B[0] == '^' ) l_bad_date = 1;
		 else if ( CheckDate(YYYYA2400B, MMA2400B, DDA2400B) ) l_bad_date = 1;
	}
	if ( !l_bad_date )
	{
         if ( YYYYA2400C[0]=='^' || YYYYA2400C[0]=='-' ||
			  ((0==strcmp(YYYYA2400C,"----"))&&(0==strcmp(MMA2400C,"--"))&&(0==strcmp(DDA2400C,"--"))) )
			  l_bad_date = 1;
		 else if ( CheckDate(YYYYA2400C, MMA2400C, DDA2400C) ) l_bad_date = 1;
	}
    if ( !l_bad_date )
	{
		 strcpy( d_rehab_start, "20990101" );
		 if ( (YYYYO0400A5[0]=='^' || YYYYO0400A5[0]=='-') &&
              (YYYYO0400B5[0]=='^' || YYYYO0400B5[0]=='-') &&
              (YYYYO0400C5[0]=='^' || YYYYO0400C5[0]=='-') ) l_bad_date = 1;
		 else
		 {
			 if ( YYYYO0400A5[0]!='^' && YYYYO0400A5[0]!='-' )
			 {
				  if ( CheckDate(YYYYO0400A5, MMO0400A5, DDO0400A5) ) l_bad_date = 1;
				  else strcpy( d_rehab_start, DATEO0400A5 );
			 }
			 if ( YYYYO0400B5[0]!='^' && YYYYO0400B5[0]!='-' )
			 {
				  if ( CheckDate(YYYYO0400B5, MMO0400B5, DDO0400B5) ) l_bad_date = 1;
				  else if ( atoi(DATEO0400B5) < atoi(d_rehab_start) ) strcpy( d_rehab_start, DATEO0400B5 );
			 }
			 if ( YYYYO0400C5[0]!='^' && YYYYO0400C5[0]!='-' )
			 {
				  if ( CheckDate(YYYYO0400C5, MMO0400C5, DDO0400C5) ) l_bad_date = 1;
				  else if ( atoi(DATEO0400C5) < atoi(d_rehab_start) ) strcpy( d_rehab_start, DATEO0400C5 );
			 }
			 if ( 0==strcmp(d_rehab_start, "20990101") ) l_bad_date = 1;
		 }
	}

    DATEO0400A6[0] = sMdsRecord[1028];
    DATEO0400A6[1] = sMdsRecord[1029];
    DATEO0400A6[2] = sMdsRecord[1030];
    DATEO0400A6[3] = sMdsRecord[1031];
    DATEO0400A6[4] = sMdsRecord[1032];
    DATEO0400A6[5] = sMdsRecord[1033];
    DATEO0400A6[6] = sMdsRecord[1034];
    DATEO0400A6[7] = sMdsRecord[1035];
    DATEO0400A6[8] = '\0';
    DATEO0400B6[0] = sMdsRecord[1057];
    DATEO0400B6[1] = sMdsRecord[1058];
    DATEO0400B6[2] = sMdsRecord[1059];
    DATEO0400B6[3] = sMdsRecord[1060];
    DATEO0400B6[4] = sMdsRecord[1061];
    DATEO0400B6[5] = sMdsRecord[1062];
    DATEO0400B6[6] = sMdsRecord[1063];
    DATEO0400B6[7] = sMdsRecord[1064];
    DATEO0400B6[8] = '\0';
    DATEO0400C6[0] = sMdsRecord[1086];
    DATEO0400C6[1] = sMdsRecord[1087];
    DATEO0400C6[2] = sMdsRecord[1088];
    DATEO0400C6[3] = sMdsRecord[1089];
    DATEO0400C6[4] = sMdsRecord[1090];
    DATEO0400C6[5] = sMdsRecord[1091];
    DATEO0400C6[6] = sMdsRecord[1092];
    DATEO0400C6[7] = sMdsRecord[1093];
    DATEO0400C6[8] = '\0';
	if ( 0==strcmp(DATEO0400A6, "--------" ) ) strcpy( DATEO0400A6, DATEA2300 );
	if ( 0==strcmp(DATEO0400B6, "--------" ) ) strcpy( DATEO0400B6, DATEA2300 );
	if ( 0==strcmp(DATEO0400C6, "--------" ) ) strcpy( DATEO0400C6, DATEA2300 );
    if ( !l_bad_date )
	{
		 strcpy( d_rehab_end, "20000101" );
		 if ( (DATEO0400A6[0]=='^' || DATEO0400A6[0]=='-') &&
			  (DATEO0400B6[0]=='^' || DATEO0400B6[0]=='-') &&
			  (DATEO0400C6[0]=='^' || DATEO0400C6[0]=='-') ) l_bad_date = 1;
		 else
		 {
			 if ( DATEO0400A6[0]!='^' && DATEO0400A6[0]!='-' )
			 {
				  if ( CheckYYYYMMDD( DATEO0400A6 ) ) l_bad_date = 1;
				  else strcpy( d_rehab_end, DATEO0400A6 );
			 }
			 if ( DATEO0400B6[0]!='^' && DATEO0400B6[0]!='-' )
			 {
				  if ( CheckYYYYMMDD( DATEO0400B6 ) ) l_bad_date = 1;
				  else if ( atoi(DATEO0400B6) > atoi(d_rehab_end) )
					        strcpy( d_rehab_end, DATEO0400B6 );
			 }
			 if ( DATEO0400C6[0]!='^' && DATEO0400C6[0]!='-' )
			 {
				  if ( CheckYYYYMMDD( DATEO0400C6 ) ) l_bad_date = 1;
				  else if ( atoi(DATEO0400C6) > atoi(d_rehab_end) )
					        strcpy( d_rehab_end, DATEO0400C6 );
			 }
			 if ( 0==strcmp( d_rehab_end, "20000101" ) ) l_bad_date = 1;
		 }
	}

	l_Mcare_short_stay_L = 0;
	// add 0==strcmp("MCAR2", sRehabType) for V1.01.1
/* V1.03.0 changed */
// V1.04 change here for A0310C
    if (a2300 < 20191001)
	{
		if ( (l_bad_date==0) && (0==strcmp("MCARE", sRehabType)|| 0==strcmp("MCAR2", sRehabType)||0==strcmp("MCAR3", sRehabType)) &&
			 (A0310C=='1') && (daysBetweenTwodates(DATEA2300,DATEA2400B)<=7) &&
			 (0==strcmp(DATEA2300,DATEA2400C)) && (daysBetweenTwodates(DATEA2400C,d_rehab_start)<=3) &&
			 (0==strcmp(DATEA2400C,d_rehab_end)) ) l_Mcare_short_stay_L = 1;
	}
	else
	{
		if ( (l_bad_date==0) && (0==strcmp("MCARE", sRehabType)|| 0==strcmp("MCAR2", sRehabType)||0==strcmp("MCAR3", sRehabType)) &&
		 (A0300A[0]=='1') && (A0300B[0]=='1') && (daysBetweenTwodates(DATEA2300,DATEA2400B)<=7) &&
		 (0==strcmp(DATEA2300,DATEA2400C)) && (daysBetweenTwodates(DATEA2400C,d_rehab_start)<=3) &&
		 (0==strcmp(DATEA2400C,d_rehab_end)) ) l_Mcare_short_stay_L = 1;
	}

	*l_Mcare_short_stay = l_Mcare_short_stay_L;

    if ( l_Mcare_short_stay_L )
		  n_avg_rehab_min_L = (n_tot_rehab_min_L) / (daysBetweenTwodates(DATEA2300,d_rehab_start)+1) ;
    *n_avg_rehab_min = n_avg_rehab_min_L;

 	//PHQ res: total mood severity score D0300 562 - 563
	char D0300[3];
    int iD0300;

	D0300[0] = sMdsRecord[561];
	D0300[1] = sMdsRecord[562];
	D0300[2] = '\0';
    iD0300 = atoi( D0300 );

	//PHQ staff: total mood score D0600 585 - 586
	char D0600[3];
    int iD0600;

	D0600[0] = sMdsRecord[584];
	D0600[1] = sMdsRecord[585];
	D0600[2] = '\0';
    iD0600 = atoi( D0600 );

    if ( iD0300>=10 && iD0300<=27 ) l_depression_L = 1;
    if ( iD0600>=10 && iD0600<=30 ) l_depression_L = 1;

	*l_depression = l_depression_L;

    //Urinary toileting program: current program/trial H0200C 689 - 689
	char H0200C;
    H0200C = sMdsRecord[688];

    //Bowel toileting program being used H0500 692 - 692
	char H0500;
    H0500 = sMdsRecord[691];

    //O0500A[1110,1110], O0500B[1111,1111], O0500C[1112,1112], O0500D[1113,1113],
    //O0500E[1114,1114], O0500F[1115,1115], O0500G[1116,1116], O0500H[1117,1117],
    //O0500I[1118,1118], O0500J[1119,1119]
	char O0500A, O0500B, O0500C, O0500D, O0500E, O0500F, O0500G, O0500H, O0500I, O0500J;
    O0500A = sMdsRecord[1109];
    O0500B = sMdsRecord[1110];
    O0500C = sMdsRecord[1111];
    O0500D = sMdsRecord[1112];
    O0500E = sMdsRecord[1113];
    O0500F = sMdsRecord[1114];
    O0500G = sMdsRecord[1115];
    O0500H = sMdsRecord[1116];
    O0500I = sMdsRecord[1117];
    O0500J = sMdsRecord[1118];

    if ( H0200C=='1' || H0500=='1' ) i_rnursing_cnt_L++;
    if ( O0500A=='6' || O0500A=='7' || O0500B=='6' || O0500B=='7' ) i_rnursing_cnt_L++;
    if ( O0500C=='6' || O0500C=='7' ) i_rnursing_cnt_L++;
    if ( O0500D=='6' || O0500D=='7' || O0500F=='6' || O0500F=='7' ) i_rnursing_cnt_L++;
    if ( O0500E=='6' || O0500E=='7' ) i_rnursing_cnt_L++;
    if ( O0500G=='6' || O0500G=='7' ) i_rnursing_cnt_L++;
    if ( O0500H=='6' || O0500H=='7' ) i_rnursing_cnt_L++;
    if ( O0500I=='6' || O0500I=='7' ) i_rnursing_cnt_L++;
    if ( O0500J=='6' || O0500J=='7' ) i_rnursing_cnt_L++;

    *i_rnursing_cnt = i_rnursing_cnt_L;

    if ( i_rnursing_cnt_L >= 2 ) l_rnursing = 1;

    //O0100E2[978,978], O0100F2[980,980], O0100M2[993,993]
	char O0100E2, O0100F2, O0100M2;

	O0100E2 = sMdsRecord[977];
	O0100F2 = sMdsRecord[979];
	O0100M2 = sMdsRecord[992];

    if ( O0100E2=='1' && O0100F2=='1' ) i_ext_serv_level_L = 3;
    else if ( O0100E2=='1' || O0100F2=='1' ) i_ext_serv_level_L = 2;
    else if ( O0100M2 == '1' ) i_ext_serv_level_L = 1;

    *i_ext_serv_level = i_ext_serv_level_L;

    l_ext_serv_L = 0;
	if ( i_ext_serv_level_L>=1 && i_adl_tot_L>=2 ) l_ext_serv_L = 1;

    *l_ext_serv = l_ext_serv_L;

    l_rehab_ultra_L = 0;
	if ( n_tot_rehab_min_L>=720 && i_rehab_type_5days_L>=1 && i_rehab_type_3days_L>=2 )
		 l_rehab_ultra_L = 1;
	else if ( l_Mcare_short_stay_L && n_avg_rehab_min_L>=144 )
		 l_rehab_ultra_L = 1;
    *l_rehab_ultra = l_rehab_ultra_L;

    l_rehab_very_L = 0;
	if ( n_tot_rehab_min_L>=500 && i_rehab_type_5days_L>=1 ) l_rehab_very_L = 1;
	else if ( l_Mcare_short_stay_L && n_avg_rehab_min_L>=100 ) l_rehab_very_L = 1;
    *l_rehab_very = l_rehab_very_L;

    l_rehab_high_L = 0;
	if ( n_tot_rehab_min_L>=325 && i_rehab_type_5days_L>=1 ) l_rehab_high_L = 1;
	else if ( l_Mcare_short_stay_L && n_avg_rehab_min_L>=65 ) l_rehab_high_L = 1;
    *l_rehab_high = l_rehab_high_L;

    char O0420[2];
	O0420[0] = sMdsRecord[1483];
	O0420[1] = '\0';
	int i_O042_L = atoi(O0420);

    l_rehab_medium_L = 0;
/* V1.03.0 changed */
	if ( (0==strcmp("MCARE", sRehabType)|| 0==strcmp("MCAR2", sRehabType)||0==strcmp("OTHER", sRehabType)) &&
		n_tot_rehab_min_L>=150 && i_tot_rehab_days_L>=5 ) l_rehab_medium_L = 1;
	else if ( 0==strcmp("MCAR3", sRehabType)&& n_tot_rehab_min_L>=150 && i_O042_L >= 5 ) l_rehab_medium_L = 1;
	else if ( l_Mcare_short_stay_L && n_avg_rehab_min_L>=30 ) l_rehab_medium_L = 1;
    *l_rehab_medium = l_rehab_medium_L;

    l_rehab_low_L = 0;
/* V1.03.0 changed */
	if ( (0==strcmp("MCARE", sRehabType)|| 0==strcmp("MCAR2", sRehabType)||0==strcmp("OTHER", sRehabType)) &&
		  n_tot_rehab_min_L>=45 && i_tot_rehab_days_L>=3 && i_rnursing_cnt_L>=2 ) l_rehab_low_L = 1;
	else if ( 0==strcmp("MCAR3", sRehabType) && n_tot_rehab_min_L>=45 && i_O042_L >= 3 && i_rnursing_cnt_L >= 2 ) l_rehab_low_L = 1;
	else if ( l_Mcare_short_stay_L && n_avg_rehab_min_L>=15 )
		 l_rehab_low_L = 1;
    *l_rehab_low = l_rehab_low_L;

    //B0100[511,511], G0110I1[662,662]
    //I2100[712,712], I2900[717,717], N0350A[959,959], N0350B[960,960], I5100[733,733]
	//I6200[747,747], J1100C[851,851], J1550A[855,855], I2000[711,711], J1550B[856,856]
	//K0300[877,877], K0500A[878,878], K0500B[879,879], K0700A[883,883], K0700B[884,884], O0400D2[1099,1099]
	char B0100, I2100, I2900, N0350A, N0350B, I5100, I6200;
	char J1100C, J1550A, I2000, J1550B, K0300, K0500A, K0500B, K0700A, K0700B, O0400D2, K0710A3, K0710B3;

	B0100 = sMdsRecord[510];
	G0110I1 = sMdsRecord[661];
	I2100 = sMdsRecord[711];
	I2900 = sMdsRecord[716];
	N0350A = sMdsRecord[958];
	N0350B = sMdsRecord[959];
	I5100 = sMdsRecord[732];
	I6200 = sMdsRecord[746];
	J1100C = sMdsRecord[850];
	J1550A = sMdsRecord[854];
	I2000 = sMdsRecord[710];
	J1550B = sMdsRecord[855];
	K0300 = sMdsRecord[876];
	K0500A = sMdsRecord[877];
	K0500B = sMdsRecord[878];
	K0700A = sMdsRecord[882];
	K0700B = sMdsRecord[883];
	K0710A3 = sMdsRecord[1467];
	K0710B3 = sMdsRecord[1470];
	O0400D2 = sMdsRecord[1098];

	l_spec_high_cond_L = 0;
    if ( B0100=='1' && (G0110A1=='4'||G0110A1=='8') && (G0110B1=='4'||G0110B1=='8') &&
		 (G0110H1=='4'||G0110H1=='8') && (G0110I1=='4'||G0110I1=='8') ) l_spec_high_cond_L = 1;
    if ( I2100 == '1' ) l_spec_high_cond_L = 1;
    if ( I2900=='1' && N0350A=='7' && N0350B>='2' ) l_spec_high_cond_L = 1;
    if ( I5100=='1' && i_adl_tot_L>=5 ) l_spec_high_cond_L = 1;
    if ( I6200=='1' && J1100C=='1' ) l_spec_high_cond_L = 1;

/*
    if ( J1550A=='1'&&
		   (I2000=='1' || J1550B=='1' || (K0300=='1'|| K0300=='2') || (K0500B=='1' && K0700A=='3') ||
		   (K0500B=='1' && K0700A=='2' && K0700B=='2')) ) l_spec_high_cond_L = 1;
    if ( K0500A == '1' ) l_spec_high_cond_L = 1;
*/
// begin changed with version 1.02.0
	//char A2300[9];
	char K0510A1, K0510A2, K0510B1, K0510B2;
	//long a2300;

    A2300[0] = sMdsRecord[485];
    A2300[1] = sMdsRecord[486];
    A2300[2] = sMdsRecord[487];
    A2300[3] = sMdsRecord[488];
    A2300[4] = sMdsRecord[489];
    A2300[5] = sMdsRecord[490];
    A2300[6] = sMdsRecord[491];
    A2300[7] = sMdsRecord[492];
    A2300[8] = '\0';
	K0510A1 = sMdsRecord[1443];
	K0510A2 = sMdsRecord[1444];
	K0510B1 = sMdsRecord[1445];
	K0510B2 = sMdsRecord[1446];
	a2300 = atol(A2300);

if ( (J1550A=='1') &&
		  ( (I2000=='1') ||
            (J1550B=='1') ||
            (K0300=='1'|| K0300=='2') ||
            ((a2300 < 20120401) &&
		     ((K0500B == '1' && K0700A == '3') ||
			 (K0500B == '1' && K0700A == '2' && K0700B == '2'))) ||
            ((a2300 >= 20120401 && a2300 < 20131001) &&
			(((K0510B1 == '1' || K0510B2 == '1') && K0700A == '3') ||
              ((K0510B1 == '1' || K0510B2 == '1') &&
                   (K0700A == '2'&& K0700B == '2')))) ||
             ((a2300 >= 20131001) &&
                 (((K0510B1 == '1' || K0510B2 == '1') && K0710A3 == '3') ||
			  ((K0510B1 == '1' || K0510B2 == '1') &&
			  (K0710A3 == '2'&& K0710B3 == '2'))))))
          l_spec_high_cond_L = 1;

	if ( (a2300 < 20120401) && (K0500A=='1') ) l_spec_high_cond_L = 1;

	if ( (a2300 >= 20120401) && ((K0510A1=='1') || (K0510A2=='1')) )  l_spec_high_cond_L = 1;
// end changed with version 1.02.0

	if ( O0400D2 == '7' ) l_spec_high_cond_L = 1;

	l_special_high_L = 0;
	if ( l_spec_high_cond_L==1 && i_adl_tot_L>=2 ) l_special_high_L = 1;

	*l_spec_high_cond = l_spec_high_cond_L;
	*l_special_high = l_special_high_L;

	//M1200A[948,948], M1200B[949,949], M1200C[950,950], M1200D[951,951], M1200E[952,952],
	//M1200G[954,954], M1200H[955,955]
	char M1200A, M1200B, M1200C, M1200D, M1200E, M1200G, M1200H;

	M1200A = sMdsRecord[947];
	M1200B = sMdsRecord[948];
	M1200C = sMdsRecord[949];
	M1200D = sMdsRecord[950];
	M1200E = sMdsRecord[951];
	M1200G = sMdsRecord[953];
	M1200H = sMdsRecord[954];

	i_sl_skin_tx_cnt = 0;
	if ( M1200A=='1' || M1200B=='1' ) i_sl_skin_tx_cnt++;
	if ( M1200C == '1' ) i_sl_skin_tx_cnt++;
	if ( M1200D == '1' ) i_sl_skin_tx_cnt++;
	if ( M1200E == '1' ) i_sl_skin_tx_cnt++;
	if ( M1200G == '1' ) i_sl_skin_tx_cnt++;
	if ( M1200H == '1' ) i_sl_skin_tx_cnt++;

	//I4400[728,728], I5200[734,734], I5300[736,736], I6300[748,748], O0100C2[974,974],
	//M0300B1[900,900], M0300C1[910,910], M0300D1[912,912], M0300F1[916,916], M1030[940,940],
    //M1040A[941,941], M1040B[942,942], M1040C[943,943], M1200I[956,956], O0100B2[972,972],
	//O0100J2[988,988],
    char I4400, I5200, I5300, I6300, O0100C2, M0300B1, M0300C1, M0300D1, M0300F1;
	char M1030, M1040A, M1040B, M1040C, M1200I, O0100B2, O0100J2;

    I4400 = sMdsRecord[727];
	I5200 = sMdsRecord[733];
	I5300 = sMdsRecord[735];
	I6300 = sMdsRecord[747];
	O0100C2 = sMdsRecord[973];
	M0300B1 = sMdsRecord[899];
	M0300C1 = sMdsRecord[909];
	M0300D1 = sMdsRecord[911];
	M0300F1 = sMdsRecord[915];
	M1030 = sMdsRecord[939];
	M1040A = sMdsRecord[940];
	M1040B = sMdsRecord[941];
	M1040C = sMdsRecord[942];
	M1200I = sMdsRecord[955];
	O0100B2 = sMdsRecord[971];
	O0100J2 = sMdsRecord[987];

    l_spec_low_cond_L = 0;
    if ( I4400=='1' && i_adl_tot_L>=5 ) l_spec_low_cond_L = 1;
    if ( I5200=='1' && i_adl_tot_L>=5 ) l_spec_low_cond_L = 1;
    if ( I5300=='1' && i_adl_tot_L>=5 ) l_spec_low_cond_L = 1;
    if ( I6300=='1' && O0100C2=='1' ) l_spec_low_cond_L = 1;

// begin changed with version 1.02.0
/* V1.03.0 changed */
    if ( ((a2300 < 20120401 ) &&
		 ((K0500B=='1' && K0700A=='3') ||
		  (K0500B=='1' && K0700A=='2' && K0700B=='2'))) ||
		  ((a2300 >= 20120401 && a2300 < 20131001) &&
		    (((K0510B1=='1' || K0510B2=='1') && K0700A=='3') ||
			((K0510B1=='1' || K0510B2=='1') && (K0700A=='2' && K0700B=='2')))) ||
		  ((a2300 >= 20131001) &&
		    (((K0510B1=='1' || K0510B2=='1') && K0710A3=='3') ||
			((K0510B1=='1' || K0510B2=='1') && (K0710A3=='2' && K0710B3=='2')))) )

		 l_spec_low_cond_L = 1;
// end changed with version 1.02.0

    if ( (M0300B1>='2' && M0300B1<='9') && i_sl_skin_tx_cnt>=2 ) l_spec_low_cond_L = 1;
	if ( ((M0300C1>='1' && M0300C1<='9') || (M0300D1>='1' && M0300D1<='9') ||
          (M0300F1>='1' && M0300F1<='9')) && i_sl_skin_tx_cnt>=2 ) l_spec_low_cond_L = 1;
    if ( (M1030>='2' && M1030<='9') && i_sl_skin_tx_cnt>=2 ) l_spec_low_cond_L = 1;
    if ( (M0300B1=='1' && M1030=='1') && i_sl_skin_tx_cnt>=2 ) l_spec_low_cond_L = 1;
	if ( (M1040A=='1' || M1040B=='1' || M1040C=='1') && M1200I=='1' ) l_spec_low_cond_L = 1;
	if ( O0100B2 == '1' ) l_spec_low_cond_L = 1;
	if ( O0100J2 == '1' ) l_spec_low_cond_L = 1;

	l_special_low_L = 0;
	if ( l_spec_low_cond_L==1 && i_adl_tot_L>=2 ) l_special_low_L = 1;

	*l_spec_low_cond = l_spec_low_cond_L;
	*l_special_low = l_special_low_L;

	//M1200F[953,953], I4900[731,731], M1040E[945,945], M1040D[944,944],
	//M1040F[946,946], O0100A2[970,970], O0100H2[984,984],O0100I2[986,986],
	char M1200F, I4900, M1040E, M1040D, M1040F, O0100A2;
	char O0100H2,O0100I2;

    M1200F = sMdsRecord[952];
	I4900 = sMdsRecord[730];
	M1040E = sMdsRecord[944];
	M1040D = sMdsRecord[943];
	M1040F = sMdsRecord[945];
	O0100A2 = sMdsRecord[969];
	O0100H2 = sMdsRecord[983];
	O0100I2 = sMdsRecord[985];

	i_cc_skin_tx_cnt = 0;
	if ( M1200F == '1' ) i_cc_skin_tx_cnt++;
	if ( M1200G == '1' ) i_cc_skin_tx_cnt++;
	if ( M1200H == '1' ) i_cc_skin_tx_cnt++;

	l_clin_complex_L = 0;
	if ( I2000 == '1' ) l_clin_complex_L = 1;
	if ( I4900=='1' && i_adl_tot_L>=5 ) l_clin_complex_L = 1;
    if ( (M1040E=='1' || M1040D=='1') && i_cc_skin_tx_cnt>=1 ) l_clin_complex_L = 1;
	if ( M1040F == '1' ) l_clin_complex_L = 1;
	if ( O0100A2 == '1' ) l_clin_complex_L = 1;
	if ( O0100C2 == '1' ) l_clin_complex_L = 1;
	if ( O0100H2 == '1' ) l_clin_complex_L = 1;
	if ( O0100I2 == '1' ) l_clin_complex_L = 1;
	if ( i_ext_serv_level_L>=1 && i_adl_tot_L<=1 ) l_clin_complex_L = 1;
	if ( l_spec_high_cond_L==1 && i_adl_tot_L<=1 ) l_clin_complex_L = 1;
	if ( l_spec_low_cond_L==1 && i_adl_tot_L<=1 ) l_clin_complex_L = 1;
    *l_clin_complex = l_clin_complex_L;

	//C0500[527,528], C1000[537,537], B0700[515,515], C0700[530,530]
	char C0500[3], C1000, B0700, C0700;
	int iC0500;

	C0500[0] = sMdsRecord[526];
	C0500[1] = sMdsRecord[527];
	C0500[2] = '\0';
	C1000 = sMdsRecord[536];
	B0700 = sMdsRecord[514];
	C0700 = sMdsRecord[529];

	l_cog_impair_L = 0;

	if ( C0500[0]=='^' || (C0500[0]=='9' && C0500[1]=='9') || C0500[0] =='-' )
	{
		if ( B0100=='1' && (G0110A1=='4' || G0110A1=='8') && (G0110B1=='4' || G0110B1=='8') &&
             (G0110H1=='4' || G0110H1=='8') && (G0110I1=='4' || G0110I1=='8') ) l_cog_impair_L = 1;
		else if ( C1000 == '3' ) l_cog_impair_L = 1;
		else
		{
			i_cog_sympt = 0;
			if ( B0700>'0' && B0700<='3') i_cog_sympt++;
			if ( C0700 == '1' ) i_cog_sympt++;
			if ( C1000>'0' && C1000<='3') i_cog_sympt++;
			i_sev_cog_sympt = 0;
			if ( B0700>='2' && B0700<='3') i_sev_cog_sympt++;
			if ( C1000>='2' && C1000<='3') i_sev_cog_sympt++;
            if ( i_cog_sympt>=2 && i_sev_cog_sympt>=1 ) l_cog_impair_L = 1;
		}
	}
	else if ( isdigit(C0500[0]) && isdigit(C0500[1]) ) {
         iC0500 = atoi( C0500 );
		 if ( iC0500>=0 && iC0500<=9 ) l_cog_impair_L = 1;
	}

    //E0100A[588,588], E0100B[589,589], E0200A[591,591], E0200B[592,592], E0200C[593,593]
	//E0800[601,601], E0900[602,602]
    char E0100A, E0100B, E0200A, E0200B, E0200C, E0800, E0900;

	E0100A = sMdsRecord[587];
	E0100B = sMdsRecord[588];
	E0200A = sMdsRecord[590];
	E0200B = sMdsRecord[591];
	E0200C = sMdsRecord[592];
	E0800 = sMdsRecord[600];
	E0900 = sMdsRecord[601];

	l_beh_sympt_L = 0;
    if ( E0100A == '1' ) l_beh_sympt_L = 1;
    if ( E0100B == '1' ) l_beh_sympt_L = 1;
    if ( E0200A>='2' && E0200A<='3' ) l_beh_sympt_L = 1;
    if ( E0200B>='2' && E0200B<='3' ) l_beh_sympt_L = 1;
    if ( E0200C>='2' && E0200C<='3' ) l_beh_sympt_L = 1;
    if ( E0800>='2' && E0800<='3' ) l_beh_sympt_L = 1;
    if ( E0900>='2' && E0900<='3' ) l_beh_sympt_L = 1;

    l_beh_cog_L = 0;
	if ( i_adl_tot_L<=5 && (l_cog_impair_L==1 || l_beh_sympt_L==1) ) l_beh_cog_L = 1;

    *l_cog_impair = l_cog_impair_L;
	*l_beh_sympt = l_beh_sympt_L;
	*l_beh_cog = l_beh_cog_L;

    *nCmiValueMax = -9999;
    *nCmiValueMax_NT = -9999;

	if ( 0 == strcmp( sModel, "66" ) )
	{
       if ( l_rehab_ultra_L && l_ext_serv_L )
	   {
          if ( i_adl_tot_L>=11 && i_adl_tot_L<=16 )
             GetRug( 1, "RUX", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		  else if ( i_adl_tot_L>=2 && i_adl_tot_L<=10 )
             GetRug( 2, "RUL", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
	   }
       if ( l_rehab_very_L && l_ext_serv_L )
	   {
		   if ( i_adl_tot_L>=11 && i_adl_tot_L<=16 )
             GetRug( 3, "RVX", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=2 && i_adl_tot_L<=10 )
             GetRug( 4, "RVL", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
	   }
       if ( l_rehab_high_L && l_ext_serv_L )
	   {
		   if ( i_adl_tot_L>=11 && i_adl_tot_L<=16 )
             GetRug( 5, "RHX", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=2 && i_adl_tot_L<=10 )
             GetRug( 6, "RHL", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
	   }
       if ( l_rehab_medium_L && l_ext_serv_L )
	   {
		   if ( i_adl_tot_L>=11 && i_adl_tot_L<=16 )
             GetRug( 7, "RMX", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=2 && i_adl_tot_L<=10 )
             GetRug( 8, "RML", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
	   }
       if ( l_rehab_low_L && l_ext_serv_L )
	   {
		   if ( i_adl_tot_L>=2 && i_adl_tot_L<=16 )
             GetRug( 9, "RLX", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
	   }
	}

	if ( (0==strcmp(sModel, "66")) || (0==strcmp(sModel, "57")) )
	{
		if ( l_rehab_ultra_L == 1 )
		{
		   if ( i_adl_tot_L>=11 && i_adl_tot_L<=16 )
             GetRug( 10, "RUC", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=6 && i_adl_tot_L<=10 )
             GetRug( 11, "RUB", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=0 && i_adl_tot_L<=5 )
             GetRug( 12, "RUA", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		}
		if ( l_rehab_very_L == 1 )
		{
		   if ( i_adl_tot_L>=11 && i_adl_tot_L<=16 )
             GetRug( 13, "RVC", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=6 && i_adl_tot_L<=10 )
             GetRug( 14, "RVB", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=0 && i_adl_tot_L<=5 )
             GetRug( 15, "RVA", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		}
		if ( l_rehab_high_L == 1 )
		{
		   if ( i_adl_tot_L>=11 && i_adl_tot_L<=16 )
             GetRug( 16, "RHC", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=6 && i_adl_tot_L<=10 )
             GetRug( 17, "RHB", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=0 && i_adl_tot_L<=5 )
             GetRug( 18, "RHA", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		}
		if ( l_rehab_medium_L == 1 )
		{
		   if ( i_adl_tot_L>=11 && i_adl_tot_L<=16 )
             GetRug( 19, "RMC", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=6 && i_adl_tot_L<=10 )
             GetRug( 20, "RMB", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=0 && i_adl_tot_L<=5 )
             GetRug( 21, "RMA", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		}
		if ( l_rehab_low_L == 1 )
		{
		   if ( i_adl_tot_L>=11 && i_adl_tot_L<=16 )
             GetRug( 22, "RLB", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=0 && i_adl_tot_L<=10 )
             GetRug( 23, "RLA", nCmiArray, nCmiValueHier, nCmiValueMax,
				     sRugHier, nRugHier, sRugMax, nRugMax );
		}
	}
	if ( l_ext_serv_L )
	{
       if ( i_ext_serv_level_L == 3 )
	   {
          GetRug( 24, "ES3", nCmiArray, nCmiValueHier, nCmiValueMax,
				  sRugHier, nRugHier, sRugMax, nRugMax );
          GetRug_NT( 24, "ES3", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			         sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
	   }
	   else if ( i_ext_serv_level_L == 2 )
	   {
          GetRug( 25, "ES2", nCmiArray, nCmiValueHier, nCmiValueMax,
				  sRugHier, nRugHier, sRugMax, nRugMax );
          GetRug_NT( 25, "ES2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			         sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
	   }
	   else if ( i_ext_serv_level_L == 1 )
	   {
          GetRug( 26, "ES1", nCmiArray, nCmiValueHier, nCmiValueMax,
				  sRugHier, nRugHier, sRugMax, nRugMax );
          GetRug_NT( 26, "ES1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			         sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
	   }
	}

	if ( 0 == strcmp( sModel, "48" ) )
	{
	   if ( l_rehab_ultra_L==1 || l_rehab_very_L==1 || l_rehab_high_L==1 ||
		    l_rehab_medium_L==1 || l_rehab_low_L==1 )
	   {
		   if ( i_adl_tot_L>=15 && i_adl_tot_L<=16 )
                GetRug( 27, "RAE", nCmiArray, nCmiValueHier, nCmiValueMax,
				        sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=11 && i_adl_tot_L<=14 )
                GetRug( 28, "RAD", nCmiArray, nCmiValueHier, nCmiValueMax,
				        sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=6 && i_adl_tot_L<=10 )
                GetRug( 29, "RAC", nCmiArray, nCmiValueHier, nCmiValueMax,
				        sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=2 && i_adl_tot_L<=5 )
                GetRug( 30, "RAB", nCmiArray, nCmiValueHier, nCmiValueMax,
				        sRugHier, nRugHier, sRugMax, nRugMax );
		   else if ( i_adl_tot_L>=0 && i_adl_tot_L<=1 )
                GetRug( 31, "RAA", nCmiArray, nCmiValueHier, nCmiValueMax,
				        sRugHier, nRugHier, sRugMax, nRugMax );
	   }
	}
	if ( l_special_high_L )
	{
	   if ( i_adl_tot_L>=15 && i_adl_tot_L<=16 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 32, "HE2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 32, "HE2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 33, "HE1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 33, "HE1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	   else if ( i_adl_tot_L>=11 && i_adl_tot_L<=14 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 34, "HD2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 34, "HD2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 35, "HD1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 35, "HD1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	   else if ( i_adl_tot_L>=6 && i_adl_tot_L<=10 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 36, "HC2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 36, "HC2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 37, "HC1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 37, "HC1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	   else if ( i_adl_tot_L>=2 && i_adl_tot_L<=5 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 38, "HB2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 38, "HB2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 39, "HB1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 39, "HB1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	  }
	}
	if ( l_special_low_L )
	{
	   if ( i_adl_tot_L>=15 && i_adl_tot_L<=16 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 40, "LE2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 40, "LE2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 41, "LE1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 41, "LE1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	   else if ( i_adl_tot_L>=11 && i_adl_tot_L<=14 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 42, "LD2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 42, "LD2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 43, "LD1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 43, "LD1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	   else if ( i_adl_tot_L>=6 && i_adl_tot_L<=10 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 44, "LC2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 44, "LC2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 45, "LC1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 45, "LC1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	   else if ( i_adl_tot_L>=2 && i_adl_tot_L<=5 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 46, "LB2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 46, "LB2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 47, "LB1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 47, "LB1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	  }
	}

	if ( l_clin_complex_L==1 || (i_ext_serv_level_L>=1 && i_adl_tot_L<=1) ||
		 (l_spec_high_cond_L==1 && i_adl_tot_L<=1) || (l_spec_low_cond_L==1 && i_adl_tot_L<=1) )
	{
	   if ( i_adl_tot_L>=15 && i_adl_tot_L<=16 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 48, "CE2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 48, "CE2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 49, "CE1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 49, "CE1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	   else if ( i_adl_tot_L>=11 && i_adl_tot_L<=14 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 50, "CD2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 50, "CD2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 51, "CD1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 51, "CD1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	   else if ( i_adl_tot_L>=6 && i_adl_tot_L<=10 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 52, "CC2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 52, "CC2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 53, "CC1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 53, "CC1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	   else if ( i_adl_tot_L>=2 && i_adl_tot_L<=5 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 54, "CB2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 54, "CB2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 55, "CB1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 55, "CB1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	   else if ( i_adl_tot_L>=0 && i_adl_tot_L<=1 )
	   {
	      if ( l_depression_L )
		  {
               GetRug( 56, "CA2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 56, "CA2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 57, "CA1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 57, "CA1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	}
	if ( l_beh_cog_L == 1 )
	{
	   if ( i_adl_tot_L>=2 && i_adl_tot_L<=5 )
	   {
	      if ( l_rnursing )
		  {
               GetRug( 58, "BB2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 58, "BB2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 59, "BB1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 59, "BB1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
	   else if ( i_adl_tot_L>=0 && i_adl_tot_L<=1 )
	   {
	      if ( l_rnursing )
		  {
               GetRug( 60, "BA2", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 60, "BA2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
		  else
		  {
               GetRug( 61, "BA1", nCmiArray, nCmiValueHier, nCmiValueMax,
				       sRugHier, nRugHier, sRugMax, nRugMax );
               GetRug_NT( 61, "BA1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			              sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		  }
	   }
    }
    if ( i_adl_tot_L>=15 && i_adl_tot_L<=16 )
	{
	    if ( l_rnursing )
		{
             GetRug( 62, "PE2", nCmiArray, nCmiValueHier, nCmiValueMax,
		             sRugHier, nRugHier, sRugMax, nRugMax );
             GetRug_NT( 62, "PE2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			            sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		}
		else
		{
             GetRug( 63, "PE1", nCmiArray, nCmiValueHier, nCmiValueMax,
			         sRugHier, nRugHier, sRugMax, nRugMax );
             GetRug_NT( 63, "PE1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			            sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		}
    }
	else if ( i_adl_tot_L>=11 && i_adl_tot_L<=14 )
	{
	    if ( l_rnursing )
		{
             GetRug( 64, "PD2", nCmiArray, nCmiValueHier, nCmiValueMax,
			         sRugHier, nRugHier, sRugMax, nRugMax );
             GetRug_NT( 64, "PD2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			            sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		}
		else
		{
             GetRug( 65, "PD1", nCmiArray, nCmiValueHier, nCmiValueMax,
			         sRugHier, nRugHier, sRugMax, nRugMax );
             GetRug_NT( 65, "PD1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			            sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		}
    }
	else if ( i_adl_tot_L>=6 && i_adl_tot_L<=10 )
	{
	    if ( l_rnursing )
		{
             GetRug( 66, "PC2", nCmiArray, nCmiValueHier, nCmiValueMax,
			         sRugHier, nRugHier, sRugMax, nRugMax );
             GetRug_NT( 66, "PC2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			            sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		}
		else
		{
             GetRug( 67, "PC1", nCmiArray, nCmiValueHier, nCmiValueMax,
			         sRugHier, nRugHier, sRugMax, nRugMax );
             GetRug_NT( 67, "PC1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			            sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		}
    }
	else if ( i_adl_tot_L>=2 && i_adl_tot_L<=5 )
	{
	    if ( l_rnursing )
		{
             GetRug( 68, "PB2", nCmiArray, nCmiValueHier, nCmiValueMax,
			         sRugHier, nRugHier, sRugMax, nRugMax );
             GetRug_NT( 68, "PB2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			            sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		}
		else
		{
             GetRug( 69, "PB1", nCmiArray, nCmiValueHier, nCmiValueMax,
			         sRugHier, nRugHier, sRugMax, nRugMax );
             GetRug_NT( 69, "PB1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			            sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		}
    }
	else if ( i_adl_tot_L>=0 && i_adl_tot_L<=1 )
	{
	    if ( l_rnursing )
		{
             GetRug( 70, "PA2", nCmiArray, nCmiValueHier, nCmiValueMax,
			         sRugHier, nRugHier, sRugMax, nRugMax );
             GetRug_NT( 70, "PA2", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			            sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		}
		else
		{
             GetRug( 71, "PA1", nCmiArray, nCmiValueHier, nCmiValueMax,
			         sRugHier, nRugHier, sRugMax, nRugMax );
             GetRug_NT( 71, "PA1", nCmiArray, nCmiValueHier_NT, nCmiValueMax_NT,
			            sRugHier_NT, nRugHier_NT, sRugMax_NT, nRugMax_NT );
		}
    }

    // Begin v1.04 changes here
    if (a2300 < 20191001)
	{
		if ( A0310C=='1' || A0310C=='3' )
		{
			// Add 0==strcmp(sRehabType, "MCAR2" for V1.01.1
			/* V1.03.0 changed */
			if ( (0==strcmp(sRehabType, "MCARE")) || (0==strcmp(sRehabType, "MCAR2")) || (0==strcmp(sRehabType, "MCAR3")) ) {
				 if ( sRugMax[0] != 'R' )
				 {
					  strcpy( sRugHier, "AAA" );
					  *nRugHier = 72;
					  *nCmiValueHier = nCmiArray[72];  // Add for V1.01.1
					  strcpy( sRugMax, "AAA" );
					  *nRugMax = 72;
					  *nCmiValueMax = nCmiArray[72];  // Add for V1.01.1
					  strcpy( sRugHier_NT, "AAA" );
					  *nRugHier_NT = 72;
					  *nCmiValueHier_NT = nCmiArray[72];  // Add for V1.01.1
					  strcpy( sRugMax_NT, "AAA" );
					  *nRugMax_NT = 72;
					  *nCmiValueMax_NT = nCmiArray[72];  // Add for V1.01.1
					  *nError = 5;
				 }
				 else if ( (A0310A[0]=='9' && A0310A[1]=='9') &&
					   ((A0310B[0]=='9' && A0310B[1]=='9') || (A0310B[0]=='0' && A0310B[1]=='7')) &&
					   A0310C=='1' && A0310D!='1' )
				 {
					   strcpy( sRugHier_NT, "AAA" );
					   *nRugHier_NT = 72;
					   *nCmiValueHier_NT = nCmiArray[72];  // Add for V1.01.1
					   strcpy( sRugMax_NT, "AAA" );
					   *nRugMax_NT = 72;
					   *nCmiValueMax_NT = nCmiArray[72];  // Add for V1.01.1
				 }
			}
			else {
					if ( (A0310A[0]=='9' && A0310A[1]=='9') &&
						 ((A0310B[0]=='9' && A0310B[1]=='9') || (A0310B[0]=='0' && A0310B[1]=='7')) &&
						 A0310C=='1' && A0310D!='1' )
					{
						strcpy( sRugHier, "AAA" );
						*nRugHier = 72;
						*nCmiValueHier = nCmiArray[72];  // Add for V1.01.1
						strcpy( sRugMax, "AAA" );
						*nRugMax = 72;
						*nCmiValueMax = nCmiArray[72];  // Add for V1.01.1
						strcpy( sRugHier_NT, "AAA" );
						*nRugHier_NT = 72;
						*nCmiValueHier_NT = nCmiArray[72];  // Add for V1.01.1
						strcpy( sRugMax_NT, "AAA" );
						*nRugMax_NT = 72;
						*nCmiValueMax_NT = nCmiArray[72];  // Add for V1.01.1
					 }
			}
		}

		char sAI_1, sAI_2;
		char O0450A = sMdsRecord[1428];

		sAI_1 = ' ';
		sAI_2 = ' ';
		if ( A0310B[0]=='0' && A0310B[1]=='7' ) sAI_1 = '0';
		else if ( A0310B[0]=='0' && (A0310B[1]=='1' || A0310B[1]=='6')   ) sAI_1 = '1';
		else if ( A0310B[0]=='0' && A0310B[1]=='2' ) sAI_1 = '2';
		else if ( A0310B[0]=='0' && A0310B[1]=='3' ) sAI_1 = '3';
		else if ( A0310B[0]=='0' && A0310B[1]=='4' ) sAI_1 = '4';
		else if ( A0310B[0]=='0' && A0310B[1]=='5' ) sAI_1 = '5';
		else if ( atoi(A0310A)>=1 && atoi(A0310A)<=6 && (A0310B[0]=='9' && A0310B[1]=='9') ) sAI_1 = '6';
		else sAI_1 = 'X';
		sAI_2 = '0';
		if ( (A0310B[0]=='9' && A0310B[1]=='9') ||
			 ((atoi(A0310B)>=1 && atoi(A0310B)<=6) &&
			  (0!=strcmp(A0310A,"04") && 0!=strcmp(A0310A,"05") && A0310D!='1' && A0310C=='0')) )
			 sAI_2 = '0';
		else if ( (0==strcmp(A0310A,"04") || 0==strcmp(A0310A,"05") || A0310D=='1') && A0310C=='0' )
			 sAI_2 = '1';
		else if ( A0310C=='1' && (0!=strcmp(A0310A,"04") && 0!=strcmp(A0310A,"05") && A0310D!='1'
				  && l_Mcare_short_stay_L==0) ) sAI_2 = '2';
		else if ( A0310C=='1' && (0==strcmp(A0310A,"04") || 0==strcmp(A0310A,"05") || A0310D=='1')
				  && l_Mcare_short_stay_L==0 ) sAI_2 = '3';
		else if ( A0310C=='2' && O0450A!='1' ) sAI_2 = '4'; //V1.01.1
		else if ( A0310C=='3' && O0450A!='1' && (0!=strcmp(A0310A,"04") && 0!=strcmp(A0310A,"05")
				  && A0310D!='1' && l_Mcare_short_stay_L==0) ) sAI_2 = '5'; //V1.01.1
		else if ( A0310C=='3' && O0450A!='1' && (0==strcmp(A0310A,"04") || 0==strcmp(A0310A,"05") || A0310D=='1')
				  && l_Mcare_short_stay_L==0 ) sAI_2 = '6'; //V1.01.1
		else if ( A0310C=='2' && O0450A=='1' ) sAI_2 = 'A'; //V1.01.1
		else if ( A0310C=='3' && O0450A=='1' && (0!=strcmp(A0310A,"04") && 0!=strcmp(A0310A,"05")
				  && A0310D!='1' && l_Mcare_short_stay_L==0) ) sAI_2 = 'B'; //V1.01.1
		else if ( A0310C=='3' && O0450A=='1' && (0==strcmp(A0310A,"04") || 0==strcmp(A0310A,"05") || A0310D=='1')
				  && l_Mcare_short_stay_L==0 ) sAI_2 = 'C'; //V1.01.1
		if ( A0310C=='4' ) sAI_2 = 'D'; //V1.01.1
		if ( l_Mcare_short_stay_L==1 ) sAI_2 = '7';
		if ( sAI_1 == 'X' ) sAI_2 = ' ';
		sAI_code[0] = sAI_1;
		sAI_code[1] = sAI_2;
		sAI_code[2] = '\0';
		if( 0 == strcmp(sRugHier, "AAA") ) strcpy( sAI_code, "00" );
	}
	else
	{
		if ((A0300A[0]=='1') && ( A0300B[0]=='1' || A0300B[0]=='3' ))
		{
			// Add 0==strcmp(sRehabType, "MCAR2" for V1.01.1
			/* V1.03.0 changed */
			if ( (0==strcmp(sRehabType, "MCARE")) || (0==strcmp(sRehabType, "MCAR2")) || (0==strcmp(sRehabType, "MCAR3")) ) {
				 if ( sRugMax[0] != 'R' )
				 {
					  strcpy( sRugHier, "AAA" );
					  *nRugHier = 72;
					  *nCmiValueHier = nCmiArray[72];  // Add for V1.01.1
					  strcpy( sRugMax, "AAA" );
					  *nRugMax = 72;
					  *nCmiValueMax = nCmiArray[72];  // Add for V1.01.1
					  strcpy( sRugHier_NT, "AAA" );
					  *nRugHier_NT = 72;
					  *nCmiValueHier_NT = nCmiArray[72];  // Add for V1.01.1
					  strcpy( sRugMax_NT, "AAA" );
					  *nRugMax_NT = 72;
					  *nCmiValueMax_NT = nCmiArray[72];  // Add for V1.01.1
					  *nError = 5;
				 }
				 /*    1.04.1 commented out    else if (A0300B[0]=='1')
				 {
					   strcpy( sRugHier_NT, "AAA" );
					   *nRugHier_NT = 72;
					   *nCmiValueHier_NT = nCmiArray[72];  // Add for V1.01.1
					   strcpy( sRugMax_NT, "AAA" );
					   *nRugMax_NT = 72;
					   *nCmiValueMax_NT = nCmiArray[72];  // Add for V1.01.1
				 }
				 */
			}
			/* else {
					if (A0300B[0]=='1')
					{
						strcpy( sRugHier, "AAA" );
						*nRugHier = 72;
						*nCmiValueHier = nCmiArray[72];  // Add for V1.01.1
						strcpy( sRugMax, "AAA" );
						*nRugMax = 72;
						*nCmiValueMax = nCmiArray[72];  // Add for V1.01.1
						strcpy( sRugHier_NT, "AAA" );
						*nRugHier_NT = 72;
						*nCmiValueHier_NT = nCmiArray[72];  // Add for V1.01.1
						strcpy( sRugMax_NT, "AAA" );
						*nRugMax_NT = 72;
						*nCmiValueMax_NT = nCmiArray[72];  // Add for V1.01.1
					 }
			}
			end of 1.04.1 comment out */
		}

		char sAI_1, sAI_2;
		char O0450A = sMdsRecord[1428];

		sAI_1 = ' ';
		sAI_2 = ' ';
		if (A0300A[0]=='0')
		{
			if ( A0310B[0]=='0' && (A0310B[1]=='1')   ) sAI_1 = '1';
			//else if ( A0310B[0]=='0' && A0310B[1]=='8' ) sAI_1 = '8';  NOT DOING IPA
			else if ( atoi(A0310A)>=1 && atoi(A0310A)<=6 && (A0310B[0]=='9' && A0310B[1]=='9') ) sAI_1 = '6';
		}
		//else sAI_1 = 'X';
		//1.04 - Assessment indicator for OSAs will be "ZZ"
		else sAI_1 = 'Z';

		sAI_2 = '0';
		if (A0300A[0]=='0')
		{
			if ( (A0310B[0]=='9' && A0310B[1]=='9') ||
				 ((atoi(A0310B)>=1 && atoi(A0310B)<=8) &&
				  (0!=strcmp(A0310A,"04") && 0!=strcmp(A0310A,"05"))) )
				 sAI_2 = '0';
			else if ( (0==strcmp(A0310A,"04") || 0==strcmp(A0310A,"05")))
				 sAI_2 = '1';
		}
		else {
			//1.04 - Assessment indicator for OSAs will be "ZZ"
			sAI_2 = 'Z';

			////if ( (A0310B[0]=='9' && A0310B[1]=='9') ||
			////	 ((atoi(A0310B)>=1 && atoi(A0310B)<=6) &&
			////	  (0!=strcmp(A0310A,"04") && 0!=strcmp(A0310A,"05") && A0310D!='1' && A0310C=='0')) )
			////	 sAI_2 = '0';
			////else if ( (0==strcmp(A0310A,"04") || 0==strcmp(A0310A,"05") || A0310D=='1') && A0310C=='0' )
			////    sAI_2 = '1';
			//if (A0300B[0]=='0') sAI_2 = '0';
			//else if ( A0300B[0]=='1' &&  l_Mcare_short_stay_L==0 ) sAI_2 = '2';
			////1.04.0 - A0310A not active on OSAs, so can't get '3' as a result
			////if ( A0300B=='1' && (0!=strcmp(A0310A,"04") && 0!=strcmp(A0310A,"05")
			////		  && l_Mcare_short_stay_L==0) ) sAI_2 = '2';
			////else if ( A0300B=='1' && (0==strcmp(A0310A,"04") || 0==strcmp(A0310A,"05"))
			////		  && l_Mcare_short_stay_L==0 ) sAI_2 = '3';
			//else if ( A0300B[0]=='2' && O0450A!='1' ) sAI_2 = '4'; //V1.01.1
			//else if ( A0300B[0]=='3' && O0450A!='1' && l_Mcare_short_stay_L==0 ) sAI_2 = '5'; //V1.01.1
			////1.04.0 - A0310A not active on OSAs, so can't get '6' as a result
			////else if ( A0300B=='3' && O0450A!='1' && (0!=strcmp(A0310A,"04") && 0!=strcmp(A0310A,"05")
			////		  && l_Mcare_short_stay_L==0) ) sAI_2 = '5'; //V1.01.1
			////else if ( A0300B=='3' && O0450A!='1' && (0==strcmp(A0310A,"04") || 0==strcmp(A0310A,"05"))
			////		  && l_Mcare_short_stay_L==0 ) sAI_2 = '6'; //V1.01.1
			//else if ( A0300B[0]=='2' && O0450A=='1' ) sAI_2 = 'A'; //V1.01.1
			//else if ( A0300B[0]=='3' && O0450A=='1' && l_Mcare_short_stay_L==0 ) sAI_2 = 'B'; //V1.01.1
			////1.04.0 - A0310A not active on OSAs, so can't get 'C' as a result
			////else if ( A0300B=='3' && O0450A=='1' && (0!=strcmp(A0310A,"04") && 0!=strcmp(A0310A,"05")
			////		  && l_Mcare_short_stay_L==0) ) sAI_2 = 'B'; //V1.01.1
			////else if ( A0300B=='3' && O0450A=='1' && (0==strcmp(A0310A,"04") || 0==strcmp(A0310A,"05"))
			////		  && l_Mcare_short_stay_L==0 ) sAI_2 = 'C'; //V1.01.1
			//if ( A0300B[0]=='4' ) sAI_2 = 'D'; //V1.01.1
		}
		if (A0300A[0]=='0')
		{
			if ( l_Mcare_short_stay_L==1 ) sAI_2 = '7';
			if ( sAI_1 == 'X' ) sAI_2 = ' ';
		}
		sAI_code[0] = sAI_1;
		sAI_code[1] = sAI_2;
		sAI_code[2] = '\0';
		// 1.04.1 - allow ZZ for assessment indicator for AAA if OSA
		if (A0300A[0]=='0')
		{
		   if( 0 == strcmp(sRugHier, "AAA") ) strcpy( sAI_code, "00" );
		}
	}

	return 0;
}

