
/*********************************************************************************\

PROGRAM:      		BSA_Carrier_Line_Items_PUF_2008.sas

DESCRIPTION:  		To read csv format CARRIER PUFs to SAS dataset
 	
INPUT FILES:   		2008_BSA_Carrier_Line_Items_PUF_1.csv,2008_BSA_Carrier_Line_Items_PUF_2.csv,2008_BSA_Carrier_Line_Items_PUF_3.csv,
			        2008_BSA_Carrier_Line_Items_PUF_4.csv,2008_BSA_Carrier_Line_Items_PUF_5.csv,2008_BSA_Carrier_Line_Items_PUF_6.csv,
					2008_BSA_Carrier_Line_Items_PUF_7.csv

OUTPUT FILES:       BSA_Carrier_Line_Items_PUF_2008.sas7bdat

OTHER OUTPUT:		Contents, proc print and freq distribution

                       
\*********************************************************************************/
              
FOOTNOTE 'BSA_Carrier_Line_Items_PUF_2008.sas';

* Log/List Options *;
options ls=120 ps=42 missing=' ' nocenter validvarname=upcase compress=binary;

%let in1= PLACE_INPUT DIRECTORY PATH ;*Place  File Path where csv files are downloaded ; 

* Output SAS Library *;
libname PUF 'INSERT_OUTPUT_DIRECTORY_NAME'; * <-- Place Output Library Path Here *;



%macro readin(fname=,part=,oname=);
*Formats Code : Uncomment the following if want to include formats *;
/*
Proc format;

Value SEXF
	1 = 'MALE '
	2 = 'FEMALE'
;

Value AGEF
	1	= 'Under  65 '
	2	= '65 - 69 '
	3	= '70 - 74 '
	4	= '75 - 79 '
	5	= '80 - 84 '
	6	= '85 & Older'
;

run;
  */

data PUF.&oname.(label="BSA CARRIER PUBLIC USE FILE PART &part");

infile "&in1.\&fname..csv" dlm = ',' dsd missover truncover firstobs = 2 ;
 
  * Input Record *;
  input CAR_LINE_ID          :$20.                
  		BENE_SEX_IDENT_CD                 
		BENE_AGE_CAT_CD              
		CAR_LINE_ICD9_DGNS_CD :$4.
		CAR_LINE_HCPCS_CD 	:$5.
		CAR_LINE_BETOS_CD 	:$3.
		CAR_LINE_SRVC_CNT 	:3.
		CAR_LINE_PRVDR_TYPE_CD  :$1.
		CAR_LINE_CMS_TYPE_SRVC_CD :$1.
		CAR_LINE_PLACE_OF_SRVC_CD  :$2.
		CAR_HCPCS_PMT_AMT
  ;
  
 
  * Formats *;
 
*** Uncomment following to apply formats ;	
/*
BENE_SEX_IDENT=BENE_SEX_IDENT_CD;
BENE_AGE_CAT=BENE_AGE_CAT_CD ;

  format  
	BENE_SEX_IDENT                      SEXF.
    BENE_AGE_CAT					    AGEF.
    
  ;	

  label  BENE_SEX_IDENT 		= "Beneficiary gender"
  		 BENE_AGE_CAT			= "Beneficiary Age"
		 ;
*/

  * Labels *;
  label CAR_LINE_ID                       = "CARRIER LINE ID"
  		BENE_SEX_IDENT_CD                 = "Beneficiary gender code "
		BENE_AGE_CAT_CD                   = "Beneficiary Age category code "
		CAR_LINE_ICD9_DGNS_CD			  = "3 digit ICD9 Diagnosis codes"	
		CAR_LINE_HCPCS_CD				  = "HCPCS Level 1 codes"	
		CAR_LINE_BETOS_CD 				  = "BETOS code"	
		CAR_LINE_SRVC_CNT				  = "counts of services"	
		CAR_LINE_PRVDR_TYPE_CD 			  = "code for the type of provider furnishing the service. "
		CAR_LINE_CMS_TYPE_SRVC_CD		  = "Code indicating type of service"
		CAR_LINE_PLACE_OF_SRVC_CD 		  = "Code indicating place of service"
		CAR_HCPCS_PMT_AMT 				  = "Medicare Payment amount"
		 					
;
 
run;

/*Uncomment this for creating SAS DATASET with descriptions for ICD9 CODES,Provider type code,
type of service,place of service Betos codes*/


/*
data  ICD9_CODES;
infile "&in1.\ICD9_CODES.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input  LINE_ICD9_DGNS_CD :$4. ICD9_DESC :$175. ;
run;

data  prvdr_type_CODES;
infile "&in1.\prvdr_type_CODES.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input  LINE_PRVDR_TYPE_CD :$1. PRVDR_TYPE_DESC:$300. ;
run;

data  type_srvc_CODES;
infile "&in1.\type_srvc_CODES.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input   LINE_CMS_TYPE_SRVC_CD:$1. TYPE_SRVC_DESC :$300.;
run;

data  place_srvc_CODES;
infile "&in1.\place_srvc_CODES.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input  LINE_PLACE_OF_SRVC_CD:$2. PLACE_SRVC_DESC :$300.;
run;

data  BETOS_CODES;
infile "&in1.\BETOS_CODES.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input  CAR_LINE_BETOS_CD:$3. BETOS_DESC :$300.;
run;


Proc SQL;
Create Table  PUF.&oname. as select  a.*, b.ICD9_DESC,C.PRVDR_TYPE_DESC,
d.TYPE_SRVC_DESC,e.PLACE_SRVC_DESC ,f.BETOS_DESC
from PUF.&oname. as a left join ICD9_CODES as b 
on  a.CAR_LINE_ICD9_DGNS_CD = b.LINE_ICD9_DGNS_CD	left join  prvdr_type_CODES as c on a.CAR_LINE_PRVDR_TYPE_CD=c.LINE_PRVDR_TYPE_CD 
left join type_srvc_CODES as d on a.CAR_LINE_CMS_TYPE_SRVC_CD=d.LINE_CMS_TYPE_SRVC_CD left join place_srvc_CODES
as e on a.CAR_LINE_PLACE_OF_SRVC_CD=e.LINE_PLACE_OF_SRVC_CD LEFT JOIN BETOS_CODES AS F ON a.CAR_LINE_BETOS_CD=
f.CAR_LINE_BETOS_CD;
Quit;



data  PUF.&oname.;

retain 	CAR_LINE_ID BENE_SEX_IDENT_CD BENE_SEX_IDENT BENE_AGE_CAT_CD BENE_AGE_CAT CAR_LINE_ICD9_DGNS_CD ICD9_DESC
CAR_LINE_HCPCS_CD CAR_LINE_BETOS_CD BETOS_DESC CAR_LINE_SRVC_CNT CAR_LINE_PRVDR_TYPE_CD PRVDR_TYPE_DESC
CAR_LINE_CMS_TYPE_SRVC_CD TYPE_SRVC_DESC CAR_LINE_PLACE_OF_SRVC_CD PLACE_SRVC_DESC CAR_HCPCS_PMT_AMT;

set PUF.&oname.;

label    ICD9_DESC		     		= "ICD9 Description "
  		 PRVDR_TYPE_DESC			= "Provider Type Description"
		 TYPE_SRVC_DESC				= "Type of service Description"
		 PLACE_SRVC_DESC			= "Place of service Description"
		 BETOS_DESC					= "Betos Description"

  ;
run;

*/


%mend;

/* calling readin  macro seperately for each dataset*/

%readin(fname=2008_BSA_Carrier_Line_Items_PUF_1,part=1,oname=BSA_CARRIER_PUF_2008_part1);
%readin(fname=2008_BSA_Carrier_Line_Items_PUF_2,part=2,oname=BSA_CARRIER_PUF_2008_part2);
%readin(fname=2008_BSA_Carrier_Line_Items_PUF_3,part=3,oname=BSA_CARRIER_PUF_2008_part3);
%readin(fname=2008_BSA_Carrier_Line_Items_PUF_4,part=4,oname=BSA_CARRIER_PUF_2008_part4);
%readin(fname=2008_BSA_Carrier_Line_Items_PUF_5,part=5,oname=BSA_CARRIER_PUF_2008_part5);
%readin(fname=2008_BSA_Carrier_Line_Items_PUF_6,part=6,oname=BSA_CARRIER_PUF_2008_part6);
%readin(fname=2008_BSA_Carrier_Line_Items_PUF_7,part=7,oname=BSA_CARRIER_PUF_2008_part7);


/* After preparing all seven files, use this code to append them together */
 


data puf.BSA_Carrier_Line_Items_PUF_2008;
set puf.BSA_CARRIER_PUF_2008_part1 
	puf.BSA_CARRIER_PUF_2008_part2
	puf.BSA_CARRIER_PUF_2008_part3 
	puf.BSA_CARRIER_PUF_2008_part4
	puf.BSA_CARRIER_PUF_2008_part5
	puf.BSA_CARRIER_PUF_2008_part6
	puf.BSA_CARRIER_PUF_2008_part7;
run;



proc contents data=PUF.BSA_Carrier_Line_Items_PUF_2008 varnum ;

title "CARRIER PUBLIC USE FILE";
run;

proc print data=PUF.BSA_Carrier_Line_Items_PUF_2008(obs=10);
  title2 "Sample Listing - 10 Rows ";
run;


proc freq data=PUF.BSA_Carrier_Line_Items_PUF_2008;
  title2 "Freqs ";
  table                        
  		BENE_SEX_IDENT_CD                 
		BENE_AGE_CAT_CD              
		CAR_LINE_ICD9_DGNS_CD 
		CAR_LINE_HCPCS_CD 	
		CAR_LINE_BETOS_CD 	
		CAR_LINE_SRVC_CNT 	
		CAR_LINE_PRVDR_TYPE_CD  
		CAR_LINE_CMS_TYPE_SRVC_CD 
		CAR_LINE_PLACE_OF_SRVC_CD 
		CAR_HCPCS_PMT_AMT/missing ; 
        
run;

/* Uncomment to sort the final sas dataset */

/*
proc sort data=PUF.BSA_Carrier_Line_Items_PUF_2008;
by CAR_LINE_ID;
run;*/

* End of Program *;

