
/*********************************************************************************\

PROGRAM:      		BSA_DME_PUF_2008.sas

DESCRIPTION:  		To read csv format DME PUF to SAS dataset
 	
INPUT FILES:   		BSA_DME_PUF_2008.csv

OUTPUT FILES:       BSA_DME_PUF_2008.sas7bdat

OTHER OUTPUT:		Contents, proc print and freq distribution

                       
\*********************************************************************************/
              
FOOTNOTE 'BSA_DME_PUF_2008.sas';

* Log/List Options *;
options ls=120 ps=42 missing=' ' nocenter validvarname=upcase compress=binary;

* Input File Reference *;
filename in "INSERT_INPUT_DIRECTORY_NAME\2008_BSA_DME_Line_Items_PUF.csv" ; * <-- Place Input File Path Here *;
%let in1= PLACE_INPUT DIRECTORY PATH ;*Place  File Path where csv files are downloaded ; 

* Output SAS Library *;
libname PUF 'INSERT_OUTPUT_DIRECTORY_NAME'; * <-- Place Output Library Path Here *;


*Formats Code : Uncomment the following if want to include formats *;
/*
Proc format;

Value SEXF
	1 = 'MALE '
	2 = 'FEMALE'
;

Value AGEF
	1	= 'Under  65 '
	2	= '65 - 69 '
	3	= '70 - 74 '
	4	= '75 - 79 '
	5	= '80 - 84 '
	6	= '85 & Older'
;

run;
*/
  
data PUF.BSA_DME_PUF_2008(label='BSA DME PUBLIC USE FILE');

infile in dlm = ',' dsd missover truncover firstobs = 2;
 
  * Input Record *;
  input DME_LINE_ID          	:$20.                
  		BENE_SEX_IDENT_CD                 
		BENE_AGE_CAT_CD              
		DME_LINE_ICD9_DGNS_CD 	:$4.		 
		DME_LINE_HCPCS_CD		:$5.		 
		DME_LINE_SRVC_CNT 		:3.		  
		DME_LINE_PMT_AMT
  ;
  
 
  * Formats *;
 
*** Uncomment following to apply formats ;	
/*
BENE_SEX_IDENT=BENE_SEX_IDENT_CD;
BENE_AGE_CAT=BENE_AGE_CAT_CD ;

  format  
	BENE_SEX_IDENT                      SEXF.
    BENE_AGE_CAT						AGEF.
    
  ;	

  label  BENE_SEX_IDENT 		= "Beneficiary gender"
  		 BENE_AGE_CAT			= "Beneficiary Age"
		 ;

*/

  * Labels *;
  label DME_LINE_ID                       = "DME LINE ID"
  		BENE_SEX_IDENT_CD                 = "Beneficiary gender code "
		BENE_AGE_CAT_CD                   = "Beneficiary Age category code "
		DME_LINE_ICD9_DGNS_CD 			  = "3 Digit Diagnosis code"
		DME_LINE_HCPCS_CD				  = "HCPCS Code"
		DME_LINE_SRVC_CNT 				  = "No of Services per line item"
		DME_LINE_PMT_AMT 				  = "Medicare Payment"
		 					
;
 
run;


/*Uncomment this for creating SAS DATASET with descriptions for HCPCS AND ICD9 CODES */
/*
data  HCPCS_CODES;	
infile "&in1.\HCPCS_CODES_LOOKUP.csv" dsd  missover truncover firstobs=2;
input  HCPCS_CD :$5. HCPCS_SHORT_DESCRIPTION :$30.;
run;

data  ICD9_CODES;
infile "&in1.\ICD9_CODES_LOOKUP.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input  ICD9_CD :$4. ICD9_DESC :$175. ;
run;

Proc SQL;
Create Table  PUF.BSA_DME_PUF_2008 as select  a.*, b.ICD9_DESC,C.HCPCS_SHORT_DESCRIPTION 
from PUF.BSA_DME_PUF_2008 as a left join ICD9_CODES as b 
on  a.DME_LINE_ICD9_DGNS_CD = b.ICD9_CD	left join  HCPCS_CODES as c on a.DME_LINE_HCPCS_CD=c.HCPCS_CD ;
Quit;


data  PUF.BSA_DME_PUF_2008;

retain 	DME_LINE_ID  BENE_SEX_IDENT_CD BENE_SEX_IDENT	BENE_AGE_CAT_CD  BENE_AGE_CAT
DME_LINE_ICD9_DGNS_CD 	ICD9_DESC DME_LINE_HCPCS_CD  HCPCS_SHORT_DESCRIPTION DME_LINE_SRVC_CNT
DME_LINE_PMT_AMT;

set PUF.BSA_DME_PUF_2008;

label    ICD9_DESC      		= "ICD9 Description "
  		 HCPCS_SHORT_DESCRIPTION= "HCPCS Short Description"
  ;
run;
*/

title 'DME PUBLIC USE FILE';

proc contents data=PUF.BSA_DME_PUF_2008 varnum;

proc print data=PUF.BSA_DME_PUF_2008 (obs=10);
  title2 'Sample Listing - 10 Rows';
run;


proc freq data=PUF.BSA_DME_PUF_2008;
  title2 'Freqs';
  table BENE_SEX_IDENT_CD                       
		BENE_AGE_CAT_CD               
        DME_LINE_ICD9_DGNS_CD 			 
		DME_LINE_HCPCS_CD			 
		DME_LINE_SRVC_CNT 			  
		DME_LINE_PMT_AMT  /missing;
run;
 
* End of Program *;
