
/*********************************************************************************\

PROGRAM:      		BSA_HHA_BENEFICIARY_PUF_2008.sas

DESCRIPTION:  		To read csv format HHA PUF to SAS dataset
 	
INPUT FILES:   		2008_BSA_HHA_Beneficiary_PUF.csv

OUTPUT FILES:       BSA_HHA_BENEFICIARY_PUF_2008.sas7bdat

OTHER OUTPUT:		Contents, proc print and freq distribution

                       
\*********************************************************************************/
              
FOOTNOTE 'BSA_HHA_PUF_2008.sas';

* Log/List Options *;
options ls=120 ps=42 missing=' ' nocenter validvarname=upcase compress=binary;

* Input File Reference *;
filename in "INSERT_INPUT_DIRECTORY_NAME\2008_BSA_HHA_Beneficiary_PUF.csv" ;  * <-- Place Input File Path Here *;

* Output SAS Library *;
libname PUF 'INSERT_OUTPUT_DIRECTORY_NAME'; * <-- Place Output Library Path Here *;
 

*Formats Code : Uncomment the following if want to include formats *; /*

Proc format;

Value SEXF
	1 = 'MALE '
	2 = 'FEMALE'
;

Value AGEF
	1	= 'Under  65 '
	2	= '65 - 69 '
	3	= '70 - 74 '
	4	= '75 - 79 '
	5	= '80 - 84 '
	6	= '85 & Older'

;



Value ADMISSIONF
	1 =  '1 admission'
	2 =  '2 or more admissions'
	
;

Value THERAPYF

    0 =  "0 visit"
	1 =  "1-13 visits"
	2 =  "14-19 visits"
	3 =  "20 or more visits"
;

Value SNCF

    0 =  "0 visit"
	1 =  "1-13 visits"
	2 =  "14-19 visits"
	3 =  "20 or more visits"
;

Value HHAF

    0 =  "0 visit"
	1 =  "1-13 visits"
	2 =  "14-19 visits"
	3 =  "20 or more visits"
;

*/
data PUF.BSA_HHA_BENEFICIARY_PUF_2008(label='HHA PUBLIC USE FILE');

infile in dlm = ',' dsd missover truncover firstobs = 2;
 
  * Input Record *;
  input HHA_BENE_ID 					   :$19.	
       	BENE_SEX_IDENT_CD                   
        BENE_AGE_CAT_CD                     
        HHA_ADM_CD                  
        HHA_THER_VST_CD                             
        HHA_SNC_VST_CD 
        HHA_HHA_VST_CD 
		HHA_PMT_AMT 
  ;
  

 
  * Formats *;
 
*** Uncomment following to apply formats ;	/*
format  
	BENE_SEX_IDENT_CD                      SEXF.
    BENE_AGE_CAT_CD						   AGEF.
    HHA_ADM_CD                             ADMISSIONF.
    HHA_THER_VST_CD                        THERAPYF.     
    HHA_SNC_VST_CD 	                       SNCF.
    HHA_HHA_VST_CD 	                       HHAF.
  ;	
*/
 
  * Labels *;
  label HHA_BENE_ID                       = "Encrypted PUF ID"
  		BENE_SEX_IDENT_CD                 = "Beneficiary gender code "
		BENE_AGE_CAT_CD                   = "Beneficiary Age category code"
		HHA_ADM_CD                        = "Total number of admissions code"
		HHA_THER_VST_CD                   = "Therapy visits  code"
		HHA_SNC_VST_CD                    = "Skilled nursing care visits code"
		HHA_HHA_VST_CD                    = "Home health aide visits code"
		HHA_PMT_AMT                       = "Total Medicare payment"
                      
;
 
  
run;
 
title 'HHA PUBLIC USE FILE';
proc contents data=PUF.BSA_HHA_BENEFICIARY_PUF_2008 varnum;
proc print data=PUF.BSA_HHA_BENEFICIARY_PUF_2008 (obs=10);
  title2 'Sample Listing - 10 Rows';
run;


proc freq data=PUF.BSA_HHA_BENEFICIARY_PUF_2008;
  title2 'Freqs';
  table BENE_SEX_IDENT_CD                   
        BENE_AGE_CAT_CD                     
        HHA_ADM_CD                  
        HHA_THER_VST_CD                             
        HHA_SNC_VST_CD 
        HHA_HHA_VST_CD 
		HHA_PMT_AMT   /missing;
run;
 
* End of Program *;

