
/*********************************************************************************\

PROGRAM:      		$/PUF/R2/Dev/Hospice/1/BSA_Hospice_Beneficiary_PUF_2008.sas

DESCRIPTION:  		To read csv format Hospice PUF to SAS dataset
 	
INPUT FILES:   		BSA_Hospice_Beneficiary_PUF_2008.csv

OUTPUT FILES:       BSA_Hospice_Beneficiary_PUF_2008.sas7bdat

OTHER OUTPUT:		Contents, proc print and freq distribution

                       
\*********************************************************************************/
              
FOOTNOTE 'BSA_Hospice_Beneficiary_PUF_2008.sas';

* Log/List Options *;
options ls=120 ps=42 missing=' ' nocenter validvarname=upcase compress=binary;

* Input File Reference *;
filename in "INSERT_INPUT_DIRECTORY_NAME\2008_BSA_Hospice_Beneficiary_PUF.csv" ;  * <-- Place Input File Path Here *;

* Output SAS Library *;
libname PUF 'INSERT_OUTPUT_DIRECTORY_NAME'; * <-- Place Output Library Path Here *;

*Formats Code : Formats will be included if the following is uncommented *;
/*
Proc format;

Value SEXF
	1 = 'MALE'
	2 = 'FEMALE'
;

Value AGEF
	1	= 'Under 65'
	2	= '65 - 69'
	3	= '70 - 74 '
	4	= '75 - 79 '
	5	= '80 - 84 '
	6	= '85 - 89'
	7	= '90 & Older'

;


Value DXF
	1 =  "Non-Alzheimers Dementia"
	2 =  "Debility, unspecified"
	3 =  "Lung Cancer"
	4 =  "Congestive Heart Failure (CHF)"
	5 =  "Non-infectious Respiratory Disease"
	6 =  "Other"
;

Value CANCERF
	1 =  "Cancer"
	0 =  "Non-Cancer"
	
;

Value  DAYSF
	1 =  " 1  7 days "
	2 =  " 8  30 days"
	3 =  " 31  90 days"
	4 =  " 91 to 180 days"
	5 =  " 181 or more days"
;

Value DECEASEF
	0 =  "Not deceased at discharge"
	1 =  "Deceased at discharge"
;

run;

*/
 

data PUF.BSA_Hospice_Beneficiary_PUF_2008(label='HOSPICE BENEFICIARY PUBLIC USE FILE');

infile in dlm = ',' dsd missover truncover firstobs = 2;
 
  * Input Record *;
  input HOSPC_BENE_ID 					:$22.	
       	BENE_SEX_IDENT_CD 
		BENE_AGE_CAT_CD
		HOSPC_DECEASED_CD 
		HOSPC_DX_CD                  
		HOSPC_CANCER_CD                              
		HOSPC_DAYS_CD  				
		HOSPC_PMT_AMT 
  ;

  /* Uncomment following to apply formatted and coded value */  
   /*
BENE_SEX_IDENT_CD_codedvalue=BENE_SEX_IDENT_CD;
BENE_AGE_CAT_CD_codedvalue=BENE_AGE_CAT_CD;            
HOSPC_DX_CD_codedvalue=HOSPC_DX_CD;                  
HOSPC_CANCER_CD_codedvalue=HOSPC_CANCER_CD;                              
HOSPC_DAYS_CD_codedvalue=HOSPC_DAYS_CD ;
HOSPC_DECEASED_CD_codedvalue=HOSPC_DECEASED_CD;
  */

  * Formats *;
 
*** Uncomment following to apply formats ;
/*
	format  
	BENE_SEX_IDENT_CD                  	SEXF.
    BENE_AGE_CAT_CD						AGEF.
    HOSPC_DX_CD 					   	DXF.
  	HOSPC_CANCER_CD 				   	CANCERF.
    HOSPC_DAYS_CD                     	DAYSF.
	HOSPC_DECEASED_CD 					DECEASEF.
	;
*/

   * Labels *;
  label HOSPC_BENE_ID						= "Encrypted PUF ID"
		BENE_SEX_IDENT_CD					= "Beneficiary gender code "
		BENE_AGE_CAT_CD						= "Beneficiary age category code "
		HOSPC_DECEASED_CD					= "Deceased at discharge indicator code"
		HOSPC_DX_CD							= "Terminal diagnosis code "
		HOSPC_CANCER_CD						= "Cancer terminal diagnosis code"
		HOSPC_DAYS_CD						= "Days of service code"
		HOSPC_PMT_AMT						= "Medicare payment amount"
                 
;
   
  
run;

*** Uncomment following to apply formatted and coded values ;

/*
data PUF.BSA_Hospice_Beneficiary_PUF_2008;
retain 	HOSPC_BENE_ID BENE_SEX_IDENT_CD BENE_SEX_IDENT_CD_codedvalue BENE_AGE_CAT_CD BENE_AGE_CAT_CD_codedvalue HOSPC_DX_CD HOSPC_DX_CD_codedvalue HOSPC_CANCER_CD HOSPC_CANCER_CD_codedvalue 
HOSPC_DAYS_CD HOSPC_DAYS_CD_codedvalue HOSPC_DECEASED_CD HOSPC_DECEASED_CD_codedvalue HOSPC_PMT_AMT;
set PUF.BSA_Hospice_Beneficiary_PUF_2008;
label 	BENE_SEX_IDENT_CD_codedvalue					= "Beneficiary gender code "
		BENE_AGE_CAT_CD_codedvalue						= "Beneficiary age category code "
		HOSPC_DECEASED_CD_codedvalue					= "Deceased at discharge indicator code"
		HOSPC_DX_CD_codedvalue							= "Terminal diagnosis code "
		HOSPC_CANCER_CD_codedvalue						= "Cancer terminal diagnosis code"
		HOSPC_DAYS_CD_codedvalue						= "Days of service code"
		;

run;
*/


title 'HOSPICE BENEFICIARY PUBLIC USE FILE';
proc contents data=PUF.BSA_Hospice_Beneficiary_PUF_2008 varnum;
proc print data=PUF.BSA_Hospice_Beneficiary_PUF_2008 (obs=10);
  title2 'Sample Listing - 10 Rows';
run;


proc freq data=PUF.BSA_Hospice_Beneficiary_PUF_2008;
  title2 'Freqs';
  table BENE_SEX_IDENT_CD                       
		BENE_AGE_CAT_CD               
        HOSPC_DX_CD							
		HOSPC_CANCER_CD						
		HOSPC_DAYS_CD						
		HOSPC_DECEASED_CD					
		HOSPC_PMT_AMT  /missing;
run;

* End of Program *;
