
/*********************************************************************************\

PROGRAM:      		BSA_Outpatient_Procedures_PUF_2008.sas

DESCRIPTION:  		To read csv format Outpatient PUF to SAS dataset
 	
INPUT FILES:   		2008_BSA_Outpatient_Procedures_PUF_1.csv
					2008_BSA_Outpatient_Procedures_PUF_2.csv
					2008_BSA_Outpatient_Procedures_PUF_3.csv

OUTPUT FILES:       BSA_Outpatient_PUF_2008.sas7bdat

OTHER OUTPUT:		Contents, proc print and freq distribution

                       
\*********************************************************************************/
              
FOOTNOTE 'BSA_Outpatient_Procedures_PUF_2008.sas';

* Log/List Options *;
options ls=120 ps=42 missing=' ' nocenter validvarname=upcase compress=binary;

%let in1= PLACE_INPUT DIRECTORY PATH ;*Place  File Path where csv files are downloaded ; 

* Output SAS Library *;
libname PUF 'INSERT_OUTPUT_DIRECTORY_NAME'; * <-- Place Output Library Path Here *;



%macro readin(fname=,part=,oname=);

*Formats Code : Formats will be included if the following is uncommented *;
/*
Proc format;

Value SEXF
	1 = 'MALE'
	2 = 'FEMALE'
;

Value AGEF
	1	= 'Under 65'
	2	= '65 - 69'
	3	= '70 - 74 '
	4	= '75 - 79 '
	5	= '80 - 84 '
	6	= '85 or Older'
;

run;
*/
 

data PUF.&oname.(label="OUTPATIENT BENEFICIARY PUBLIC USE FILE");

infile "&in1.\&fname..csv" dlm = ',' dsd missover truncover firstobs = 2 ;
 
  * Input Record *;
  input OP_PROC_ID 					:$22.	
       	BENE_SEX_IDENT_CD 
		BENE_AGE_CAT_CD
		OP_CLM_ICD9_DIAG_CD			:$4.
		OP_HCPCS_CD					:$5.			
		OP_HCPCS_UNIT_CNT
		OP_HCPCS_PMT_AMT		
		
  ;

  /* Uncomment following to apply formatted and coded value */  
  
/*	BENE_SEX_IDENT_CD_codedvalue=BENE_SEX_IDENT_CD;
	BENE_AGE_CAT_CD_codedvalue=BENE_AGE_CAT_CD;            
 	;
*/

  * Formats *;
 
*** Uncomment following to apply formats ;
/*
	format  
	BENE_SEX_IDENT_CD                  	SEXF.
    BENE_AGE_CAT_CD						AGEF.
   	;
*/

   * Labels *;
  label OP_PROC_ID							= "Encrypted PUF ID"
		BENE_SEX_IDENT_CD					= "Beneficiary Gender Code"
		BENE_AGE_CAT_CD						= "Beneficiary Age Category code"
		OP_CLM_ICD9_DIAG_CD					= "ICD9 Primary Diagnosis Code"
		OP_HCPCS_CD							= "HCPCS Procedure Code"
		OP_HCPCS_UNIT_CNT 					= "Count of Services"
		OP_HCPCS_PMT_AMT 					= "Medicare Payment Amount"
                 
;
   
  
run;

/*Uncomment this for creating SAS DATASET with descriptions for ICD9 CODES*/

/*
data  ICD9_CODES;
infile "&in1.\THREE_DIGIT_ICD9_CODE_CATEGORIES.csv" dsd  missover truncover firstobs=2 lrecl=1000;
input  icd9_cd :$4. ICD9_DESCRIPTION :$175. ;
run;

proc sql;
create table PUF.&oname. as 
select a.*, b.ICD9_DESCRIPTION 
from  PUF.&oname. a left join ICD9_CODES b
on a.OP_CLM_ICD9_DIAG_CD= b.ICD9_CD;
quit;


data PUF.&oname.;
retain 	OP_PROC_ID BENE_SEX_IDENT_CD BENE_SEX_IDENT_CD_codedvalue BENE_AGE_CAT_CD BENE_AGE_CAT_CD_codedvalue OP_CLM_ICD9_DIAG_CD 
		ICD9_DESCRIPTION OP_HCPCS_CD OP_HCPCS_UNIT_CNT OP_HCPCS_PMT_AMT;
    ;
set PUF.&oname;
label 	OP_PROC_ID							= "Encrypted PUF ID"
		BENE_SEX_IDENT_CD_codedvalue		= "Beneficiary gender code "
		BENE_AGE_CAT_CD_codedvalue			= "Beneficiary age category code "
		OP_CLM_ICD9_DIAG_CD					= "ICD9 Primary Diagnosis Code"
		OP_HCPCS_CD							= "HCPCS Procedure Code"
		OP_HCPCS_UNIT_CNT 					= "Count of Services"
		OP_HCPCS_PMT_AMT 					= "Medicare Payment Amount"
		;

run;

*/

%mend;

/* calling readin  macro seperately for each dataset*/

%readin(fname=2008_BSA_Outpatient_Procedures_PUF_1,part=1,oname=BSA_Outpatient_PUF_2008_part1);
%readin(fname=2008_BSA_Outpatient_Procedures_PUF_2,part=2,oname=BSA_Outpatient_PUF_2008_part2);
%readin(fname=2008_BSA_Outpatient_Procedures_PUF_3,part=3,oname=BSA_Outpatient_PUF_2008_part3);

/* After preparing all three files, use this code to append them together */
 

data PUF.BSA_Outpatient_PUF_2008;
set PUF.BSA_Outpatient_PUF_2008_part1
	PUF.BSA_Outpatient_PUF_2008_part2
	PUF.BSA_Outpatient_PUF_2008_part3;
run;

proc contents data=PUF.BSA_Outpatient_PUF_2008 varnum;

title "OUTPATIENT BENEFICIARY PUBLIC USE FILE ";


proc print data=PUF.BSA_Outpatient_PUF_2008(obs=10);
  title2 "Sample Listing - 10 Rows";
run;


proc freq data=PUF.BSA_Outpatient_PUF_2008;
  title2 "Freqs ";
  table BENE_SEX_IDENT_CD                       
		BENE_AGE_CAT_CD               
        OP_CLM_ICD9_DIAG_CD
		OP_HCPCS_CD
		OP_HCPCS_UNIT_CNT
		OP_HCPCS_PMT_AMT /missing;
run;

* End of Program *;

/* Uncomment to sort the final sas dataset */

/*
proc sort data=PUF.BSA_Outpatient_PUF_2008;
by OP_PROC_ID;
run;*/

* End of Program *;

